<?php

class ModelMembershipEmployplan extends Model {
 	public function addPlans($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "employplans SET  price = '" . (float)$data['price']. "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "', number = '" . (int)$data['number'] . "', type = '" . (int)$data['type'] . "', date_modified = NOW(), date_added = NOW()");

		$employplan_id = $this->db->getLastId();

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "employplans SET image = '" . $this->db->escape($data['image']) . "' WHERE employplan_id = '" . (int)$employplan_id . "'");
		}

		foreach ($data['employplans_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "employplans_description SET employplan_id = '" . (int)$employplan_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}

		if (isset($data['keyword'])) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'employplan_id=" . (int)$employplan_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}

		if (isset($data['plans_variation'])) {
			foreach ($data['plans_variation'] as $plans_variations) {
				if ($plans_variations['variation_id']) {
						$this->db->query("INSERT INTO " . DB_PREFIX . "plans_variation SET employplan_id = '" . (int)$employplan_id . "', variation_id = '" . (int)$plans_variations['variation_id'] . "'");
				}
			}
		}

		if (isset($data['plans_options'])) {
			foreach ($data['plans_options'] as $plans_options) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "plans_options SET employplan_id = '" . (int)$employplan_id . "', title = '" . $this->db->escape($plans_options['title']) . "', price = '" . $this->db->escape($plans_options['price']) . "', sort_order = '" . (int)$plans_options['sort_order'] . "'");
			}
		}

		$this->cache->delete('employplans');
		return $employplan_id;
	}

	public function editPlans($employplan_id, $data) {
	//	print_r($data); die();
		$this->db->query("UPDATE " . DB_PREFIX . "employplans SET  price = '" . (float)$data['price']. "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "',number = '" . (int)$data['number'] . "', type = '" . (int)$data['type'] . "', date_modified = NOW() WHERE employplan_id = '" . (int)$employplan_id . "'");

		if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "employplans SET image = '" . $this->db->escape($data['image']) . "' WHERE employplan_id = '" . (int)$employplan_id . "'");


		}





		$this->db->query("DELETE FROM " . DB_PREFIX . "employplans_description WHERE employplan_id = '" . (int)$employplan_id . "'");





		foreach ($data['employplans_description'] as $language_id => $value) {


			$this->db->query("INSERT INTO " . DB_PREFIX . "employplans_description SET employplan_id = '" . (int)$employplan_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "'");


		}	





		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'employplan_id=" . (int)$employplan_id . "'");





		if ($data['keyword']) {


			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'employplan_id=" . (int)$employplan_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");


		}


		


		$this->db->query("DELETE FROM " . DB_PREFIX . "plans_variation WHERE employplan_id = '" . (int)$employplan_id . "'");


		


		if (!empty($data['plans_variation'])) {


			foreach ($data['plans_variation'] as $plans_variation) {


				if ($plans_variation['variation_id']) {


					


						$this->db->query("INSERT INTO " . DB_PREFIX . "plans_variation SET employplan_id = '" . (int)$employplan_id . "', variation_id = '" . (int)$plans_variation['variation_id'] . "'");


					


				}


			}


		}


		


		$this->db->query("DELETE FROM " . DB_PREFIX . "plans_options WHERE employplan_id = '" . (int)$employplan_id . "'");


		


		if (isset($data['plans_options'])) {


			foreach ($data['plans_options'] as $plans_options) {


				$this->db->query("INSERT INTO " . DB_PREFIX . "plans_options SET employplan_id = '" . (int)$employplan_id . "', title = '" . $this->db->escape($plans_options['title']) . "', price = '" . $this->db->escape($plans_options['price']) . "', sort_order = '" . (int)$plans_options['sort_order'] . "'");


			}


		}


		


		$this->cache->delete('employplans');


	}





	public function deletePlans($employplan_id) {


	


		$this->db->query("DELETE FROM " . DB_PREFIX . "employplans WHERE employplan_id = '" . (int)$employplan_id . "'");


		


		$this->db->query("DELETE FROM " . DB_PREFIX . "employplans_description WHERE employplan_id = '" . (int)$employplan_id . "'");


		


		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'employplan_id=" . (int)$employplan_id . "'");


		$this->cache->delete('employplans');


	}





	public function getPlans($employplan_id) {


		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'employplan_id=" . (int)$employplan_id . "') AS keyword FROM " . DB_PREFIX . "employplans WHERE employplan_id = '" . (int)$employplan_id . "'");





		return $query->row;


	}


	


	public function getPlansiesedit($employplan_id) {


				$sql = "SELECT * FROM " . DB_PREFIX . "employplans p LEFT JOIN " . DB_PREFIX . "employplans_description pd ON (p.employplan_id = pd.employplan_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'";


				


		


					$query=$this->db->query($sql);


					return $query->row;











				}


	public function getPlan($employplan_id) {


		$sql = "SELECT * FROM " . DB_PREFIX . "employplans p LEFT JOIN " . DB_PREFIX . "employplans_description pd ON (p.employplan_id = pd.employplan_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' and p.employplan_id='".$employplan_id."' ";





		$query=$this->db->query($sql);


		return $query->row;











				}





	public function getPlansies($data = array()) {

			$sql = "SELECT * FROM " . DB_PREFIX . "employplans p LEFT JOIN " . DB_PREFIX . "employplans_description pd ON (p.employplan_id = pd.employplan_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
			$sort_data = array(
			'pd.name',
				'p.sort_order'
			);

			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {

				$sql .= " ORDER BY " . $data['sort'];

			} else {


				$sql .= " ORDER BY pd.name";


			}





			if (isset($data['order']) && ($data['order'] == 'DESC')) {


				$sql .= " DESC";


			} else {


				$sql .= " ASC";


			}





			if (isset($data['start']) || isset($data['limit'])) {


				if ($data['start'] < 0) {


					$data['start'] = 0;


				}





				if ($data['limit'] < 1) {


					$data['limit'] = 20;


				}





				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];


			}





			$query = $this->db->query($sql);





			return $query->rows;


		


	}


	





	public function getPlansDescriptions($employplan_id) {


		$plans_description_data = array();





		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "employplans_description WHERE employplan_id = '" . (int)$employplan_id . "'");





		foreach ($query->rows as $result) {


			$plans_description_data[$result['language_id']] = array(


				'name'             => $result['name'],


				'description'      => $result['description']


			);


		}





		return $plans_description_data;


	}


	


	public function getTotalPlansies() {


		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "employplans");





		return $query->row['total'];


	}	


	


	public function getPlansVariations($employplan_id) {


		$plans_variation_data = array();





		$plans_variation_query = $this->db->query("SELECT variation_id FROM " . DB_PREFIX . "plans_variation WHERE employplan_id = '" . (int)$employplan_id . "' GROUP BY variation_id");





		foreach ($plans_variation_query->rows as $plans_variation) {


			$plans_variation_description_data = array();





			$plans_variation_description_data = $this->db->query("SELECT * FROM " . DB_PREFIX . "plans_variation WHERE employplan_id = '" . (int)$employplan_id . "' AND variation_id = '" . (int)$plans_variation['variation_id'] . "'");





			$plans_variation_data[] = array(


				'variation_id'                  => $plans_variation['variation_id'],


				'plans_variation_description' => $plans_variation_description_data


			);


		}





		return $plans_variation_data;


	}


	


	public function getPlansOptions($employplan_id) {


		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "plans_options WHERE employplan_id = '" . (int)$employplan_id . "' ORDER BY sort_order ASC");





		return $query->rows;


	}


	


	


	


}


