<?php
class ControllercompanyPPStandard extends Controller {
	public function index() {
		$data['text_testmode'] = $this->language->get('text_testmode');
		$data['text_payment'] = $this->language->get('text_payment');
		$data['button_confirm'] = $this->language->get('button_confirm');
		$data['testmode'] = $this->config->get('paymentsetting_test');
		
		$data['loading'] = $server . 'image/loadin.gif';
		if (!$this->config->get('paymentsetting_test')) {
			$data['action'] = 'https://www.paypal.com/cgi-bin/webscr';
		} else {
			$data['action'] = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		} 
		$this->load->model('job/company');
		 $company_id =$this->request->get['company_id'];





		  $packageinfo=$this->model_job_company->getCompany($this->request->get['company_id']);
		  
		  $plansInfos=$this->model_job_company->plansdescription($packageinfo['plans_id']);

		  $priceget=$this->model_job_company->getplans($packageinfo['plans_id']);

			if(!empty($plansInfos['name'])){
				$name=$plansInfos['name'];
			}else{
				$name='';
			}
			if(!empty($packageinfo['plans_id'])){
				$plans_id=$packageinfo['plans_id'];
			}else{
				$plans_id='';
			}
			if(!empty($priceget['price'])){
				$price=$priceget['price'];
			}else{
				$price='';
			}
			
          if ($packageinfo) {
			$data['business']             = $this->config->get('paymentsetting_email');
			$data['planname']             = $name;
			$data['company_id']    = $company_id;
			$data['currency_code']        =$this->config->get('config_currency');
			$data['price']                = $price;
			$data['first_name']           = html_entity_decode($packageinfo['agentname'], ENT_QUOTES, 'UTF-8');
			$data['email']                = $packageinfo['email'];
			$data['lc']                   = $this->session->data['language'];
			$data['return']               = $this->url->link('company/paymountpage');
			$data['notify_url']           = $this->url->link('company/pp_standard/callback', '', true);
			$data['cancel_return']        = $this->url->link('company/cancelpage');
			
			if (!$this->config->get('paymentsetting_transaction')) {
				$data['paymentaction'] = 'authorization';
			} else {
				$data['paymentaction'] = 'sale';
			}
			
			$data['custom'] = $company_id;
			$data['column_left'] 	= $this->load->controller('common/column_left');
			$data['column_right'] 	= $this->load->controller('common/column_right');
			$data['content_top'] 	= $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] 		= $this->load->controller('common/footer');
			$data['header'] 		= $this->load->controller('common/header');
			$this->response->setOutput($this->load->view('company/pp_standard', $data));
		}

	}


	public function callback() {

    	$this->load->model('job/company');
        $company_id =$this->request->post['custom'];
		 $callbackplan_info=$this->model_job_company->getCompany($company_id);
		 $getOrderInfo=$this->model_job_company->getOrderprice($company_id);
	 	if ($getOrderInfo) {
			$request = 'cmd=_notify-validate';
			foreach ($this->request->post as $key => $value) {
				$request .= '&' . $key . '=' . urlencode(html_entity_decode($value, ENT_QUOTES, 'UTF-8'));
			}
			if (!$this->config->get('paymentsetting_test')) {
				$curl = curl_init('https://www.paypal.com/cgi-bin/webscr');
			} else {
				$curl = curl_init('https://www.sandbox.paypal.com/cgi-bin/webscr');
			}
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_HEADER, false);
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($curl);
			if (!$response) {
				$this->log->write('PP_STANDARD :: CURL failed ' . curl_error($curl) . '(' . curl_errno($curl) . ')');
			}
			if ($this->config->get('pp_standard_debug')) {
				$this->log->write('PP_STANDARD :: IPN REQUEST: ' . $request);
				$this->log->write('PP_STANDARD :: IPN RESPONSE: ' . $response);
			 }
			if ((strcmp($response, 'VERIFIED') == 0 || strcmp($response, 'UNVERIFIED') == 0) && isset($this->request->post['payment_status'])) {
				$order_status_id =$this->config->get('config_order_status_id');
				switch($this->request->post['payment_status']) {
					case 'Canceled_Reversal':
						$order_status_id = $this->config->get('paymentsetting_canceled_reversal_status_id');
						break;
					case 'Completed':
						$receiver_match = (strtolower($this->request->post['receiver_email']) == strtolower($this->config->get('paymentsetting_email')));
						$total_paid_match = ((float)$this->request->post['mc_gross'] == $this->currency->format($getOrderInfo['price'],$getOrderInfo['currency_code'],false));
					
						if ($receiver_match && $total_paid_match) {
							$order_status_id = $this->config->get('paymentsetting_completed_status_id');
						}
						if (!$receiver_match) {
							$this->log->write('PP_STANDARD :: RECEIVER EMAIL MISMATCH! ' . strtolower($this->request->post['receiver_email']));
						}
						
						break;
					case 'Denied':
						$order_status_id = $this->config->get('paymentsetting_denied_status_id');
						break;
					case 'Expired':
						$order_status_id = $this->config->get('paymentsetting_expired_status_id');
						break;
					case 'Failed':
						$order_status_id = $this->config->get('paymentsetting_failed_status_id');
						break;
					case 'Pending':
						$order_status_id = $this->config->get('paymentsetting_pending_status_id');
						break;
					case 'Processed':
						$order_status_id = $this->config->get('paymentsetting_processed_status_id');
						break;
				
					case 'Reversed':
						$order_status_id = $this->config->get('paymentsetting_reversed_status_id');
						break;
					case 'Voided':
						$order_status_id = $this->config->get('paymentsetting_voided_status_id');
						break;
				}
				
				$this->model_job_company->addBookingHistory($company_id, $order_status_id);
			} else {
				$this->model_job_company->addBookingHistory($company_id,$this->config->get('config_order_status_id'));
			}
			curl_close($curl);

		}

	}

}