<?php
class ControllerCompanyDashboard extends Controller {
	private $error = array();
	public function index() {
		
		if (!$this->company->isLogged()) {
			$this->response->redirect($this->url->link('employ/login', '', true));
		}

		$this->load->model('job/cron');
		$this->model_job_cron->Expiryplanmail($this->company->getId());
		
		$this->load->language('company/dashboard');
		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
		$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');
		$this->load->model('job/company');
		$this->load->model('tool/image');
		$this->company->getId();


		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('company/dashboard', '', true)
		);

		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_account_already'] 		= sprintf($this->language->get('text_account_already'), $this->url->link('company/login', '', true));
		$data['text_your_details'] 			= $this->language->get('text_your_details');
		$data['text_your_address'] 			= $this->language->get('text_your_address');
		$data['text_your_password'] 		= $this->language->get('text_your_password');
		$data['text_newsletter'] 			= $this->language->get('text_newsletter');
		$data['text_yes'] 					= $this->language->get('text_yes');
		$data['text_no'] 					= $this->language->get('text_no');
		$data['text_select'] 				= $this->language->get('text_select');
		$data['text_none'] 					= $this->language->get('text_none');
		$data['text_loading'] 				= $this->language->get('text_loading');
		$data['text_company_detail'] 		= $this->language->get('text_company_detail');
		
		$data['entry_totaljob'] 				= $this->language->get('entry_totaljob');
		$data['entry_applycandidate'] 				= $this->language->get('entry_applycandidate');
		$data['entry_availablepost'] 				= $this->language->get('entry_availablepost');
		$data['entry_recentpost'] 				= $this->language->get('entry_recentpost');
		$data['entry_date'] 				= $this->language->get('entry_date');
		$data['entry_jobtitle'] 				= $this->language->get('entry_jobtitle');
		$data['entry_jobtype'] 				= $this->language->get('entry_jobtype');
		$data['entry_category'] 				= $this->language->get('entry_category');
		$data['entry_salary'] 				= $this->language->get('entry_salary');
		$data['entry_apply'] 				= $this->language->get('entry_apply');
		$data['text_parttime'] 				= $this->language->get('text_parttime');
		$data['text_fulltime'] 				= $this->language->get('text_fulltime');
		$data['text_no_results'] 				= $this->language->get('text_no_results');
		
		$data['button_continue'] 			= $this->language->get('button_continue');
		$data['button_upload'] 				= $this->language->get('button_upload');
		
		$this->load->model('catalog/category');
		
		$data['job_id'] = $this->model_job_company->getrecentlyjobpost($this->company->getId());
		$job_id = $this->model_job_company->getrecentlyjobpost($this->company->getId());
       	
       	if(!empty($job_id)){
        $data['candidateapplyjob'] = $this->model_job_company->getrecentapply($this->company->getId());

		$recentjob = $this->model_job_company->getrecentjobpost($job_id);

		$data['jobtitle'] = $recentjob['title'];
		$data['date'] 	  =  $recentjob['date_added'];

		if($recentjob['jobtype_id']==1) { 
			$data['jobtype'] = $this->language->get('text_parttime');
		} else {
		 	$data['jobtype'] = $this->language->get('text_fulltime');
		}

		if(!empty($recentjob['category_id'])) {
			$cat_name = $this->model_catalog_category->getJobCategory($recentjob['category_id']);
			$data['cat_name'] = $cat_name['name'];
		} else {
			$data['cat_name'] = '';
		}
		
		$data['salary'] =  $recentjob['salary'];
	} 
		
		$this->load->model('job/job');
		$this->load->model('job/applyjob');
		$filter_data = array(
        	'company_id'=>$this->company->getId(),
        	'job_id'    => $this->request->get['job_id'],
		);
		
        $data['job_total'] = $this->model_job_job->getTotals($filter_data);
        $companyinfo = $this->model_job_company->showCompany($this->company->getId());
		$jobss = $companyinfo['job_limit'];
		$data['availabeljob'] = $jobss - $data['job_total'];

		$data['column_left'] 	= $this->load->controller('common/column_left');
		$data['column_right'] 	= $this->load->controller('common/column_right');
		$data['content_top'] 	= $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] 		= $this->load->controller('common/footer');
		$data['header'] 		= $this->load->controller('common/header');

		$this->response->setOutput($this->load->view('company/dashboard', $data));
	}	
}