<?php
class ControllerJobResume extends Controller {
	private $error = array();
		public function index() {
			
		$this->load->language('job/resume');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('job/resume');
		
		$this->getList();
	}
	public function add() {
		$this->load->language('job/resume');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('job/resume');
		
			if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
		
			$this->model_job_resume->addResume($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
				$this->response->redirect($this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url, true));
		}
		$this->getForm();
	}
	public function edit(){
		$this->load->language('job/resume');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('job/resume');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

			$this->model_job_resume->editResume($this->request->get['resume_id'],$this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			$this->response->redirect($this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url, true));
		}
		$this->getForm();
	}
	public function delete() {
	
		$this->load->language('job/resume');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('job/resume');
			//change delete//
		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $resume_id)
			{
				$this->model_job_resume->deleteResumes($resume_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');
			$url = '';

			$this->response->redirect($this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url, true));
		}
		$this->getList();
	}
	public function getList() {
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
		 	$sort = 'jobtype_id';
		}
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			 $order = 'ASC';
		}
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		if (isset($this->request->get['page'])) {
		$url .= '&page=' . $this->request->get['page'];
		}
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}
		
		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
		'text' => $this->language->get('text_home'),
		'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
		'text' => $this->language->get('heading_title'),
		'href' => $this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url, true)
		);

		$data['add'] = $this->url->link('job/resume/add', 'token=' . $this->session->data['token'] . $url, true);
		$data['delete'] = $this->url->link('job/resume/delete', 'token=' . $this->session->data['token'] . $url, true);

		$data['resumes'] = array();

		$filter_data = array(
		'sort'  => $sort,
		'order' => $order,
		'start' => ($page - 1) * $this->config->get('config_limit_admin'),
		'limit' => $this->config->get('config_limit_admin')
		);
		//////////////////////list data show //////////	//select model///////
		$this->load->model('tool/image');
		
		$resume_total = $this->model_job_resume->getTotalResumess();
		
		$results=$this->model_job_resume->getResume($filter_data);
		
		$this->load->model('job/jobtype');
		
		$this->load->model('customer/customer');
		
		foreach($results as $result)
		{
			if (is_file(DIR_IMAGE . $result['resume'])) {
				$resume = $this->model_tool_image->resize($result['resume'], 40, 40);
			} else {
				$resume = $this->model_tool_image->resize('no_image.png', 40, 40);
			}
		
			$jobtypes_info=$this->model_job_jobtype->getJobDescription($result['jobtype_id']);
			if(isset($jobtypes_info['jobtype'])){
				$jobtype=$jobtypes_info['jobtype'];         
			} else {
				$jobtype='';
			}
			$customer_info=$this->model_customer_customer->getCustomer($result['customer_id']);
			if(isset($customer_info['firstname'])){
				$customer=$customer_info['firstname'];         
			} else {
				$customer='';
			}
			$data['resumes'][]=array(
			'resume_id'=>$result['resume_id'],
			'customer' =>$customer,
			'jobtype'  =>$jobtype,
			'resume'   =>$resume,
			'status'   => ($result['status'] ? $this->language->get('text_enable') : $this->language->get('text_disable')),
			'edit'=> $this->url->link('job/resume/edit', 'token=' . $this->session->data['token'] .'&resume_id=' . $result['resume_id'] . $url, true)
			);
		}
   
		$data['heading_title']          = $this->language->get('heading_title');
		$data['text_list']           	= $this->language->get('text_list');
		$data['text_no_results'] 		= $this->language->get('text_no_results');
		$data['text_confirm']			= $this->language->get('text_confirm');
		$data['text_male']				= $this->language->get('Male');
		$data['text_female'] 			= $this->language->get('Female');
		$data['text_none'] 				= $this->language->get('text_none');
		$data['column_jobtype']		    = $this->language->get('column_jobtype');
		$data['column_customer']		= $this->language->get('column_customer');
		$data['column_resume']			= $this->language->get('column_resume');
		$data['column_status']			= $this->language->get('column_status');
		$data['column_action']			= $this->language->get('column_action');
		$data['button_remove']          = $this->language->get('button_remove');
		$data['button_edit']            = $this->language->get('button_edit');
		$data['button_add']             = $this->language->get('button_add');
		$data['button_filter']          = $this->language->get('button_filter');
		$data['button_delete']          = $this->language->get('button_delete');
		$data['text_confirm']           = $this->language->get('text_confirm');
		$data['name']                   = $this->language->get('name');
		$data['token']                  = $this->session->data['token'];
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		 } else {
			$data['error_warning'] = '';
		 }
		$data['sort'] = $sort;
		$data['order'] = $order;
	  
		$data['sort_jobtype']  = $this->url->link('job/resume', 'token=' . $this->session->data['token'] . '&sort=jobtype' . $url, true);

		$data['sort_customer']  = $this->url->link('job/resume', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
		
		$data['sort_resume']  = $this->url->link('job/resume', 'token=' . $this->session->data['token'] . '&sort=resume' . $url, true);

		$data['sort_status']  = $this->url->link('job/resume', 'token=' . $this->session->data['token'] . '&sort=status' . $url, true);
			
		    /// session
				
		if (isset($this->session->data['success'])) {
		 	$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['sort'] = $sort;
		$data['order'] = $order;
		$data['packages']=array();
		
		$data['sort']=$sort;
		$data['order']=$order;
		$data['pagination']='';
		$data['results']='';
		        //action button
		
		$data['add']=$this->url->link('job/resume/add','&token='.$this->session->data['token'].$url,true);
		
		$data['delete']=$this->url->link('job/resume/delete','&token='.$this->session->data['token'].$url,true);
		   
		$url = '';
			///// pagination //////  
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
        
		$pagination = new Pagination();
		$pagination->total = $resume_total;
		$pagination->page  = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url   = $this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);
		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($resume_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($resume_total - $this->config->get('config_limit_admin'))) ? $resume_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $resume_total, ceil($resume_total / $this->config->get('config_limit_admin')));

		$data['header']      = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer']      = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('job/resume_list', $data));
	}
                              /////// form //////////
	protected function getForm() {
		$data['heading_title']           = $this->language->get('heading_title');
		$data['text_form']               = !isset($this->request->get['information_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
		$data['text_default']            = $this->language->get('text_default');
		$data['text_enable']             = $this->language->get('text_enable');
		$data['text_disable']            = $this->language->get('text_disable');
		$data['text_select']             = $this->language->get('text_select');
		$data['entry_image']             = $this->language->get('entry_image');
		$data['entry_status']			 = $this->language->get('entry_status');
		$data['entry_jobtype']           = $this->language->get('entry_jobtype');
		$data['entry_customer']          = $this->language->get('entry_customer');
		$data['button_save']             = $this->language->get('button_save');
		$data['button_add']              = $this->language->get('button_add');
		$data['button_remove']           = $this->language->get('button_remove');
		$data['button_cancel']           = $this->language->get('button_cancel');
		$data['text_none'] 				 = $this->language->get('text_none');

		/////image show//////
				
		$this->load->model('tool/image');
		if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
	  		$data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
		} elseif (!empty($form_info) && is_file(DIR_IMAGE . $form_info['image'])) {
		  	$data['thumb'] = $this->model_tool_image->resize($form_info['image'], 100, 100);
		} else {
		  	$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		  $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
			///  language //////
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$url = '';
     
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
		'text' => $this->language->get('text_home'),
		'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);
		$data['breadcrumbs'][] = array(
		'text' => $this->language->get('heading_title'),
		'href' => $this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url, true)
		);
		if (!isset($this->request->get['resume_id'])) {
			$data['action'] = $this->url->link('job/resume/add', 'token=' . $this->session->data['token'] . $url, true);
    	} else {
			$data['action'] = $this->url->link('job/resume/edit', 'token=' . $this->session->data['token'] . '&resume_id=' . $this->request->get['resume_id'] . $url, true);
    	}
		$data['cancel'] = $this->url->link('job/resume', 'token=' . $this->session->data['token'] . $url, true);
																/////edit qouery /////
		if (isset($this->request->get['resume_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$resume_info = $this->model_job_resume->getResumes($this->request->get['resume_id']);
		}
		$data['token'] = $this->session->data['token'];
		
		//////// editform /////////
		 
		$this->load->model('tool/image');
		if (isset($this->request->post['resume'])){
			$data['resume'] = $this->request->post['resume'];
		} elseif (!empty($resume_info)) {
			$data['resume'] = $resume_info['resume'];
		} else {
			$data['resume'] = '';
		}
	 
		if (isset($this->request->post['resume']) && is_file(DIR_IMAGE . $this->request->post['resume'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['resume'], 100, 100);
		} elseif(!empty($resume_info) && is_file(DIR_IMAGE . $resume_info['resume']))
		{
		$data['thumb'] = $this->model_tool_image->resize($resume_info['resume'], 100, 100);
		} 
		else 
		{
		$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

		if (isset($this->request->post['status']))
		{
			$data['status'] = $this->request->post['status'];
		} 
		elseif (!empty($resume_info)) 
		{
			$data['status'] = $resume_info['status'];
		} 
		else 
		{
			$data['status'] = true;
		}
		if (isset($this->request->post['jobtype_id'])) 
		{
			$data['jobtype_id'] = $this->request->post['jobtype_id'];
		}	 
		elseif (isset($resume_info['jobtype_id'])) 
		{
			$data['jobtype_id'] = $resume_info['jobtype_id'];
		}
		else 
		{
			$data['jobtype_id'] = '';		
		}
		if(!empty($data['jobtype_id']))
		{	
			$this->load->model('job/jobtype');
			
			$product_info=$this->model_job_jobtype->getJobDescription($data['jobtype_id']);
			
			$data['jobtype_id']=$product_info['jobtype'];
		}
		else
		{
			$data['jobtype']='';
		}
		if (isset($this->request->post['customer_id'])) 
		{
			$data['customer_id'] = $this->request->post['customer_id'];
		}	 
		elseif (isset($resume_info['customer_id'])) 
		{
			$data['customer_id'] = $resume_info['customer_id'];
		}
		else 
		{
			$data['customer_id'] = '';		
		}
		if(!empty($data['customer_id']))
		{	

			$this->load->model('customer/customer');

			$customer_info=$this->model_customer_customer->getCustomer($data['customer_id']);

			$data['customer_id']=$customer_info['firstname'];
		}
		else
		{
			$data['firstname']='';
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$data['header']      = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer']      = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('job/resume_form', $data));
	}
	protected function validateForm() {
		
		if (!$this->user->hasPermission('modify','job/resume')) {
				$this->error['warning'] = $this->language->get('error_permission');
			}
		return !$this->error;
	}
                       //////// validateDelete ////////
	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'job/resume')) {
		 $this->error['warning'] = $this->language->get('error_permission');
		}
		 return !$this->error;
		}
		
	public function autocomplete() {
			
    $this->load->model('job/resume');
		
		if (isset($this->request->get['filter_name'])) {
			
		if (isset($this->request->get['sort'])) {
		 $sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
			
		$filter_data = array(
		'order' => $order,
		'start' => ($page - 1) * $this->config->get('config_limit_admin'),
		'limit' => $this->config->get('config_limit_admin')
		);
		
		$results=$this->model_job_resume->getResume($filter_data);
		foreach ($results as $result) {
			$json[] = array(
			'resume_id' => $result['resume_id'],
			'name'        => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'))
			);
		}
    }
		$sort_order = array();

		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}
		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}	
}
?>