<?php
  /**
   * Stripe Form
   *
   * @package Wojo Framework
   * @author wojoscripts.com
   * @copyright 2019
   * @version $Id: form.tpl.php, v1.00 2016-03-20 10:12:05 gewa Exp $
   */
  if (!defined("_WOJO"))
      die('Direct access to this location is not allowed.');
?>
<div class="wojo small compact black segment form auto" id="stripe_form">
  <form method="post" id="stripe">
    <div class="form-row">
      <div class="row horizontal-gutters align-middle">
        <div class="columns">
          <div id="card-element">
          </div>
        </div>
        <div class="columns shrink">
          <button class="wojo primary button" id="dostripe" name="dostripe" type="submit"><?php echo Lang::$word->SUBMITP;?></button>
        </div>
      </div>
    </div>
     <input type="hidden" name="processStripePayment" value="1">
  </form>
</div>
<div role="alert" id="smsgholder" class="wojo negative text"></div>
<script type="text/javascript">
// <![CDATA[
var stripe = Stripe('<?php echo $this->gateway->extra3;?>');
var elements = stripe.elements();

var style = {
    base: {
        color: '#32325d',
        fontFamily: 'Poppins, "Helvetica Neue", Helvetica, sans-serif',
        fontSmoothing: 'antialiased',
        fontSize: '16px',
        '::placeholder': {
            color: '#aab7c4'
        }
    },
    invalid: {
        color: '#fa755a',
        iconColor: '#fa755a'
    }
};

var card = elements.create('card', {
    style: style
});

card.mount('#card-element');

card.addEventListener('change', function(event) {
    var displayError = document.getElementById('smsgholder');
    if (event.error) {
        displayError.textContent = event.error.message;
    } else {
        displayError.textContent = '';
    }
});

var form = document.getElementById('stripe');
form.addEventListener('submit', function(event) {
    event.preventDefault();

    stripe.createToken(card).then(function(result) {
        if (result.error) {
            var errorElement = document.getElementById('smsgholder');
            errorElement.textContent = result.error.message;
        } else {
            stripeTokenHandler(result.token);
        }
    });
});

function stripeTokenHandler(token) {
    var form = document.getElementById('stripe');
    var hiddenInput = document.createElement('input');
    hiddenInput.setAttribute('type', 'hidden');
    hiddenInput.setAttribute('name', 'stripeToken');
    hiddenInput.setAttribute('value', token.id);
    form.appendChild(hiddenInput);

    // Submit the form
    $("#stripe_form").addClass('loading');
    var str = $("#stripe").serialize();
    $.ajax({
        type: "post",
        dataType: 'json',
        url: "<?php echo SITEURL;?>/gateways/stripe/shop/ipn.php",
        data: str,
        success: function(json) {
            $("#stripe_form").removeClass('loading');
            if (json.type == "success") {
                $('body')
                    .transition({
                        animation: 'scale',
                        duration: '1s',
                        onComplete: function() {
                            window.location.href = '<?php echo Url::url('/' . App::Core()->system_slugs->account[0]->{'slug' . Lang::$lang}, "shop");?>';
                        }
                    });
            }
            if (json.message) {
                $.notice(decodeURIComponent(json.message), {
                    autoclose: 12000,
                    type: json.type,
                    title: json.title
                });
            }
        }
    });
}
// ]]>
</script>