/*
 * jQuery Form Plugin
 * version: 4.2.2
 * Requires jQuery v1.7.2 or later
 * Copyright (c) 2014 M. Alsup
 * Project repository: https://github.com/malsup/form
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof module==='object'&&module.exports){module.exports=function(root,jQuery){if(typeof jQuery==='undefined'){if(typeof window!=='undefined'){jQuery=require('jquery')}else{jQuery=require('jquery')(root)}}factory(jQuery);return jQuery}}else{factory(jQuery)}}(function($){'use strict';var rCRLF=/\r?\n/g;var feature={};feature.fileapi=$('<input type="file">').get(0).files!==undefined;feature.formdata=(typeof window.FormData!=='undefined');var hasProp=!!$.fn.prop;$.fn.attr2=function(){if(!hasProp){return this.attr.apply(this,arguments)}var val=this.prop.apply(this,arguments);if((val&&val.jquery)||typeof val==='string'){return val}return this.attr.apply(this,arguments)};$.fn.ajaxSubmit=function(options,data,dataType,onSuccess){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this}var method,action,url,$form=this;if(typeof options==='function'){options={success:options}}else if(typeof options==='string'||(options===false&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function'){options.success=onSuccess}}else if(typeof options==='undefined'){options={}}method=options.method||options.type||this.attr2('method');action=options.url||this.attr2('action');url=(typeof action==='string')?$.trim(action):'';url=url||window.location.href||'';if(url){url=(url.match(/^([^#]+)/)||[])[1]}options=$.extend(true,{url:url,success:$.ajaxSettings.success,type:method||$.ajaxSettings.type,iframeSrc:/^https/i.test(window.location.href||'')?'javascript:false':'about:blank'},options);var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this}if(options.beforeSerialize&&options.beforeSerialize(this,options)===false){log('ajaxSubmit: submit aborted via beforeSerialize callback');return this}var traditional=options.traditional;if(typeof traditional==='undefined'){traditional=$.ajaxSettings.traditional}var elements=[];var qx,a=this.formToArray(options.semantic,elements,options.filtering);if(options.data){var optionsData=$.isFunction(options.data)?options.data(a):options.data;options.extraData=optionsData;qx=$.param(optionsData,traditional)}if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===false){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this}this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this}var q=$.param(a,traditional);if(qx){q=(q?(q+'&'+qx):qx)}if(options.type.toUpperCase()==='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null}else{options.data=q}var callbacks=[];if(options.resetForm){callbacks.push(function(){$form.resetForm()})}if(options.clearForm){callbacks.push(function(){$form.clearForm(options.includeHidden)})}if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data,textStatus,jqXHR){var successArguments=arguments,fn=options.replaceTarget?'replaceWith':'html';$(options.target)[fn](data).each(function(){oldSuccess.apply(this,successArguments)})})}else if(options.success){if($.isArray(options.success)){$.merge(callbacks,options.success)}else{callbacks.push(options.success)}}options.success=function(data,status,xhr){var context=options.context||this;for(var i=0,max=callbacks.length;i<max;i++){callbacks[i].apply(context,[data,status,xhr||$form,$form])}};if(options.error){var oldError=options.error;options.error=function(xhr,status,error){var context=options.context||this;oldError.apply(context,[xhr,status,error,$form])}}if(options.complete){var oldComplete=options.complete;options.complete=function(xhr,status){var context=options.context||this;oldComplete.apply(context,[xhr,status,$form])}}var fileInputs=$('input[type=file]:enabled',this).filter(function(){return $(this).val()!==''});var hasFileInputs=fileInputs.length>0;var mp='multipart/form-data';var multipart=($form.attr('enctype')===mp||$form.attr('encoding')===mp);var fileAPI=feature.fileapi&&feature.formdata;log('fileAPI :'+fileAPI);var shouldUseFrame=(hasFileInputs||multipart)&&!fileAPI;var jqxhr;if(options.iframe!==false&&(options.iframe||shouldUseFrame)){if(options.closeKeepAlive){$.get(options.closeKeepAlive,function(){jqxhr=fileUploadIframe(a)})}else{jqxhr=fileUploadIframe(a)}}else if((hasFileInputs||multipart)&&fileAPI){jqxhr=fileUploadXhr(a)}else{jqxhr=$.ajax(options)}$form.removeData('jqxhr').data('jqxhr',jqxhr);for(var k=0;k<elements.length;k++){elements[k]=null}this.trigger('form-submit-notify',[this,options]);return this;function deepSerialize(extraData){var serialized=$.param(extraData,options.traditional).split('&');var len=serialized.length;var result=[];var i,part;for(i=0;i<len;i++){serialized[i]=serialized[i].replace(/\+/g,' ');part=serialized[i].split('=');result.push([decodeURIComponent(part[0]),decodeURIComponent(part[1])])}return result}function fileUploadXhr(a){var formdata=new FormData();for(var i=0;i<a.length;i++){formdata.append(a[i].name,a[i].value)}if(options.extraData){var serializedData=deepSerialize(options.extraData);for(i=0;i<serializedData.length;i++){if(serializedData[i]){formdata.append(serializedData[i][0],serializedData[i][1])}}}options.data=null;var s=$.extend(true,{},$.ajaxSettings,options,{contentType:false,processData:false,cache:false,type:method||'POST'});if(options.uploadProgress){s.xhr=function(){var xhr=$.ajaxSettings.xhr();if(xhr.upload){xhr.upload.addEventListener('progress',function(event){var percent=0;var position=event.loaded||event.position;var total=event.total;if(event.lengthComputable){percent=Math.ceil(position/total*100)}options.uploadProgress(event,position,total,percent)},false)}return xhr}}s.data=null;var beforeSend=s.beforeSend;s.beforeSend=function(xhr,o){if(options.formData){o.data=options.formData}else{o.data=formdata}if(beforeSend){beforeSend.call(this,xhr,o)}};return $.ajax(s)}function fileUploadIframe(a){var form=$form[0],el,i,s,g,id,$io,io,xhr,sub,n,timedOut,timeoutHandle;var deferred=$.Deferred();deferred.abort=function(status){xhr.abort(status)};if(a){for(i=0;i<elements.length;i++){el=$(elements[i]);if(hasProp){el.prop('disabled',false)}else{el.removeAttr('disabled')}}}s=$.extend(true,{},$.ajaxSettings,options);s.context=s.context||s;id='jqFormIO'+new Date().getTime();var ownerDocument=form.ownerDocument;var $body=$form.closest('body');if(s.iframeTarget){$io=$(s.iframeTarget,ownerDocument);n=$io.attr2('name');if(!n){$io.attr2('name',id)}else{id=n}}else{$io=$('<iframe name="'+id+'" src="'+s.iframeSrc+'" />',ownerDocument);$io.css({position:'absolute',top:'-1000px',left:'-1000px'})}io=$io[0];xhr={aborted:0,responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(status){var e=(status==='timeout'?'timeout':'aborted');log('aborting upload... '+e);this.aborted=1;try{if(io.contentWindow.document.execCommand){io.contentWindow.document.execCommand('Stop')}}catch(ignore){}$io.attr('src',s.iframeSrc);xhr.error=e;if(s.error){s.error.call(s.context,xhr,e,status)}if(g){$.event.trigger('ajaxError',[xhr,s,e])}if(s.complete){s.complete.call(s.context,xhr,e)}}};g=s.global;if(g&&$.active++===0){$.event.trigger('ajaxStart')}if(g){$.event.trigger('ajaxSend',[xhr,s])}if(s.beforeSend&&s.beforeSend.call(s.context,xhr,s)===false){if(s.global){$.active--}deferred.reject();return deferred}if(xhr.aborted){deferred.reject();return deferred}sub=form.clk;if(sub){n=sub.name;if(n&&!sub.disabled){s.extraData=s.extraData||{};s.extraData[n]=sub.value;if(sub.type==='image'){s.extraData[n+'.x']=form.clk_x;s.extraData[n+'.y']=form.clk_y}}}var CLIENT_TIMEOUT_ABORT=1;var SERVER_ABORT=2;function getDoc(frame){var doc=null;try{if(frame.contentWindow){doc=frame.contentWindow.document}}catch(err){log('cannot get iframe.contentWindow document: '+err)}if(doc){return doc}try{doc=frame.contentDocument?frame.contentDocument:frame.document}catch(err){log('cannot get iframe.contentDocument: '+err);doc=frame.document}return doc}var csrf_token=$('meta[name=csrf-token]').attr('content');var csrf_param=$('meta[name=csrf-param]').attr('content');if(csrf_param&&csrf_token){s.extraData=s.extraData||{};s.extraData[csrf_param]=csrf_token}function doSubmit(){var t=$form.attr2('target'),a=$form.attr2('action'),mp='multipart/form-data',et=$form.attr('enctype')||$form.attr('encoding')||mp;form.setAttribute('target',id);if(!method||/post/i.test(method)){form.setAttribute('method','POST')}if(a!==s.url){form.setAttribute('action',s.url)}if(!s.skipEncodingOverride&&(!method||/post/i.test(method))){$form.attr({encoding:'multipart/form-data',enctype:'multipart/form-data'})}if(s.timeout){timeoutHandle=setTimeout(function(){timedOut=true;cb(CLIENT_TIMEOUT_ABORT)},s.timeout)}function checkState(){try{var state=getDoc(io).readyState;log('state = '+state);if(state&&state.toLowerCase()==='uninitialized'){setTimeout(checkState,50)}}catch(e){log('Server abort: ',e,' (',e.name,')');cb(SERVER_ABORT);if(timeoutHandle){clearTimeout(timeoutHandle)}timeoutHandle=undefined}}var extraInputs=[];try{if(s.extraData){for(var n in s.extraData){if(s.extraData.hasOwnProperty(n)){if($.isPlainObject(s.extraData[n])&&s.extraData[n].hasOwnProperty('name')&&s.extraData[n].hasOwnProperty('value')){extraInputs.push($('<input type="hidden" name="'+s.extraData[n].name+'">',ownerDocument).val(s.extraData[n].value).appendTo(form)[0])}else{extraInputs.push($('<input type="hidden" name="'+n+'">',ownerDocument).val(s.extraData[n]).appendTo(form)[0])}}}}if(!s.iframeTarget){$io.appendTo($body)}if(io.attachEvent){io.attachEvent('onload',cb)}else{io.addEventListener('load',cb,false)}setTimeout(checkState,15);try{form.submit()}catch(err){var submitFn=document.createElement('form').submit;submitFn.apply(form)}}finally{form.setAttribute('action',a);form.setAttribute('enctype',et);if(t){form.setAttribute('target',t)}else{$form.removeAttr('target')}$(extraInputs).remove()}}if(s.forceSync){doSubmit()}else{setTimeout(doSubmit,10)}var data,doc,domCheckCount=50,callbackProcessed;function cb(e){if(xhr.aborted||callbackProcessed){return}doc=getDoc(io);if(!doc){log('cannot access response document');e=SERVER_ABORT}if(e===CLIENT_TIMEOUT_ABORT&&xhr){xhr.abort('timeout');deferred.reject(xhr,'timeout');return}else if(e===SERVER_ABORT&&xhr){xhr.abort('server abort');deferred.reject(xhr,'error','server abort');return}if(!doc||doc.location.href===s.iframeSrc){if(!timedOut){return}}if(io.detachEvent){io.detachEvent('onload',cb)}else{io.removeEventListener('load',cb,false)}var status='success',errMsg;try{if(timedOut){throw'timeout';}var isXml=s.dataType==='xml'||doc.XMLDocument||$.isXMLDoc(doc);log('isXml='+isXml);if(!isXml&&window.opera&&(doc.body===null||!doc.body.innerHTML)){if(--domCheckCount){log('requeing onLoad callback, DOM not available');setTimeout(cb,250);return}}var docRoot=doc.body?doc.body:doc.documentElement;xhr.responseText=docRoot?docRoot.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;if(isXml){s.dataType='xml'}xhr.getResponseHeader=function(header){var headers={'content-type':s.dataType};return headers[header.toLowerCase()]};if(docRoot){xhr.status=Number(docRoot.getAttribute('status'))||xhr.status;xhr.statusText=docRoot.getAttribute('statusText')||xhr.statusText}var dt=(s.dataType||'').toLowerCase();var scr=/(json|script|text)/.test(dt);if(scr||s.textarea){var ta=doc.getElementsByTagName('textarea')[0];if(ta){xhr.responseText=ta.value;xhr.status=Number(ta.getAttribute('status'))||xhr.status;xhr.statusText=ta.getAttribute('statusText')||xhr.statusText}else if(scr){var pre=doc.getElementsByTagName('pre')[0];var b=doc.getElementsByTagName('body')[0];if(pre){xhr.responseText=pre.textContent?pre.textContent:pre.innerText}else if(b){xhr.responseText=b.textContent?b.textContent:b.innerText}}}else if(dt==='xml'&&!xhr.responseXML&&xhr.responseText){xhr.responseXML=toXml(xhr.responseText)}try{data=httpData(xhr,dt,s)}catch(err){status='parsererror';xhr.error=errMsg=(err||status)}}catch(err){log('error caught: ',err);status='error';xhr.error=errMsg=(err||status)}if(xhr.aborted){log('upload aborted');status=null}if(xhr.status){status=((xhr.status>=200&&xhr.status<300)||xhr.status===304)?'success':'error'}if(status==='success'){if(s.success){s.success.call(s.context,data,'success',xhr)}deferred.resolve(xhr.responseText,'success',xhr);if(g){$.event.trigger('ajaxSuccess',[xhr,s])}}else if(status){if(typeof errMsg==='undefined'){errMsg=xhr.statusText}if(s.error){s.error.call(s.context,xhr,status,errMsg)}deferred.reject(xhr,'error',errMsg);if(g){$.event.trigger('ajaxError',[xhr,s,errMsg])}}if(g){$.event.trigger('ajaxComplete',[xhr,s])}if(g&&!--$.active){$.event.trigger('ajaxStop')}if(s.complete){s.complete.call(s.context,xhr,status)}callbackProcessed=true;if(s.timeout){clearTimeout(timeoutHandle)}setTimeout(function(){if(!s.iframeTarget){$io.remove()}else{$io.attr('src',s.iframeSrc)}xhr.responseXML=null},100)}var toXml=$.parseXML||function(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s)}else{doc=(new DOMParser()).parseFromString(s,'text/xml')}return(doc&&doc.documentElement&&doc.documentElement.nodeName!=='parsererror')?doc:null};var parseJSON=$.parseJSON||function(s){return window['eval']('('+s+')')};var httpData=function(xhr,type,s){var ct=xhr.getResponseHeader('content-type')||'',xml=((type==='xml'||!type)&&ct.indexOf('xml')>=0),data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.nodeName==='parsererror'){if($.error){$.error('parsererror')}}if(s&&s.dataFilter){data=s.dataFilter(data,type)}if(typeof data==='string'){if((type==='json'||!type)&&ct.indexOf('json')>=0){data=parseJSON(data)}else if((type==='script'||!type)&&ct.indexOf('javascript')>=0){$.globalEval(data)}}return data};return deferred}};$.fn.ajaxForm=function(options,data,dataType,onSuccess){if(typeof options==='string'||(options===false&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function'){options.success=onSuccess}}options=options||{};options.delegation=options.delegation&&$.isFunction($.fn.on);if(!options.delegation&&this.length===0){var o={s:this.selector,c:this.context};if(!$.isReady&&o.s){log('DOM not ready, queuing ajaxForm');$(function(){$(o.s,o.c).ajaxForm(options)});return this}log('terminating; zero elements found by selector'+($.isReady?'':' (DOM not ready)'));return this}if(options.delegation){$(document).off('submit.form-plugin',this.selector,doAjaxSubmit).off('click.form-plugin',this.selector,captureSubmittingElement).on('submit.form-plugin',this.selector,options,doAjaxSubmit).on('click.form-plugin',this.selector,options,captureSubmittingElement);return this}return this.ajaxFormUnbind().on('submit.form-plugin',options,doAjaxSubmit).on('click.form-plugin',options,captureSubmittingElement)};function doAjaxSubmit(e){var options=e.data;if(!e.isDefaultPrevented()){e.preventDefault();$(e.target).closest('form').ajaxSubmit(options)}}function captureSubmittingElement(e){var target=e.target;var $el=$(target);if(!$el.is('[type=submit],[type=image]')){var t=$el.closest('[type=submit]');if(t.length===0){return}target=t[0]}var form=target.form;form.clk=target;if(target.type==='image'){if(typeof e.offsetX!=='undefined'){form.clk_x=e.offsetX;form.clk_y=e.offsetY}else if(typeof $.fn.offset==='function'){var offset=$el.offset();form.clk_x=e.pageX-offset.left;form.clk_y=e.pageY-offset.top}else{form.clk_x=e.pageX-target.offsetLeft;form.clk_y=e.pageY-target.offsetTop}}setTimeout(function(){form.clk=form.clk_x=form.clk_y=null},100)}$.fn.ajaxFormUnbind=function(){return this.off('submit.form-plugin click.form-plugin')};$.fn.formToArray=function(semantic,elements,filtering){var a=[];if(this.length===0){return a}var form=this[0];var formId=this.attr('id');var els=(semantic||typeof form.elements==='undefined')?form.getElementsByTagName('*'):form.elements;var els2;if(els){els=$.makeArray(els)}if(formId&&(semantic||/(Edge|Trident)\//.test(navigator.userAgent))){els2=$(':input[form="'+formId+'"]').get();if(els2.length){els=(els||[]).concat(els2)}}if(!els||!els.length){return a}if($.isFunction(filtering)){els=$.map(els,filtering)}var i,j,n,v,el,max,jmax;for(i=0,max=els.length;i<max;i++){el=els[i];n=el.name;if(!n||el.disabled){continue}if(semantic&&form.clk&&el.type==='image'){if(form.clk===el){a.push({name:n,value:$(el).val(),type:el.type});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y})}continue}v=$.fieldValue(el,true);if(v&&v.constructor===Array){if(elements){elements.push(el)}for(j=0,jmax=v.length;j<jmax;j++){a.push({name:n,value:v[j]})}}else if(feature.fileapi&&el.type==='file'){if(elements){elements.push(el)}var files=el.files;if(files.length){for(j=0;j<files.length;j++){a.push({name:n,value:files[j],type:el.type})}}else{a.push({name:n,value:'',type:el.type})}}else if(v!==null&&typeof v!=='undefined'){if(elements){elements.push(el)}a.push({name:n,value:v,type:el.type,required:el.required})}}if(!semantic&&form.clk){var $input=$(form.clk),input=$input[0];n=input.name;if(n&&!input.disabled&&input.type==='image'){a.push({name:n,value:$input.val()});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y})}}return a};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic))};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n){return}var v=$.fieldValue(this,successful);if(v&&v.constructor===Array){for(var i=0,max=v.length;i<max;i++){a.push({name:n,value:v[i]})}}else if(v!==null&&typeof v!=='undefined'){a.push({name:this.name,value:v})}});return $.param(a)};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v==='undefined'||(v.constructor===Array&&!v.length)){continue}if(v.constructor===Array){$.merge(val,v)}else{val.push(v)}}return val};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful==='undefined'){successful=true}if(successful&&(!n||el.disabled||t==='reset'||t==='button'||(t==='checkbox'||t==='radio')&&!el.checked||(t==='submit'||t==='image')&&el.form&&el.form.clk!==el||tag==='select'&&el.selectedIndex===-1)){return null}if(tag==='select'){var index=el.selectedIndex;if(index<0){return null}var a=[],ops=el.options;var one=(t==='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected&&!op.disabled){var v=op.value;if(!v){v=(op.attributes&&op.attributes.value&&!(op.attributes.value.specified))?op.text:op.value}if(one){return v}a.push(v)}}return a}return $(el).val().replace(rCRLF,'\r\n')};$.fn.clearForm=function(includeHidden){return this.each(function(){$('input,select,textarea',this).clearFields(includeHidden)})};$.fn.clearFields=$.fn.clearInputs=function(includeHidden){var re=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(re.test(t)||tag==='textarea'){this.value=''}else if(t==='checkbox'||t==='radio'){this.checked=false}else if(tag==='select'){this.selectedIndex=-1}else if(t==='file'){if(/MSIE/.test(navigator.userAgent)){$(this).replaceWith($(this).clone(true))}else{$(this).val('')}}else if(includeHidden){if((includeHidden===true&&/hidden/.test(t))||(typeof includeHidden==='string'&&$(this).is(includeHidden))){this.value=''}}})};$.fn.resetForm=function(){return this.each(function(){var el=$(this);var tag=this.tagName.toLowerCase();switch(tag){case'input':this.checked=this.defaultChecked;case'textarea':this.value=this.defaultValue;return true;case'option':case'optgroup':var select=el.parents('select');if(select.length&&select[0].multiple){if(tag==='option'){this.selected=this.defaultSelected}else{el.find('option').resetForm()}}else{select.resetForm()}return true;case'select':el.find('option').each(function(i){this.selected=this.defaultSelected;if(this.defaultSelected&&!el[0].multiple){el[0].selectedIndex=i;return false}});return true;case'label':var forEl=$(el.attr('for'));var list=el.find('input,select,textarea');if(forEl[0]){list.unshift(forEl[0])}list.resetForm();return true;case'form':if(typeof this.reset==='function'||(typeof this.reset==='object'&&!this.reset.nodeType)){this.reset()}return true;default:el.find('form,input,label,select,textarea').resetForm();return true}})};$.fn.enable=function(b){if(typeof b==='undefined'){b=true}return this.each(function(){this.disabled=!b})};$.fn.selected=function(select){if(typeof select==='undefined'){select=true}return this.each(function(){var t=this.type;if(t==='checkbox'||t==='radio'){this.checked=select}else if(this.tagName.toLowerCase()==='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type==='select-one'){$sel.find('option').selected(false)}this.selected=select}})};$.fn.ajaxSubmit.debug=false;function log(){if(!$.fn.ajaxSubmit.debug){return}var msg='[jquery.form] '+Array.prototype.join.call(arguments,'');if(window.console&&window.console.log){window.console.log(msg)}else if(window.opera&&window.opera.postError){window.opera.postError(msg)}}}));
/*!
 * # Semantic UI 2.4.1 - Transition
 * http://github.com/semantic-org/semantic-ui/
 *
 */
!function(C,n,A,S){"use strict";n=void 0!==n&&n.Math==Math?n:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),C.fn.transition=function(){var u,r=C(this),p=r.selector||"",g=(new Date).getTime(),v=[],b=arguments,y=b[0],h=[].slice.call(arguments,1),w="string"==typeof y;n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame;return r.each(function(t){var d,s,e,c,i,a,n,o,m,f=C(this),l=this;(m={initialize:function(){d=m.get.settings.apply(l,b),c=d.className,e=d.error,i=d.metadata,o="."+d.namespace,n="module-"+d.namespace,s=f.data(n)||m,a=m.get.animationEndEvent(),w&&(w=m.invoke(y)),!1===w&&(m.verbose("Converted arguments into settings object",d),d.interval?m.delay(d.animate):m.animate(),m.instantiate())},instantiate:function(){m.verbose("Storing instance of module",m),s=m,f.data(n,s)},destroy:function(){m.verbose("Destroying previous module for",l),f.removeData(n)},refresh:function(){m.verbose("Refreshing display type on next animation"),delete m.displayType},forceRepaint:function(){m.verbose("Forcing element repaint");var n=f.parent(),e=f.next();0===e.length?f.detach().appendTo(n):f.detach().insertBefore(e)},repaint:function(){m.verbose("Repainting element");l.offsetWidth},delay:function(n){var e,i=m.get.animationDirection();i||(i=m.can.transition()?m.get.direction():"static"),n=n!==S?n:d.interval,e="auto"==d.reverse&&i==c.outward||1==d.reverse?(r.length-t)*d.interval:t*d.interval,m.debug("Delaying animation by",e),setTimeout(m.animate,e)},animate:function(n){if(d=n||d,!m.is.supported())return m.error(e.support),!1;if(m.debug("Preparing animation",d.animation),m.is.animating()){if(d.queue)return!d.allowRepeats&&m.has.direction()&&m.is.occurring()&&!0!==m.queuing?m.debug("Animation is currently occurring, preventing queueing same animation",d.animation):m.queue(d.animation),!1;if(!d.allowRepeats&&m.is.occurring())return m.debug("Animation is already occurring, will not execute repeated animation",d.animation),!1;m.debug("New animation started, completing previous early",d.animation),s.complete()}m.can.animate()?m.set.animating(d.animation):m.error(e.noAnimation,d.animation,l)},reset:function(){m.debug("Resetting animation to beginning conditions"),m.remove.animationCallbacks(),m.restore.conditions(),m.remove.animating()},queue:function(n){m.debug("Queueing animation of",n),m.queuing=!0,f.one(a+".queue"+o,function(){m.queuing=!1,m.repaint(),m.animate.apply(this,d)})},complete:function(n){m.debug("Animation complete",d.animation),m.remove.completeCallback(),m.remove.failSafe(),m.is.looping()||(m.is.outward()?(m.verbose("Animation is outward, hiding element"),m.restore.conditions(),m.hide()):m.is.inward()?(m.verbose("Animation is outward, showing element"),m.restore.conditions(),m.show()):(m.verbose("Static animation completed"),m.restore.conditions(),d.onComplete.call(l)))},force:{visible:function(){var n=f.attr("style"),e=m.get.userStyle(),i=m.get.displayType(),t=e+"display: "+i+" !important;",a=f.css("display"),o=n===S||""===n;a!==i?(m.verbose("Overriding default display to show element",i),f.attr("style",t)):o&&f.removeAttr("style")},hidden:function(){var n=f.attr("style"),e=f.css("display"),i=n===S||""===n;"none"===e||m.is.hidden()?i&&f.removeAttr("style"):(m.verbose("Overriding default display to hide element"),f.css("display","none"))}},has:{direction:function(n){var i=!1;return"string"==typeof(n=n||d.animation)&&(n=n.split(" "),C.each(n,function(n,e){e!==c.inward&&e!==c.outward||(i=!0)})),i},inlineDisplay:function(){var n=f.attr("style")||"";return C.isArray(n.match(/display.*?;/,""))}},set:{animating:function(n){var e;m.remove.completeCallback(),n=n||d.animation,e=m.get.animationClass(n),m.save.animation(e),m.force.visible(),m.remove.hidden(),m.remove.direction(),m.start.animation(e)},duration:function(n,e){((e="number"==typeof(e=e||d.duration)?e+"ms":e)||0===e)&&(m.verbose("Setting animation duration",e),f.css({"animation-duration":e}))},direction:function(n){(n=n||m.get.direction())==c.inward?m.set.inward():m.set.outward()},looping:function(){m.debug("Transition set to loop"),f.addClass(c.looping)},hidden:function(){f.addClass(c.transition).addClass(c.hidden)},inward:function(){m.debug("Setting direction to inward"),f.removeClass(c.outward).addClass(c.inward)},outward:function(){m.debug("Setting direction to outward"),f.removeClass(c.inward).addClass(c.outward)},visible:function(){f.addClass(c.transition).addClass(c.visible)}},start:{animation:function(n){n=n||m.get.animationClass(),m.debug("Starting tween",n),f.addClass(n).one(a+".complete"+o,m.complete),d.useFailSafe&&m.add.failSafe(),m.set.duration(d.duration),d.onStart.call(l)}},save:{animation:function(n){m.cache||(m.cache={}),m.cache.animation=n},displayType:function(n){"none"!==n&&f.data(i.displayType,n)},transitionExists:function(n,e){C.fn.transition.exists[n]=e,m.verbose("Saving existence of transition",n,e)}},restore:{conditions:function(){var n=m.get.currentAnimation();n&&(f.removeClass(n),m.verbose("Removing animation class",m.cache)),m.remove.duration()}},add:{failSafe:function(){var n=m.get.duration();m.timer=setTimeout(function(){f.triggerHandler(a)},n+d.failSafeDelay),m.verbose("Adding fail safe timer",m.timer)}},remove:{animating:function(){f.removeClass(c.animating)},animationCallbacks:function(){m.remove.queueCallback(),m.remove.completeCallback()},queueCallback:function(){f.off(".queue"+o)},completeCallback:function(){f.off(".complete"+o)},display:function(){f.css("display","")},direction:function(){f.removeClass(c.inward).removeClass(c.outward)},duration:function(){f.css("animation-duration","")},failSafe:function(){m.verbose("Removing fail safe timer",m.timer),m.timer&&clearTimeout(m.timer)},hidden:function(){f.removeClass(c.hidden)},visible:function(){f.removeClass(c.visible)},looping:function(){m.debug("Transitions are no longer looping"),m.is.looping()&&(m.reset(),f.removeClass(c.looping))},transition:function(){f.removeClass(c.visible).removeClass(c.hidden)}},get:{settings:function(n,e,i){return"object"==typeof n?C.extend(!0,{},C.fn.transition.settings,n):"function"==typeof i?C.extend({},C.fn.transition.settings,{animation:n,onComplete:i,duration:e}):"string"==typeof e||"number"==typeof e?C.extend({},C.fn.transition.settings,{animation:n,duration:e}):"object"==typeof e?C.extend({},C.fn.transition.settings,e,{animation:n}):"function"==typeof e?C.extend({},C.fn.transition.settings,{animation:n,onComplete:e}):C.extend({},C.fn.transition.settings,{animation:n})},animationClass:function(n){var e=n||d.animation,i=m.can.transition()&&!m.has.direction()?m.get.direction()+" ":"";return c.animating+" "+c.transition+" "+i+e},currentAnimation:function(){return!(!m.cache||m.cache.animation===S)&&m.cache.animation},currentDirection:function(){return m.is.inward()?c.inward:c.outward},direction:function(){return m.is.hidden()||!m.is.visible()?c.inward:c.outward},animationDirection:function(n){var i;return"string"==typeof(n=n||d.animation)&&(n=n.split(" "),C.each(n,function(n,e){e===c.inward?i=c.inward:e===c.outward&&(i=c.outward)})),i||!1},duration:function(n){return!1===(n=n||d.duration)&&(n=f.css("animation-duration")||0),"string"==typeof n?-1<n.indexOf("ms")?parseFloat(n):1e3*parseFloat(n):n},displayType:function(n){return n=n===S||n,d.displayType?d.displayType:(n&&f.data(i.displayType)===S&&m.can.transition(!0),f.data(i.displayType))},userStyle:function(n){return(n=n||f.attr("style")||"").replace(/display.*?;/,"")},transitionExists:function(n){return C.fn.transition.exists[n]},animationStartEvent:function(){var n,e=A.createElement("div"),i={animation:"animationstart",OAnimation:"oAnimationStart",MozAnimation:"mozAnimationStart",WebkitAnimation:"webkitAnimationStart"};for(n in i)if(e.style[n]!==S)return i[n];return!1},animationEndEvent:function(){var n,e=A.createElement("div"),i={animation:"animationend",OAnimation:"oAnimationEnd",MozAnimation:"mozAnimationEnd",WebkitAnimation:"webkitAnimationEnd"};for(n in i)if(e.style[n]!==S)return i[n];return!1}},can:{transition:function(n){var e,i,t,a,o,r,s=d.animation,l=m.get.transitionExists(s),u=m.get.displayType(!1);if(l===S||n){if(m.verbose("Determining whether animation exists"),e=f.attr("class"),i=f.prop("tagName"),a=(t=C("<"+i+" />").addClass(e).insertAfter(f)).addClass(s).removeClass(c.inward).removeClass(c.outward).addClass(c.animating).addClass(c.transition).css("animationName"),o=t.addClass(c.inward).css("animationName"),u||(u=t.attr("class",e).removeAttr("style").removeClass(c.hidden).removeClass(c.visible).show().css("display"),m.verbose("Determining final display state",u),m.save.displayType(u)),t.remove(),a!=o)m.debug("Direction exists for animation",s),r=!0;else{if("none"==a||!a)return void m.debug("No animation defined in css",s);m.debug("Static animation found",s,u),r=!1}m.save.transitionExists(s,r)}return l!==S?l:r},animate:function(){return m.can.transition()!==S}},is:{animating:function(){return f.hasClass(c.animating)},inward:function(){return f.hasClass(c.inward)},outward:function(){return f.hasClass(c.outward)},looping:function(){return f.hasClass(c.looping)},occurring:function(n){return n="."+(n=n||d.animation).replace(" ","."),0<f.filter(n).length},visible:function(){return f.is(":visible")},hidden:function(){return"hidden"===f.css("visibility")},supported:function(){return!1!==a}},hide:function(){m.verbose("Hiding element"),m.is.animating()&&m.reset(),l.blur(),m.remove.display(),m.remove.visible(),m.set.hidden(),m.force.hidden(),d.onHide.call(l),d.onComplete.call(l)},show:function(n){m.verbose("Showing element",n),m.remove.hidden(),m.set.visible(),m.force.visible(),d.onShow.call(l),d.onComplete.call(l)},toggle:function(){m.is.visible()?m.hide():m.show()},stop:function(){m.debug("Stopping current animation"),f.triggerHandler(a)},stopAll:function(){m.debug("Stopping all animation"),m.remove.queueCallback(),f.triggerHandler(a)},clear:{queue:function(){m.debug("Clearing animation queue"),m.remove.queueCallback()}},enable:function(){m.verbose("Starting animation"),f.removeClass(c.disabled)},disable:function(){m.debug("Stopping animation"),f.addClass(c.disabled)},setting:function(n,e){if(m.debug("Changing setting",n,e),C.isPlainObject(n))C.extend(!0,d,n);else{if(e===S)return d[n];C.isPlainObject(d[n])?C.extend(!0,d[n],e):d[n]=e}},internal:function(n,e){if(C.isPlainObject(n))C.extend(!0,m,n);else{if(e===S)return m[n];m[n]=e}},debug:function(){!d.silent&&d.debug&&(d.performance?m.performance.log(arguments):(m.debug=Function.prototype.bind.call(console.info,console,d.name+":"),m.debug.apply(console,arguments)))},verbose:function(){!d.silent&&d.verbose&&d.debug&&(d.performance?m.performance.log(arguments):(m.verbose=Function.prototype.bind.call(console.info,console,d.name+":"),m.verbose.apply(console,arguments)))},error:function(){d.silent||(m.error=Function.prototype.bind.call(console.error,console,d.name+":"),m.error.apply(console,arguments))},performance:{log:function(n){var e,i;d.performance&&(i=(e=(new Date).getTime())-(g||e),g=e,v.push({Name:n[0],Arguments:[].slice.call(n,1)||"",Element:l,"Execution Time":i})),clearTimeout(m.performance.timer),m.performance.timer=setTimeout(m.performance.display,500)},display:function(){var n=d.name+":",i=0;g=!1,clearTimeout(m.performance.timer),C.each(v,function(n,e){i+=e["Execution Time"]}),n+=" "+i+"ms",p&&(n+=" '"+p+"'"),1<r.length&&(n+=" ("+r.length+")"),(console.group!==S||console.table!==S)&&0<v.length&&(console.groupCollapsed(n),console.table?console.table(v):C.each(v,function(n,e){console.log(e.Name+": "+e["Execution Time"]+"ms")}),console.groupEnd()),v=[]}},invoke:function(t,n,e){var a,o,i,r=s;return n=n||h,e=l||e,"string"==typeof t&&r!==S&&(t=t.split(/[\. ]/),a=t.length-1,C.each(t,function(n,e){var i=n!=a?e+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(C.isPlainObject(r[i])&&n!=a)r=r[i];else{if(r[i]!==S)return o=r[i],!1;if(!C.isPlainObject(r[e])||n==a)return r[e]!==S&&(o=r[e]),!1;r=r[e]}})),C.isFunction(o)?i=o.apply(e,n):o!==S&&(i=o),C.isArray(u)?u.push(i):u!==S?u=[u,i]:i!==S&&(u=i),o!==S&&o}}).initialize()}),u!==S?u:this},C.fn.transition.exists={},C.fn.transition.settings={name:"Transition",silent:!1,debug:!1,verbose:!1,performance:!0,namespace:"transition",interval:0,reverse:"auto",onStart:function(){},onComplete:function(){},onShow:function(){},onHide:function(){},useFailSafe:!0,failSafeDelay:100,allowRepeats:!1,displayType:!1,animation:"fade",duration:!1,queue:!0,metadata:{displayType:"display"},className:{animating:"animating",disabled:"disabled",hidden:"hidden",inward:"in",loading:"loading",looping:"looping",outward:"out",transition:"transition",visible:"visible"},error:{noAnimation:"Element is no longer attached to DOM. Unable to animate.  Use silent setting to surpress this warning in production.",repeated:"That animation is already occurring, cancelling repeated animation",method:"The method you called is not defined",support:"This browser does not support CSS animations"}}}(jQuery,window,document);
/*!
 * # Semantic UI 2.2.2 - Dimmer
 * http://github.com/semantic-org/semantic-ui/
 *
 */
!function(e,i,n,t){"use strict";i="undefined"!=typeof i&&i.Math==Math?i:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.dimmer=function(i){var o,a=e(this),r=(new Date).getTime(),s=[],m=arguments[0],d="string"==typeof m,c=[].slice.call(arguments,1);return a.each(function(){var u,l,f,g=e.isPlainObject(i)?e.extend(!0,{},e.fn.dimmer.settings,i):e.extend({},e.fn.dimmer.settings),p=g.selector,h=g.namespace,b=g.className,v=g.error,y="."+h,C="module-"+h,w=a.selector||"",S="ontouchstart"in n.documentElement?"touchstart":"click",D=e(this),T=this,N=D.data(C);f={preinitialize:function(){f.is.dimmer()?(l=D.parent(),u=D):(l=D,u=f.has.dimmer()?g.dimmerName?l.find(p.dimmer).filter("."+g.dimmerName):l.find(p.dimmer):f.create(),f.set.variation())},initialize:function(){f.debug("Initializing dimmer",g),f.bind.events(),f.set.dimmable(),f.instantiate()},instantiate:function(){f.verbose("Storing instance of module",f),N=f,D.data(C,N)},destroy:function(){f.verbose("Destroying previous module",u),f.unbind.events(),f.remove.variation(),l.off(y)},bind:{events:function(){"hover"==g.on?l.on("mouseenter"+y,f.show).on("mouseleave"+y,f.hide):"click"==g.on&&l.on(S+y,f.toggle),f.is.page()&&(f.debug("Setting as a page dimmer",l),f.set.pageDimmer()),f.is.closable()&&(f.verbose("Adding dimmer close event",u),l.on(S+y,p.dimmer,f.event.click))}},unbind:{events:function(){D.removeData(C),l.off(y)}},event:{click:function(i){f.verbose("Determining if event occured on dimmer",i),(0===u.find(i.target).length||e(i.target).is(p.content))&&(f.hide(),i.stopImmediatePropagation())}},addContent:function(i){var n=e(i);f.debug("Add content to dimmer",n),n.parent()[0]!==u[0]&&n.detach().appendTo(u)},create:function(){var i=e(g.template.dimmer());return g.dimmerName&&(f.debug("Creating named dimmer",g.dimmerName),i.addClass(g.dimmerName)),i.appendTo(l),i},show:function(i){i=e.isFunction(i)?i:function(){},f.debug("Showing dimmer",u,g),f.is.dimmed()&&!f.is.animating()||!f.is.enabled()?f.debug("Dimmer is already shown or disabled"):(f.animate.show(i),g.onShow.call(T),g.onChange.call(T))},hide:function(i){i=e.isFunction(i)?i:function(){},f.is.dimmed()||f.is.animating()?(f.debug("Hiding dimmer",u),f.animate.hide(i),g.onHide.call(T),g.onChange.call(T)):f.debug("Dimmer is not visible")},toggle:function(){f.verbose("Toggling dimmer visibility",u),f.is.dimmed()?f.hide():f.show()},animate:{show:function(i){i=e.isFunction(i)?i:function(){},g.useCSS&&e.fn.transition!==t&&u.transition("is supported")?("auto"!==g.opacity&&f.set.opacity(),u.transition({animation:g.transition+" in",queue:!1,duration:f.get.duration(),useFailSafe:!0,onStart:function(){f.set.dimmed()},onComplete:function(){f.set.active(),i()}})):(f.verbose("Showing dimmer animation with javascript"),f.set.dimmed(),"auto"==g.opacity&&(g.opacity=.8),u.stop().css({opacity:0,width:"100%",height:"100%"}).fadeTo(f.get.duration(),g.opacity,function(){u.removeAttr("style"),f.set.active(),i()}))},hide:function(i){i=e.isFunction(i)?i:function(){},g.useCSS&&e.fn.transition!==t&&u.transition("is supported")?(f.verbose("Hiding dimmer with css"),u.transition({animation:g.transition+" out",queue:!1,duration:f.get.duration(),useFailSafe:!0,onStart:function(){f.remove.dimmed()},onComplete:function(){f.remove.active(),i()}})):(f.verbose("Hiding dimmer with javascript"),f.remove.dimmed(),u.stop().fadeOut(f.get.duration(),function(){f.remove.active(),u.removeAttr("style"),i()}))}},get:{dimmer:function(){return u},duration:function(){return"object"==typeof g.duration?f.is.active()?g.duration.hide:g.duration.show:g.duration}},has:{dimmer:function(){return g.dimmerName?D.find(p.dimmer).filter("."+g.dimmerName).length>0:D.find(p.dimmer).length>0}},is:{active:function(){return u.hasClass(b.active)},animating:function(){return u.is(":animated")||u.hasClass(b.animating)},closable:function(){return"auto"==g.closable?"hover"==g.on?!1:!0:g.closable},dimmer:function(){return D.hasClass(b.dimmer)},dimmable:function(){return D.hasClass(b.dimmable)},dimmed:function(){return l.hasClass(b.dimmed)},disabled:function(){return l.hasClass(b.disabled)},enabled:function(){return!f.is.disabled()},page:function(){return l.is("body")},pageDimmer:function(){return u.hasClass(b.pageDimmer)}},can:{show:function(){return!u.hasClass(b.disabled)}},set:{opacity:function(e){var i=u.css("background-color"),n=i.split(","),t=n&&3==n.length,o=n&&4==n.length;e=0===g.opacity?0:g.opacity||e,t||o?(n[3]=e+")",i=n.join(",")):i="rgba(0, 0, 0, "+e+")",f.debug("Setting opacity to",e),u.css("background-color",i)},active:function(){u.addClass(b.active)},dimmable:function(){l.addClass(b.dimmable)},dimmed:function(){l.addClass(b.dimmed)},pageDimmer:function(){u.addClass(b.pageDimmer)},disabled:function(){u.addClass(b.disabled)},variation:function(e){e=e||g.variation,e&&u.addClass(e)}},remove:{active:function(){u.removeClass(b.active)},dimmed:function(){l.removeClass(b.dimmed)},disabled:function(){u.removeClass(b.disabled)},variation:function(e){e=e||g.variation,e&&u.removeClass(e)}},setting:function(i,n){if(f.debug("Changing setting",i,n),e.isPlainObject(i))e.extend(!0,g,i);else{if(n===t)return g[i];e.isPlainObject(g[i])?e.extend(!0,g[i],n):g[i]=n}},internal:function(i,n){if(e.isPlainObject(i))e.extend(!0,f,i);else{if(n===t)return f[i];f[i]=n}},debug:function(){!g.silent&&g.debug&&(g.performance?f.performance.log(arguments):(f.debug=Function.prototype.bind.call(console.info,console,g.name+":"),f.debug.apply(console,arguments)))},verbose:function(){!g.silent&&g.verbose&&g.debug&&(g.performance?f.performance.log(arguments):(f.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),f.verbose.apply(console,arguments)))},error:function(){g.silent||(f.error=Function.prototype.bind.call(console.error,console,g.name+":"),f.error.apply(console,arguments))},performance:{log:function(e){var i,n,t;g.performance&&(i=(new Date).getTime(),t=r||i,n=i-t,r=i,s.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:T,"Execution Time":n})),clearTimeout(f.performance.timer),f.performance.timer=setTimeout(f.performance.display,500)},display:function(){var i=g.name+":",n=0;r=!1,clearTimeout(f.performance.timer),e.each(s,function(e,i){n+=i["Execution Time"]}),i+=" "+n+"ms",w&&(i+=" '"+w+"'"),a.length>1&&(i+=" ("+a.length+")"),(console.group!==t||console.table!==t)&&s.length>0&&(console.groupCollapsed(i),console.table?console.table(s):e.each(s,function(e,i){console.log(i.Name+": "+i["Execution Time"]+"ms")}),console.groupEnd()),s=[]}},invoke:function(i,n,a){var r,s,m,d=N;return n=n||c,a=T||a,"string"==typeof i&&d!==t&&(i=i.split(/[\. ]/),r=i.length-1,e.each(i,function(n,o){var a=n!=r?o+i[n+1].charAt(0).toUpperCase()+i[n+1].slice(1):i;if(e.isPlainObject(d[a])&&n!=r)d=d[a];else{if(d[a]!==t)return s=d[a],!1;if(!e.isPlainObject(d[o])||n==r)return d[o]!==t?(s=d[o],!1):(f.error(v.method,i),!1);d=d[o]}})),e.isFunction(s)?m=s.apply(a,n):s!==t&&(m=s),e.isArray(o)?o.push(m):o!==t?o=[o,m]:m!==t&&(o=m),s}},f.preinitialize(),d?(N===t&&f.initialize(),f.invoke(m)):(N!==t&&N.invoke("destroy"),f.initialize())}),o!==t?o:this},e.fn.dimmer.settings={name:"Dimmer",namespace:"dimmer",silent:!1,debug:!1,verbose:!1,performance:!0,dimmerName:!1,variation:!1,closable:"auto",useCSS:!0,transition:"fade",on:!1,opacity:"auto",duration:{show:500,hide:500},onChange:function(){},onShow:function(){},onHide:function(){},error:{method:"The method you called is not defined."},className:{active:"active",animating:"animating",dimmable:"dimmable",dimmed:"dimmed",dimmer:"dimmer",disabled:"disabled",hide:"hide",pageDimmer:"page",show:"show"},selector:{dimmer:"> .wojo.dimmer",content:".wojo.dimmer > .content, .wojo.dimmer > .content > .center"},template:{dimmer:function(){return e("<div />").attr("class","wojo dimmer")}}}}(jQuery,window,document);
/*!
 * # Semantic UI 2.2.2 - Modal
 * http://github.com/semantic-org/semantic-ui/
 */
!function(e,n,i,t){"use strict";n="undefined"!=typeof n&&n.Math==Math?n:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.modal=function(o){var a,r=e(this),s=e(n),c=e(i),l=e("body"),d=r.selector||"",u=(new Date).getTime(),m=[],f=arguments[0],g="string"==typeof f,h=[].slice.call(arguments,1),v=n.requestAnimationFrame||n.mozRequestAnimationFrame||n.webkitRequestAnimationFrame||n.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var r,b,p,y,k,w,M,C,S,F=e.isPlainObject(o)?e.extend(!0,{},e.fn.modal.settings,o):e.extend({},e.fn.modal.settings),A=F.selector,D=F.className,H=F.namespace,T=F.error,x="."+H,z="module-"+H,O=e(this),q=e(F.context),E=O.find(A.close),j=this,P=O.data(z);S={initialize:function(){S.verbose("Initializing dimmer",q),S.create.id(),S.create.dimmer(),S.refreshModals(),S.bind.events(),F.observeChanges&&S.observeChanges(),S.instantiate()},instantiate:function(){S.verbose("Storing instance of modal"),P=S,O.data(z,P)},create:{dimmer:function(){var n={debug:F.debug,dimmerName:"modals",duration:{show:F.duration,hide:F.duration}},i=e.extend(!0,n,F.dimmerSettings);return F.inverted&&(i.variation=i.variation!==t?i.variation+" inverted":"inverted"),e.fn.dimmer===t?void S.error(T.dimmer):(S.debug("Creating dimmer with settings",i),y=q.dimmer(i),F.detachable?(S.verbose("Modal is detachable, moving content into dimmer"),y.dimmer("add content",O)):S.set.undetached(),F.blurring&&y.addClass(D.blurring),void(k=y.dimmer("get dimmer")))},id:function(){M=(Math.random().toString(16)+"000000000").substr(2,8),w="."+M,S.verbose("Creating unique id for element",M)}},destroy:function(){S.verbose("Destroying previous modal"),O.removeData(z).off(x),s.off(w),k.off(w),E.off(x),q.dimmer("destroy")},observeChanges:function(){"MutationObserver"in n&&(C=new MutationObserver(function(e){S.debug("DOM tree modified, refreshing"),S.refresh()}),C.observe(j,{childList:!0,subtree:!0}),S.debug("Setting up mutation observer",C))},refresh:function(){S.remove.scrolling(),S.cacheSizes(),S.set.screenHeight(),S.set.type(),S.set.position()},refreshModals:function(){b=O.siblings(A.modal),r=b.add(O)},attachEvents:function(n,i){var t=e(n);i=e.isFunction(S[i])?S[i]:S.toggle,t.length>0?(S.debug("Attaching modal events to element",n,i),t.off(x).on("click"+x,i)):S.error(T.notFound,n)},bind:{events:function(){S.verbose("Attaching events"),O.on("click"+x,A.close,S.event.close).on("click"+x,A.approve,S.event.approve).on("click"+x,A.deny,S.event.deny),s.on("resize"+w,S.event.resize)}},get:{id:function(){return(Math.random().toString(16)+"000000000").substr(2,8)}},event:{approve:function(){return F.onApprove.call(j,e(this))===!1?void S.verbose("Approve callback returned false cancelling hide"):void S.hide()},deny:function(){return F.onDeny.call(j,e(this))===!1?void S.verbose("Deny callback returned false cancelling hide"):void S.hide()},close:function(){S.hide()},click:function(n){var t=e(n.target),o=t.closest(A.modal).length>0,a=e.contains(i.documentElement,n.target);!o&&a&&(S.debug("Dimmer clicked, hiding all modals"),S.is.active()&&(S.remove.clickaway(),F.allowMultiple?S.hide():S.hideAll()))},debounce:function(e,n){clearTimeout(S.timer),S.timer=setTimeout(e,n)},keyboard:function(e){var n=e.which,i=27;n==i&&(F.closable?(S.debug("Escape key pressed hiding modal"),S.hide()):S.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){y.dimmer("is active")&&v(S.refresh)}},toggle:function(){S.is.active()||S.is.animating()?S.hide():S.show()},show:function(n){n=e.isFunction(n)?n:function(){},S.refreshModals(),S.showModal(n)},hide:function(n){n=e.isFunction(n)?n:function(){},S.refreshModals(),S.hideModal(n)},showModal:function(n){n=e.isFunction(n)?n:function(){},S.is.animating()||!S.is.active()?(S.showDimmer(),S.cacheSizes(),S.set.position(),S.set.screenHeight(),S.set.type(),S.set.clickaway(),!F.allowMultiple&&S.others.active()?S.hideOthers(S.showModal):(F.onShow.call(j),F.transition&&e.fn.transition!==t&&O.transition("is supported")?(S.debug("Showing modal with css animations"),O.transition({debug:F.debug,animation:F.transition+" in",queue:F.queue,duration:F.duration,useFailSafe:!0,onComplete:function(){F.onVisible.apply(j),S.add.keyboardShortcuts(),S.save.focus(),S.set.active(),F.autofocus&&S.set.autofocus(),n()}})):S.error(T.noTransition))):S.debug("Modal is already visible")},hideModal:function(n,i){return n=e.isFunction(n)?n:function(){},S.debug("Hiding modal"),F.onHide.call(j,e(this))===!1?void S.verbose("Hide callback returned false cancelling hide"):void((S.is.animating()||S.is.active())&&(F.transition&&e.fn.transition!==t&&O.transition("is supported")?(S.remove.active(),O.transition({debug:F.debug,animation:F.transition+" out",queue:F.queue,duration:F.duration,useFailSafe:!0,onStart:function(){S.others.active()||i||S.hideDimmer(),S.remove.keyboardShortcuts()},onComplete:function(){F.onHidden.call(j),S.restore.focus(),n()}})):S.error(T.noTransition)))},showDimmer:function(){y.dimmer("is animating")||!y.dimmer("is active")?(S.debug("Showing dimmer"),y.dimmer("show")):S.debug("Dimmer already visible")},hideDimmer:function(){return y.dimmer("is animating")||y.dimmer("is active")?void y.dimmer("hide",function(){S.remove.clickaway(),S.remove.screenHeight()}):void S.debug("Dimmer is not visible cannot hide")},hideAll:function(n){var i=r.filter("."+D.active+", ."+D.animating);n=e.isFunction(n)?n:function(){},i.length>0&&(S.debug("Hiding all visible modals"),S.hideDimmer(),i.modal("hide modal",n))},hideOthers:function(n){var i=b.filter("."+D.active+", ."+D.animating);n=e.isFunction(n)?n:function(){},i.length>0&&(S.debug("Hiding other modals",b),i.modal("hide modal",n,!0))},others:{active:function(){return b.filter("."+D.active).length>0},animating:function(){return b.filter("."+D.animating).length>0}},add:{keyboardShortcuts:function(){S.verbose("Adding keyboard shortcuts"),c.on("keyup"+x,S.event.keyboard)}},save:{focus:function(){p=e(i.activeElement).blur()}},restore:{focus:function(){p&&p.length>0&&p.focus()}},remove:{active:function(){O.removeClass(D.active)},clickaway:function(){F.closable&&k.off("click"+w)},bodyStyle:function(){""===l.attr("style")&&(S.verbose("Removing style attribute"),l.removeAttr("style"))},screenHeight:function(){S.debug("Removing page height"),l.css("height","")},keyboardShortcuts:function(){S.verbose("Removing keyboard shortcuts"),c.off("keyup"+x)},scrolling:function(){y.removeClass(D.scrolling),O.removeClass(D.scrolling)}},cacheSizes:function(){var o=O.outerHeight();(S.cache===t||0!==o)&&(S.cache={pageHeight:e(i).outerHeight(),height:o+F.offset,contextHeight:"body"==F.context?e(n).height():y.height()}),S.debug("Caching modal and container sizes",S.cache)},can:{fit:function(){return S.cache.height+2*F.padding<S.cache.contextHeight}},is:{active:function(){return O.hasClass(D.active)},animating:function(){return O.transition("is supported")?O.transition("is animating"):O.is(":visible")},scrolling:function(){return y.hasClass(D.scrolling)},modernBrowser:function(){return!(n.ActiveXObject||"ActiveXObject"in n)}},set:{autofocus:function(){var e=O.find(":input").filter(":visible"),n=e.filter("[autofocus]"),i=n.length>0?n.first():e.first();i.length>0&&i.focus()},clickaway:function(){F.closable&&k.on("click"+w,S.event.click)},screenHeight:function(){S.can.fit()?l.css("height",""):(S.debug("Modal is taller than page content, resizing page height"),l.css("height",S.cache.height+2*F.padding))},active:function(){O.addClass(D.active)},scrolling:function(){y.addClass(D.scrolling),O.addClass(D.scrolling)},type:function(){S.can.fit()?(S.verbose("Modal fits on screen"),S.others.active()||S.others.animating()||S.remove.scrolling()):(S.verbose("Modal cannot fit on screen setting to scrolling"),S.set.scrolling())},position:function(){S.verbose("Centering modal on page",S.cache),S.can.fit()?O.css({top:"",marginTop:-(S.cache.height/2)}):O.css({marginTop:"",top:c.scrollTop()})},undetached:function(){y.addClass(D.undetached)}},setting:function(n,i){if(S.debug("Changing setting",n,i),e.isPlainObject(n))e.extend(!0,F,n);else{if(i===t)return F[n];e.isPlainObject(F[n])?e.extend(!0,F[n],i):F[n]=i}},internal:function(n,i){if(e.isPlainObject(n))e.extend(!0,S,n);else{if(i===t)return S[n];S[n]=i}},debug:function(){!F.silent&&F.debug&&(F.performance?S.performance.log(arguments):(S.debug=Function.prototype.bind.call(console.info,console,F.name+":"),S.debug.apply(console,arguments)))},verbose:function(){!F.silent&&F.verbose&&F.debug&&(F.performance?S.performance.log(arguments):(S.verbose=Function.prototype.bind.call(console.info,console,F.name+":"),S.verbose.apply(console,arguments)))},error:function(){F.silent||(S.error=Function.prototype.bind.call(console.error,console,F.name+":"),S.error.apply(console,arguments))},performance:{log:function(e){var n,i,t;F.performance&&(n=(new Date).getTime(),t=u||n,i=n-t,u=n,m.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:j,"Execution Time":i})),clearTimeout(S.performance.timer),S.performance.timer=setTimeout(S.performance.display,500)},display:function(){var n=F.name+":",i=0;u=!1,clearTimeout(S.performance.timer),e.each(m,function(e,n){i+=n["Execution Time"]}),n+=" "+i+"ms",d&&(n+=" '"+d+"'"),(console.group!==t||console.table!==t)&&m.length>0&&(console.groupCollapsed(n),console.table?console.table(m):e.each(m,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),m=[]}},invoke:function(n,i,o){var r,s,c,l=P;return i=i||h,o=j||o,"string"==typeof n&&l!==t&&(n=n.split(/[\. ]/),r=n.length-1,e.each(n,function(i,o){var a=i!=r?o+n[i+1].charAt(0).toUpperCase()+n[i+1].slice(1):n;if(e.isPlainObject(l[a])&&i!=r)l=l[a];else{if(l[a]!==t)return s=l[a],!1;if(!e.isPlainObject(l[o])||i==r)return l[o]!==t?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,i):s!==t&&(c=s),e.isArray(a)?a.push(c):a!==t?a=[a,c]:c!==t&&(a=c),s}},g?(P===t&&S.initialize(),S.invoke(f)):(P!==t&&P.invoke("destroy"),S.initialize())}),a!==t?a:this},e.fn.modal.settings={name:"Modal",namespace:"modal",silent:!1,debug:!1,verbose:!1,performance:!0,observeChanges:!1,allowMultiple:!0,detachable:!0,closable:!0,autofocus:!1,inverted:!1,blurring:!1,dimmerSettings:{closable:!1,useCSS:!0},context:"body",queue:!1,duration:500,offset:0,transition:"scale",padding:50,onShow:function(){},onVisible:function(){},onHide:function(){return!0},onHidden:function(){},onApprove:function(){return!0},onDeny:function(){return!0},selector:{close:"> .close",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".wojo.modal"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",blurring:"blurring",scrolling:"scrolling",undetached:"undetached"}}}(jQuery,window,document);
/*!
 * # Select Box Replacement
 * http://hemantnegi.github.io/jquery.sumoselect
 * http://wojoscripts.com
 */
(function(factory){'use strict';var module,require,define;if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports!=='undefined'){module.exports=factory(require('jquery'))}else{factory(jQuery)}})(function($){'use strict';'namespace wselect';$.fn.wojoSelect=function(options){var ret=this.each(function(){var selObj=this;var settings=$.extend({placeholder:'Select Here',csvDispCount:3,captionFormat:'{0} Selected',captionFormatAllSelected:'{0} all selected!',floatWidth:400,doFloat:false,forceCustomRendering:false,nativeOnDevice:['Android','BlackBerry','iPhone','iPad','iPod','Opera Mini','IEMobile','Silk'],outputAsCSV:false,csvSepChar:',',okCancelInMulti:false,isClickAwayOk:false,triggerChangeCombined:true,selectAll:false,search:false,searchText:'Search...',noMatch:'No matches for "{0}"',prefix:'',locale:['OK','Cancel','Select All'],up:false,showTitle:true},$(selObj).data('wselect'),options);if(this.wselect||!$(this).is('select')){return}this.wselect={E:$(selObj),is_multi:$(selObj).attr('multiple'),select:'',caption:'',placeholder:'',optDiv:'',CaptionCont:'',ul:'',is_floating:false,is_opened:false,mob:false,Pstate:[],createElems:function(){var O=this;O.E.wrap('<div class="wojo select '+O.E.attr("class")+'" tabindex="0" role="button" aria-expanded="false">');O.select=O.E.parent();O.caption=$('<span>');O.CaptionCont=$('<p class="counter"><label><i class="icon chevron down"></i></label></p>').attr('style',O.E.attr('style')).prepend(O.caption);O.select.append(O.CaptionCont);if(!O.is_multi){settings.okCancelInMulti=false}if(O.E.attr('disabled')){O.select.addClass('disabled').removeAttr('tabindex')}if(settings.outputAsCSV&&O.is_multi&&O.E.attr('name')){O.select.append($('<input class="HEMANT123" type="hidden" />').attr('name',O.E.attr('name')).val(O.getSelStr()));O.E.removeAttr('name')}if(O.isMobile()&&!settings.forceCustomRendering){O.setNativeMobile();return}if(O.E.attr('class')){O.select.addClass(O.E.attr('class'))}O.E.addClass('hideselect').attr('tabindex','-1');O.select.removeClass('hideselect');O.optDiv=$('<div class="menu '+(settings.up?'upward':'')+'">');O.floatingList();O.ul=$('<ul class="options">');O.optDiv.append(O.ul);if(settings.selectAll&&O.is_multi){O.SelAll()}if(settings.search){O.Search()}O.ul.append(O.prepItems(O.E.children()));if(O.is_multi){O.multiSelelect()}O.select.append(O.optDiv);O.basicEvents();O.selAllState()},prepItems:function(opts,d){var lis=[],O=this;$(opts).each(function(i,opt){opt=$(opt);lis.push(opt.is('optgroup')?$('<li class="group '+(opt[0].disabled?'disabled':'')+'"><label>'+opt.attr('label')+'</label><ul></ul></li>').find('ul').append(O.prepItems(opt.children(),opt[0].disabled)).end():O.createLi(opt,d))});return lis},createLi:function(opt,d){var O=this;if(!opt.attr('value')){opt.attr('value',opt.val())}var li=$('<li class="item"><label>'+opt.text()+'</label></li>');li.data('opt',opt);opt.data('li',li);if(O.is_multi){li.prepend('<span></span>')}if(opt[0].disabled||d){li=li.addClass('disabled')}O.onOptClick(li);if(opt[0].selected){li.addClass('selected')}if(opt.attr('class')){li.addClass(opt.attr('class'))}if(opt.attr('title')){li.attr('title',opt.attr('title'))}return li},getSelStr:function(){var sopt=[];this.E.find('option:selected').each(function(){sopt.push($(this).val())});return sopt.join(settings.csvSepChar)},multiSelelect:function(){var O=this;O.optDiv.addClass('multiple');O.okbtn=$('<button tabindex="0" class="btnOk" type="button">'+settings.locale[0]+'</button>').click(function(){O._okbtn();O.hideOpts()});O.cancelBtn=$('<button tabindex="0" class="btnCancel" type="button">'+settings.locale[1]+'</button>').click(function(){O._cnbtn();O.hideOpts()});var btns=O.okbtn.add(O.cancelBtn);O.optDiv.append($('<div class="actions">').append(btns));btns.on('keydown.wselect',function(e){var el=$(this);switch(e.which){case 32:case 13:el.trigger('click');break;case 9:if(el.hasClass('btnOk')){return}case 27:O._cnbtn();O.hideOpts();return}e.stopPropagation();e.preventDefault()})},_okbtn:function(){var O=this,cg=0;if(settings.triggerChangeCombined){if(O.E.find('option:selected').length!==O.Pstate.length){cg=1}else{O.E.find('option').each(function(i,e){if(e.selected&&O.Pstate.indexOf(i)<0){cg=1}})}if(cg){O.callChange();O.setText()}}},_cnbtn:function(){var O=this;O.E.find('option:selected').each(function(){this.selected=false});O.optDiv.find('li.selected').removeClass('selected');for(var i=0;i<O.Pstate.length;i++){O.E.find('option')[O.Pstate[i]].selected=true;O.ul.find('li.item').eq(O.Pstate[i]).addClass('selected')}O.selAllState()},SelAll:function(){var O=this;if(!O.is_multi){return}O.selAll=$('<p class="all"><span></span><label>'+settings.locale[2]+'</label></p>');O.optDiv.addClass('selall');O.selAll.on('click',function(){O.selAll.toggleClass('selected');O.toggSelAll(O.selAll.hasClass('selected'),1)});O.optDiv.prepend(O.selAll)},Search:function(){var O=this,cc=O.CaptionCont.addClass('search'),P=$('<p class="notice">');O.ftxt=$('<input type="text" class="text" value="" placeholder="'+settings.searchText+'">').on('click',function(event){event.stopPropagation()});cc.append(O.ftxt);O.optDiv.children('ul').after(P);O.ftxt.on('keyup.wselect',function(){var hid=O.optDiv.find('ul.options li.item').each(function(ix,e){var el=$(e),opt=el.data('opt')[0];opt.hidden=el.text().toLowerCase().indexOf(O.ftxt.val().toLowerCase())<0;el.toggleClass('filtered',opt.hidden)}).not('.filtered');P.html(settings.noMatch.replace(/\{0\}/g,'<em></em>')).toggle(!hid.length);P.find('em').text(O.ftxt.val());O.selAllState()})},selAllState:function(){var O=this;if(settings.selectAll&&O.is_multi){var sc=0,vc=0;O.optDiv.find('li.item').not('.filtered').each(function(ix,e){if($(e).hasClass('selected')){sc++}if(!$(e).hasClass('disabled')){vc++}});if(sc===vc){O.selAll.removeClass('partial').addClass('selected')}else if(sc===0){O.selAll.removeClass('selected partial')}else{O.selAll.addClass('partial')}}},showOpts:function(){var O=this;if(O.E.attr('disabled')){return}O.E.trigger('wselect:opening',O);O.is_opened=true;O.select.addClass('open').attr('aria-expanded','true');O.E.trigger('wselect:opened',O);if(O.ftxt){O.ftxt.focus()}else{O.select.focus()}$(document).on('click.wselect',function(e){if(!O.select.is(e.target)&&O.select.has(e.target).length===0){if(!O.is_opened){return}O.hideOpts();if(settings.okCancelInMulti){if(settings.isClickAwayOk){O._okbtn()}else{O._cnbtn()}}}});if(O.is_floating){var H=O.optDiv.children('ul').outerHeight()+2;if(O.is_multi){H=H+parseInt(O.optDiv.css('padding-bottom'))}O.optDiv.css('height',H);$('body').addClass('stopscroll')}O.setPstate()},setPstate:function(){var O=this;if(O.is_multi&&(O.is_floating||settings.okCancelInMulti)){O.Pstate=[];O.E.find('option').each(function(i,e){if(e.selected){O.Pstate.push(i)}})}},callChange:function(){this.E.trigger('change').trigger('click')},hideOpts:function(){var O=this;if(O.is_opened){O.E.trigger('wselect:closing',O);O.is_opened=false;O.select.removeClass('open').attr('aria-expanded','true').find('ul li.sel').removeClass('sel');O.E.trigger('wselect:closed',O);$(document).off('click.wselect');O.select.focus();$('body').removeClass('stopscroll');if(settings.search){O.ftxt.val('');O.ftxt.trigger('keyup.wselect')}}},setOnOpen:function(){var O=this,li=O.optDiv.find('li.item:not(.filtered)').eq(settings.search?0:O.E[0].selectedIndex);if(li.hasClass('disabled')){li=li.next(':not(disabled)');if(!li.length){return}}O.optDiv.find('li.sel').removeClass('sel');li.addClass('sel');O.showOpts()},nav:function(up){var O=this,c,s=O.ul.find('li.item:not(.disabled, .filtered)'),sel=O.ul.find('li.item.sel:not(.filtered)'),idx=s.index(sel);if(O.is_opened&&sel.length){if(up&&idx>0){c=s.eq(idx-1)}else if(!up&&idx<s.length-1&&idx>-1){c=s.eq(idx+1)}else{return}sel.removeClass('sel');sel=c.addClass('sel');var ul=O.ul,st=ul.scrollTop(),t=sel.position().top+st;if(t>=st+ul.height()-sel.outerHeight()){ul.scrollTop(t-ul.height()+sel.outerHeight())}if(t<st){ul.scrollTop(t)}}else{O.setOnOpen()}},basicEvents:function(){var O=this;O.CaptionCont.click(function(evt){O.E.trigger('click');if(O.is_opened){O.hideOpts()}else{O.showOpts()}evt.stopPropagation()});O.select.on('keydown.wselect',function(e){switch(e.which){case 38:O.nav(true);break;case 40:O.nav(false);break;case 65:if(O.is_multi&&e.ctrlKey){O.toggSelAll(!e.shiftKey,1);break}else{return}case 32:if(settings.search&&O.ftxt.is(e.target)){return}case 13:if(O.is_opened){O.optDiv.find('ul li.sel').trigger('click')}else{O.setOnOpen()}break;case 9:if(!settings.okCancelInMulti){O.hideOpts()}return;case 27:if(settings.okCancelInMulti){O._cnbtn()}O.hideOpts();return;default:return}e.preventDefault()});$(window).on('resize.wselect',function(){O.floatingList()})},onOptClick:function(li){var O=this;li.click(function(){var li=$(this);if(li.hasClass('disabled')){return}if(O.is_multi){li.toggleClass('selected');li.data('opt')[0].selected=li.hasClass('selected');O.selAllState()}else{li.parent().find('li.selected').removeClass('selected');li.toggleClass('selected');li.data('opt')[0].selected=true}if(!(O.is_multi&&settings.triggerChangeCombined&&(O.is_floating||settings.okCancelInMulti))){O.setText();O.callChange()}if(!O.is_multi){O.hideOpts()}})},setText:function(){var O=this;O.placeholder="";if(O.is_multi){var sels=O.E.find(':selected').not(':disabled');for(var i=0;i<sels.length;i++){if(i+1>=settings.csvDispCount&&settings.csvDispCount){if(sels.length==O.E.find('option').length&&settings.captionFormatAllSelected){O.placeholder=settings.captionFormatAllSelected.replace(/\{0\}/g,sels.length)+','}else{O.placeholder=settings.captionFormat.replace(/\{0\}/g,sels.length)+','}break}else{O.placeholder+=$(sels[i]).text()+", "}}O.placeholder=O.placeholder.replace(/,([^,]*)$/,'$1')}else{O.placeholder=O.E.find(':selected').not(':disabled').text()}var is_placeholder=false;if(!O.placeholder){is_placeholder=true;O.placeholder=O.E.attr('placeholder');if(!O.placeholder){O.placeholder=O.E.find('option:disabled:selected').text()}}O.placeholder=O.placeholder?(settings.prefix+' '+O.placeholder):settings.placeholder;O.caption.html(O.placeholder);if(settings.showTitle){O.CaptionCont.attr('title',O.placeholder)}var csvField=O.select.find('input.HEMANT123');if(csvField.length){csvField.val(O.getSelStr())}if(is_placeholder){O.caption.addClass('placeholder')}else{O.caption.removeClass('placeholder')}return O.placeholder},isMobile:function(){if('ontouchstart'in window&&/Mobi/.test(navigator.userAgent)){return true}else{return false}},setNativeMobile:function(){var O=this;O.E.addClass('mobile-ready');O.select.removeClass('mobile-ready');O.mob=true;O.E.change(function(){O.setText()})},floatingList:function(){var O=this;O.is_floating=$(window).width()<=settings.floatWidth || settings.doFloat;O.optDiv.toggleClass('floating',O.is_floating);if(!O.is_floating){O.optDiv.css('height','')}O.optDiv.toggleClass('controls',settings.okCancelInMulti&&!O.is_floating)},vRange:function(i){var O=this;var opts=O.E.find('option');if(opts.length<=i||i<0){throw"index out of bounds";}return O},toggSel:function(c,i){var O=this;var opt;if(typeof(i)==="number"){O.vRange(i);opt=O.E.find('option')[i]}else{opt=O.E.find('option[value="'+i+'"]')[0]||0}if(!opt||opt.disabled){return}if(opt.selected!=c){opt.selected=c;if(!O.mob){$(opt).data('li').toggleClass('selected',c)}O.callChange();O.setPstate();O.setText();O.selAllState()}},toggDis:function(c,i){var O=this.vRange(i);O.E.find('option')[i].disabled=c;if(c){O.E.find('option')[i].selected=false}if(!O.mob){O.optDiv.find('ul.options li').eq(i).toggleClass('disabled',c).removeClass('selected')}O.setText()},toggWselect:function(val){var O=this;O.enabled=val;O.select.toggleClass('disabled',val);if(val){O.E.attr('disabled','disabled');O.select.removeAttr('tabindex')}else{O.E.removeAttr('disabled');O.select.attr('tabindex','0')}return O},toggSelAll:function(c,direct){var O=this;O.E.find('option:not(:disabled,:hidden)').each(function(ix,e){var is_selected=e.selected,el=$(e).data('li');if(el.hasClass('filtered')){return}if(!!c){if(!is_selected){el.trigger('click')}}else{if(is_selected){el.trigger('click')}}});if(!direct){if(!O.mob&&O.selAll){O.selAll.removeClass('partial').toggleClass('selected',!!c)}O.callChange();O.setText();O.setPstate()}},refresh:function(){var elm=this.unload();return $(elm).wojoSelect(settings)},unload:function(){var O=this;O.select.before(O.E);O.E.show();if(settings.outputAsCSV&&O.is_multi&&O.select.find('input.HEMANT123').length){O.E.attr('name',O.select.find('input.HEMANT123').attr('name'))}O.select.remove();delete selObj.wselect;return selObj},add:function(val,txt,i){if(typeof val==="undefined"){throw"No value to add";}var O=this;var opts=O.E.find('option');if(typeof txt==="number"){i=txt;txt=val}if(typeof txt==="undefined"){txt=val}var opt=$("<option></option>").val(val).html(txt);if(opts.length<i){throw"index out of bounds";}if(typeof i==="undefined"||opts.length===i){O.E.append(opt);if(!O.mob){O.ul.append(O.createLi(opt))}}else{opts.eq(i).before(opt);if(!O.mob){O.ul.find('li.item').eq(i).before(O.createLi(opt))}}return selObj},remove:function(i){var O=this.vRange(i);O.E.find('option').eq(i).remove();if(!O.mob){O.optDiv.find('ul.options li').eq(i).remove()}O.setText()},selectItem:function(i){this.toggSel(true,i)},unSelectItem:function(i){this.toggSel(false,i)},selectAll:function(){this.toggSelAll(true)},unSelectAll:function(){this.toggSelAll(false)},disableItem:function(i){this.toggDis(true,i)},enableItem:function(i){this.toggDis(false,i)},enabled:true,enable:function(){return this.toggWselect(false)},disable:function(){return this.toggWselect(true)},init:function(){var O=this;O.createElems();O.setText();return O}};selObj.wselect.init()});return ret.length===1?ret[0]:ret}});
/*
 * @Dropdowns
 *
 */
(function($){"use strict";var showDropdown;$.fn.wDropdown=function(method,data){switch(method){case'attach':return $(this).attr('data-dropdown',data);case'detach':return $(this).removeAttr('data-dropdown');case'show':return $(this).click();case'hide':$.wDropdown.hideAll();return $(this);case'enable':return $(this).removeClass('dropdown-disabled');case'disable':return $(this).addClass('dropdown-disabled')}};$.wDropdown=function(){};$.wDropdown.attachAll=function(){$('body').off('click.dropdown').on('click.dropdown','[data-dropdown]',showDropdown);$('[data-dropdown]').off('click.dropdown').on('click.dropdown',showDropdown);$('html').off('click.dropdown').on('click.dropdown',$.wDropdown.hideAll);$(window).off('resize.dropdown').on('resize.dropdown',$.wDropdown.hideAll);return true};$.wDropdown.hideAll=function(e,hideException){var el,hideExceptionID,targetGroup,trigger;if(e===null){e=null}if(hideException===null){hideException=null}targetGroup=e?$(e.target).parents().addBack():null;if(targetGroup&&targetGroup.hasClass('wojo dropdown menu')&&!targetGroup.is('A')){return}el='.wojo.dropdown.menu';trigger='[data-dropdown]';hideExceptionID='';if(hideException){hideExceptionID=$(hideException).attr('id');if(!$('[data-dropdown="#'+hideExceptionID+'"]').hasClass('open')){el='.wojo.dropdown.menu:not(#'+hideExceptionID+')';trigger='[data-dropdown!="#'+hideExceptionID+'"]'}}$('body').find(el).removeClass('active').end().find(trigger).removeClass('open');return true};$.wDropdown.ANCHOR_POSITIONS=['top-left','top-center','top-right','right-top','right-center','right-bottom','bottom-left','bottom-center','bottom-right','left-top','left-center','left-bottom'];$.wDropdown.defaults={anchorPosition:'center'};showDropdown=function(e){var $anchor,$dropdown,$trigger,$menu,addAnchorX,addAnchorY,addX,addY,anchorPosition,anchorSide,bottomTrigger,hasAnchor,heightDropdown,heightTrigger,i,isDisabled,isOpen,left,leftTrigger,len,position,positionParts,ref,rightTrigger,top,topTrigger,widthDropdown,widthTrigger;if(e===null){e=null}$trigger=$(this);$dropdown=$($trigger.data('dropdown'));$menu=$dropdown.children();$anchor=$dropdown.find('.pointer');hasAnchor=$dropdown.hasClass('pointing');isOpen=$trigger.hasClass('active');isDisabled=$trigger.hasClass('dropdown-disabled');widthDropdown=$dropdown.outerWidth();widthTrigger=$trigger.outerWidth();heightDropdown=$dropdown.outerHeight();heightTrigger=$trigger.outerHeight();topTrigger=$trigger.position().top;leftTrigger=$trigger.position().left;if($trigger.hasClass('dropdown-use-offset')){topTrigger=$trigger.offset().top;leftTrigger=$trigger.offset().left}bottomTrigger=topTrigger+heightTrigger;rightTrigger=leftTrigger+widthTrigger;if($dropdown.length<1){return console.log('[wDropdown] Could not find dropdown: '+$(this).data('dropdown'))}if($anchor.length<1&&hasAnchor){$anchor=$('<div class="pointer"></div>');$dropdown.prepend($anchor)}if(e!==void 0){e.preventDefault();e.stopPropagation()}if(isOpen||isDisabled){return false}$dropdown.on('click','a.item',function(){$dropdown.children('a.item').removeClass('selected');$(this).addClass('selected');if(typeof $(this).attr('data-value')!=="undefined"){$dropdown.find('input[type=hidden]').val($(this).attr('data-value'))}if(typeof $(this).attr('data-html')!=="undefined"){$trigger.find('.text').text($(this).attr('data-html'))}});$.wDropdown.hideAll(null,$trigger.data('dropdown'));anchorPosition=$.wDropdown.defaults.anchorPosition;ref=$.wDropdown.ANCHOR_POSITIONS;for(i=0,len=ref.length;i<len;i++){position=ref[i];if($dropdown.hasClass(position)){anchorPosition=position}}top=0;left=0;positionParts=anchorPosition.split('-');anchorSide=positionParts[0];anchorPosition=positionParts[1];if(anchorSide==='top'||anchorSide==='bottom'){switch(anchorPosition){case'left':left=leftTrigger;break;case'center':left=leftTrigger-widthDropdown/2+widthTrigger/2;break;case'right':left=rightTrigger-widthDropdown}}if(anchorSide==='left'||anchorSide==='right'){switch(anchorPosition){case'top':top=topTrigger;break;case'center':top=topTrigger-heightDropdown/2+heightTrigger/2;break;case'bottom':top=topTrigger+heightTrigger-heightDropdown}}switch(anchorSide){case'top':top=topTrigger+heightTrigger;break;case'right':left=leftTrigger-widthDropdown;break;case'bottom':top=topTrigger-heightDropdown;break;case'left':left=leftTrigger+widthTrigger}addX=parseInt($dropdown.data('add-x'));addY=parseInt($dropdown.data('add-y'));if(!isNaN(addX)){left+=addX}if(!isNaN(addY)){top+=addY}addAnchorX=parseInt($trigger.data('add-anchor-x'));addAnchorY=parseInt($trigger.data('add-anchor-y'));if(!isNaN(addAnchorX)){$anchor.css({marginLeft:addAnchorX})}if(!isNaN(addAnchorY)){$anchor.css({marginTop:addAnchorY})}$dropdown.css({top:top,left:left,display:'block',"minWidth": $trigger.outerWidth()});$dropdown.addClass('active');$trigger.addClass('open');return $trigger};return $(function(){return $.wDropdown.attachAll()})})(jQuery);
/*!
 * BeefUp v1.1.6 - A jQuery Accordion Plugin
 * Copyright 2016 Sascha Künstler https://github.com/Schascha/BeefUp
 */
(function($){'use strict';var accordion={};accordion.defaults={trigger:'.header',content:'.content',openClass:'active',animation:'slide',openSpeed:200,closeSpeed:200,scroll:false,scrollSpeed:400,scrollOffset:0,openSingle:false,stayOpen:null,selfClose:false,hash:true,breakpoints:null,onInit:function(){},onOpen:function(){},onClose:function(){},onScroll:function(){}};accordion.methods={getVars:function($el){var vars=$.extend(true,{},$el.data('accordion'),$el.data('accordion-options'));if(vars.breakpoints){vars=accordion.methods.getResponsiveVars(vars)}return vars},getResponsiveVars:function(vars){var windowWidth=window.innerWidth||$(window).width();vars.breakpoints.sort(function(a,b){return((a.breakpoint<b.breakpoint)?-1:((a.breakpoint>b.breakpoint)?1:0))});$.each(vars.breakpoints,function(index,value){if(windowWidth>value.breakpoint){vars=$.extend({},vars,value.settings)}});return vars},animation:function(type,$el,speed,callback){switch(type){case'slideDown':$el.slideDown(speed,callback);break;case'slideUp':$el.slideUp(speed,callback);break;case'fadeIn':$el.fadeIn(speed,callback);break;case'fadeOut':$el.fadeOut(speed,callback);break;case'show':$el.show(speed,callback);break;case'hide':$el.hide(speed,callback);break}},getStayOpen:function($obj,value){var $el;if(typeof value==='number'){$el=$obj.eq(value)}else if(typeof value==='string'){$el=$obj.filter(value)}return $el},selfClose:function($obj,vars){$(document).on('click',function(e){var $el;if(!$(e.target).closest($obj).length){$el=$obj.filter('.'+vars.openClass);if(vars.stayOpen!==null){$el=$el.not(accordion.methods.getStayOpen($obj,vars.stayOpen))}if($el.length){$obj.close($el)}}})},hash:function($obj,vars){var hashChange=function(){var $el=$obj.filter(window.location.hash);if($el.length&&!$el.hasClass(vars.openClass)){$obj.click($el)}};hashChange();$(window).on('hashchange',hashChange)}};$.fn.accordion=function(options){var $obj=this;this.open=function($el,callback){if(!$el||!$el.length){$el=$obj}$el.each(function(){var $this=$(this),vars=accordion.methods.getVars($this),$content=$this.find(vars.content+':first'),animation=(vars.animation==='slide')?'slideDown':(vars.animation==='fade')?'fadeIn':'show';accordion.methods.animation(animation,$content,vars.openSpeed,function(){$this.addClass(vars.openClass);$content.css('overflow','');if(callback&&typeof callback==='function'){callback()}if(vars.onOpen&&typeof vars.onOpen==='function'){vars.onOpen($this)}})});return $obj};this.close=function($el,callback){if(!$el||!$el.length){$el=$obj}$el.each(function(){var $this=$(this),vars=accordion.methods.getVars($this),$content=$this.find(vars.content+':first'),animation=(vars.animation==='slide')?'slideUp':(vars.animation==='fade')?'fadeOut':'hide';accordion.methods.animation(animation,$content,vars.closeSpeed,function(){$this.removeClass(vars.openClass);$content.css('overflow','');if(callback&&typeof callback==='function'){callback()}if(vars.onClose&&typeof vars.onClose==='function'){vars.onClose($this)}})});return $obj};this.scroll=function($el){var vars=accordion.methods.getVars($el);$('html, body').animate({scrollTop:$el.offset().top+vars.scrollOffset},vars.scrollSpeed).promise().done(function(){if(vars.onScroll&&typeof vars.onScroll==='function'){vars.onScroll($el)}});return $obj};this.click=function($el){var vars=accordion.methods.getVars($el);if(vars.openSingle){if(vars.stayOpen!==null){$obj.close($obj.not($el).not(accordion.methods.getStayOpen($obj,vars.stayOpen)))}else{$obj.close($obj.not($el))}}if(!$el.hasClass(vars.openClass)){$obj.open($el,function(){if(vars.scroll){$obj.scroll($el)}})}else{$obj.close($el)}return $obj};return this.each(function(index,el){var $el=$(el),vars=$.extend({},accordion.defaults,options,$el.data('accordion-options'));if($el.data('accordion')){return}$el.data('accordion',vars);if(vars.breakpoints){vars=accordion.methods.getResponsiveVars(vars)}if(vars.stayOpen!==null&&$el.is(accordion.methods.getStayOpen($obj,vars.stayOpen))){$el.addClass(vars.openClass)}$el.not('.'+vars.openClass).find(vars.content+':first').hide();if(vars.onInit&&typeof vars.onInit==='function'){vars.onInit($el)}$el.on('click',vars.trigger+':first',function(e){e.preventDefault();$obj.click($el)});if(index===0){if(vars.hash){accordion.methods.hash($obj,vars)}if(vars.selfClose){accordion.methods.selfClose($obj,vars)}}})}})(jQuery);
/*!
 * @Semantic UI 2.2.2 - Popup
 * http://github.com/semantic-org/semantic-ui/
 *
 */
!function(t,e,o,n){"use strict";e="undefined"!=typeof e&&e.Math==Math?e:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),t.fn.popup=function(i){var r,a=t(this),s=t(o),p=t(e),l=t("body"),u=a.selector||"",c=!0,d=(new Date).getTime(),f=[],g=arguments[0],h="string"==typeof g,m=[].slice.call(arguments,1);return a.each(function(){var a,v,b,w,y,T,C=t.isPlainObject(i)?t.extend(!0,{},t.fn.popup.settings,i):t.extend({},t.fn.popup.settings),P=C.selector,x=C.className,k=C.error,S=C.metadata,E=C.namespace,A="."+C.namespace,D="module-"+E,O=t(this),j=t(C.context),F=t(C.scrollContext),R=t(C.boundary),H=C.target?t(C.target):O,N=0,M=!1,W=!1,G=this,I=O.data(D);T={initialize:function(){T.debug("Initializing",O),T.createID(),T.bind.events(),!T.exists()&&C.preserve&&T.create(),T.observeChanges(),T.instantiate()},instantiate:function(){T.verbose("Storing instance",T),I=T,O.data(D,I)},observeChanges:function(){"MutationObserver"in e&&(b=new MutationObserver(T.event.documentChanged),b.observe(o,{childList:!0,subtree:!0}),T.debug("Setting up mutation observer",b))},refresh:function(){C.popup?a=t(C.popup).eq(0):C.inline&&(a=H.nextAll(P.popup).eq(0),C.popup=a),C.popup?(a.addClass(x.loading),v=T.get.offsetParent(),a.removeClass(x.loading),C.movePopup&&T.has.popup()&&T.get.offsetParent(a)[0]!==v[0]&&(T.debug("Moving popup to the same offset parent as activating element"),a.detach().appendTo(v))):v=C.inline?T.get.offsetParent(H):T.has.popup()?T.get.offsetParent(a):l,v.is("html")&&v[0]!==l[0]&&(T.debug("Setting page as offset parent"),v=l),T.get.variation()&&T.set.variation()},reposition:function(){T.refresh(),T.set.position()},destroy:function(){T.debug("Destroying previous module"),b&&b.disconnect(),a&&!C.preserve&&T.removePopup(),clearTimeout(T.hideTimer),clearTimeout(T.showTimer),T.unbind.close(),T.unbind.events(),O.removeData(D)},event:{start:function(e){var o=t.isPlainObject(C.delay)?C.delay.show:C.delay;clearTimeout(T.hideTimer),W||(T.showTimer=setTimeout(T.show,o))},end:function(){var e=t.isPlainObject(C.delay)?C.delay.hide:C.delay;clearTimeout(T.showTimer),T.hideTimer=setTimeout(T.hide,e)},touchstart:function(t){W=!0,T.show()},resize:function(){T.is.visible()&&T.set.position()},documentChanged:function(e){[].forEach.call(e,function(e){e.removedNodes&&[].forEach.call(e.removedNodes,function(e){(e==G||t(e).find(G).length>0)&&(T.debug("Element removed from DOM, tearing down events"),T.destroy())})})},hideGracefully:function(e){var n=t(e.target),i=t.contains(o.documentElement,e.target),r=n.closest(P.popup).length>0;e&&!r&&i?(T.debug("Click occurred outside popup hiding popup"),T.hide()):T.debug("Click was inside popup, keeping popup open")}},create:function(){var e=T.get.html(),o=T.get.title(),n=T.get.content();e||n||o?(T.debug("Creating pop-up html"),e||(e=C.templates.popup({title:o,content:n})),a=t("<div/>").addClass(x.popup).data(S.activator,O).html(e),C.inline?(T.verbose("Inserting popup element inline",a),a.insertAfter(O)):(T.verbose("Appending popup element to body",a),a.appendTo(j)),T.refresh(),T.set.variation(),C.hoverable&&T.bind.popup(),C.onCreate.call(a,G)):0!==H.next(P.popup).length?(T.verbose("Pre-existing popup found"),C.inline=!0,C.popup=H.next(P.popup).data(S.activator,O),T.refresh(),C.hoverable&&T.bind.popup()):C.popup?(t(C.popup).data(S.activator,O),T.verbose("Used popup specified in settings"),T.refresh(),C.hoverable&&T.bind.popup()):T.debug("No content specified skipping display",G)},createID:function(){y=(Math.random().toString(16)+"000000000").substr(2,8),w="."+y,T.verbose("Creating unique id for element",y)},toggle:function(){T.debug("Toggling pop-up"),T.is.hidden()?(T.debug("Popup is hidden, showing pop-up"),T.unbind.close(),T.show()):(T.debug("Popup is visible, hiding pop-up"),T.hide())},show:function(t){if(t=t||function(){},T.debug("Showing pop-up",C.transition),T.is.hidden()&&(!T.is.active()||!T.is.dropdown())){if(T.exists()||T.create(),C.onShow.call(a,G)===!1)return void T.debug("onShow callback returned false, cancelling popup animation");C.preserve||C.popup||T.refresh(),a&&T.set.position()&&(T.save.conditions(),C.exclusive&&T.hideAll(),T.animate.show(t))}},hide:function(t){if(t=t||function(){},T.is.visible()||T.is.animating()){if(C.onHide.call(a,G)===!1)return void T.debug("onHide callback returned false, cancelling popup animation");T.remove.visible(),T.unbind.close(),T.restore.conditions(),T.animate.hide(t)}},hideAll:function(){t(P.popup).filter("."+x.visible).each(function(){t(this).data(S.activator).popup("hide")})},exists:function(){return a?C.inline||C.popup?T.has.popup():a.closest(j).length>=1?!0:!1:!1},removePopup:function(){T.has.popup()&&!C.popup&&(T.debug("Removing popup",a),a.remove(),a=n,C.onRemove.call(a,G))},save:{conditions:function(){T.cache={title:O.attr("title")},T.cache.title&&O.removeAttr("title"),T.verbose("Saving original attributes",T.cache.title)}},restore:{conditions:function(){return T.cache&&T.cache.title&&(O.attr("title",T.cache.title),T.verbose("Restoring original attributes",T.cache.title)),!0}},supports:{svg:function(){return typeof SVGGraphicsElement===n}},animate:{show:function(e){e=t.isFunction(e)?e:function(){},C.transition&&t.fn.transition!==n&&O.transition("is supported")?(T.set.visible(),a.transition({animation:C.transition+" in",queue:!1,debug:C.debug,verbose:C.verbose,duration:C.duration,onComplete:function(){T.bind.close(),e.call(a,G),C.onVisible.call(a,G)}})):T.error(k.noTransition)},hide:function(e){return e=t.isFunction(e)?e:function(){},T.debug("Hiding pop-up"),C.onHide.call(a,G)===!1?void T.debug("onHide callback returned false, cancelling popup animation"):void(C.transition&&t.fn.transition!==n&&O.transition("is supported")?a.transition({animation:C.transition+" out",queue:!1,duration:C.duration,debug:C.debug,verbose:C.verbose,onComplete:function(){T.reset(),e.call(a,G),C.onHidden.call(a,G)}}):T.error(k.noTransition))}},change:{content:function(t){a.html(t)}},get:{html:function(){return O.removeData(S.html),O.data(S.html)||C.html},title:function(){return O.removeData(S.title),O.data(S.title)||C.title},content:function(){return O.removeData(S.content),O.data(S.content)||O.attr("title")||C.content},variation:function(){return O.removeData(S.variation),O.data(S.variation)||C.variation},popup:function(){return a},popupOffset:function(){return a.offset()},calculations:function(){var t,o=H[0],n=R[0]==e,i=C.inline||C.popup&&C.movePopup?H.position():H.offset(),r=n?{top:0,left:0}:R.offset(),s={},l=n?{top:p.scrollTop(),left:p.scrollLeft()}:{top:0,left:0};return s={target:{element:H[0],width:H.outerWidth(),height:H.outerHeight(),top:i.top,left:i.left,margin:{}},popup:{width:a.outerWidth(),height:a.outerHeight()},parent:{width:v.outerWidth(),height:v.outerHeight()},screen:{top:r.top,left:r.left,scroll:{top:l.top,left:l.left},width:R.width(),height:R.height()}},C.setFluidWidth&&T.is.fluid()&&(s.container={width:a.parent().outerWidth()},s.popup.width=s.container.width),s.target.margin.top=C.inline?parseInt(e.getComputedStyle(o).getPropertyValue("margin-top"),10):0,s.target.margin.left=C.inline?T.is.rtl()?parseInt(e.getComputedStyle(o).getPropertyValue("margin-right"),10):parseInt(e.getComputedStyle(o).getPropertyValue("margin-left"),10):0,t=s.screen,s.boundary={top:t.top+t.scroll.top,bottom:t.top+t.scroll.top+t.height,left:t.left+t.scroll.left,right:t.left+t.scroll.left+t.width},s},id:function(){return y},startEvent:function(){return"hover"==C.on?"mouseenter":"focus"==C.on?"focus":!1},scrollEvent:function(){return"scroll"},endEvent:function(){return"hover"==C.on?"mouseleave":"focus"==C.on?"blur":!1},distanceFromBoundary:function(t,e){var o,n,i={};return e=e||T.get.calculations(),o=e.popup,n=e.boundary,t&&(i={top:t.top-n.top,left:t.left-n.left,right:n.right-(t.left+o.width),bottom:n.bottom-(t.top+o.height)},T.verbose("Distance from boundaries determined",t,i)),i},offsetParent:function(e){var o=e!==n?e[0]:O[0],i=o.parentNode,r=t(i);if(i)for(var a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");i&&!p&&s&&a;)i=i.parentNode,r=t(i),a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");return r&&r.length>0?r:t()},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(t){var e=t.split(" "),o=e[0],n=e[1],i={top:"bottom",bottom:"top",left:"right",right:"left"},r={left:"center",center:"right",right:"left"},a={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"},s="top"==o||"bottom"==o,p=!1,l=!1,u=!1;return M||(T.verbose("All available positions available"),M=T.get.positions()),T.debug("Recording last position tried",t),M[t]=!0,"opposite"===C.prefer&&(u=[i[o],n],u=u.join(" "),p=M[u]===!0,T.debug("Trying opposite strategy",u)),"adjacent"===C.prefer&&s&&(u=[o,r[n]],u=u.join(" "),l=M[u]===!0,T.debug("Trying adjacent strategy",u)),(l||p)&&(T.debug("Using backup position",u),u=a[t]),u}},set:{position:function(t,e){if(0===H.length||0===a.length)return void T.error(k.notFound);var o,i,r,s,p,l,u,c;if(e=e||T.get.calculations(),t=t||O.data(S.position)||C.position,o=O.data(S.offset)||C.offset,i=C.distanceAway,r=e.target,s=e.popup,p=e.parent,0===r.width&&0===r.height&&!T.is.svg(r.element))return T.debug("Popup target is hidden, no action taken"),!1;switch(C.inline&&(T.debug("Adding margin to calculation",r.margin),"left center"==t||"right center"==t?(o+=r.margin.top,i+=-r.margin.left):"top left"==t||"top center"==t||"top right"==t?(o+=r.margin.left,i-=r.margin.top):(o+=r.margin.left,i+=r.margin.top)),T.debug("Determining popup position from calculations",t,e),T.is.rtl()&&(t=t.replace(/left|right/g,function(t){return"left"==t?"right":"left"}),T.debug("RTL: Popup position updated",t)),N==C.maxSearchDepth&&"string"==typeof C.lastResort&&(t=C.lastResort),t){case"top left":l={top:"auto",bottom:p.height-r.top+i,left:r.left+o,right:"auto"};break;case"top center":l={bottom:p.height-r.top+i,left:r.left+r.width/2-s.width/2+o,top:"auto",right:"auto"};break;case"top right":l={bottom:p.height-r.top+i,right:p.width-r.left-r.width-o,top:"auto",left:"auto"};break;case"left center":l={top:r.top+r.height/2-s.height/2+o,right:p.width-r.left+i,left:"auto",bottom:"auto"};break;case"right center":l={top:r.top+r.height/2-s.height/2+o,left:r.left+r.width+i,bottom:"auto",right:"auto"};break;case"bottom left":l={top:r.top+r.height+i,left:r.left+o,bottom:"auto",right:"auto"};break;case"bottom center":l={top:r.top+r.height+i,left:r.left+r.width/2-s.width/2+o,bottom:"auto",right:"auto"};break;case"bottom right":l={top:r.top+r.height+i,right:p.width-r.left-r.width-o,left:"auto",bottom:"auto"}}if(l===n&&T.error(k.invalidPosition,t),T.debug("Calculated popup positioning values",l),a.css(l).removeClass(x.position).addClass(t).addClass(x.loading),u=T.get.popupOffset(),c=T.get.distanceFromBoundary(u,e),T.is.offstage(c,t)){if(T.debug("Position is outside viewport",t),N<C.maxSearchDepth)return N++,t=T.get.nextPosition(t),T.debug("Trying new position",t),a?T.set.position(t,e):!1;if(!C.lastResort)return T.debug("Popup could not find a position to display",a),T.error(k.cannotPlace,G),T.remove.attempts(),T.remove.loading(),T.reset(),C.onUnplaceable.call(a,G),!1;T.debug("No position found, showing with last position")}return T.debug("Position is on stage",t),T.remove.attempts(),T.remove.loading(),C.setFluidWidth&&T.is.fluid()&&T.set.fluidWidth(e),!0},fluidWidth:function(t){t=t||T.get.calculations(),T.debug("Automatically setting element width to parent width",t.parent.width),a.css("width",t.container.width)},variation:function(t){t=t||T.get.variation(),t&&T.has.popup()&&(T.verbose("Adding variation to popup",t),a.addClass(t))},visible:function(){O.addClass(x.visible)}},remove:{loading:function(){a.removeClass(x.loading)},variation:function(t){t=t||T.get.variation(),t&&(T.verbose("Removing variation",t),a.removeClass(t))},visible:function(){O.removeClass(x.visible)},attempts:function(){T.verbose("Resetting all searched positions"),N=0,M=!1}},bind:{events:function(){T.debug("Binding popup events to module"),"click"==C.on&&O.on("click"+A,T.toggle),"hover"==C.on&&c&&O.on("touchstart"+A,T.event.touchstart),T.get.startEvent()&&O.on(T.get.startEvent()+A,T.event.start).on(T.get.endEvent()+A,T.event.end),C.target&&T.debug("Target set to element",H),p.on("resize"+w,T.event.resize)},popup:function(){T.verbose("Allowing hover events on popup to prevent closing"),a&&T.has.popup()&&a.on("mouseenter"+A,T.event.start).on("mouseleave"+A,T.event.end)},close:function(){(C.hideOnScroll===!0||"auto"==C.hideOnScroll&&"click"!=C.on)&&F.one(T.get.scrollEvent()+w,T.event.hideGracefully),"hover"==C.on&&W&&(T.verbose("Binding popup close event to document"),s.on("touchstart"+w,function(t){T.verbose("Touched away from popup"),T.event.hideGracefully.call(G,t)})),"click"==C.on&&C.closable&&(T.verbose("Binding popup close event to document"),s.on("click"+w,function(t){T.verbose("Clicked away from popup"),T.event.hideGracefully.call(G,t)}))}},unbind:{events:function(){p.off(w),O.off(A)},close:function(){s.off(w),F.off(w)}},has:{popup:function(){return a&&a.length>0}},is:{offstage:function(e,o){var n=[];return t.each(e,function(t,e){e<-C.jitter&&(T.debug("Position exceeds allowable distance from edge",t,e,o),n.push(t))}),n.length>0?!0:!1},svg:function(t){return T.supports.svg()&&t instanceof SVGGraphicsElement},active:function(){return O.hasClass(x.active)},animating:function(){return a!==n&&a.hasClass(x.animating)},fluid:function(){return a!==n&&a.hasClass(x.fluid)},visible:function(){return a!==n&&a.hasClass(x.visible)},dropdown:function(){return O.hasClass(x.dropdown)},hidden:function(){return!T.is.visible()},rtl:function(){return"rtl"==O.css("direction")}},reset:function(){T.remove.visible(),C.preserve?t.fn.transition!==n&&a.transition("remove transition"):T.removePopup()},setting:function(e,o){if(t.isPlainObject(e))t.extend(!0,C,e);else{if(o===n)return C[e];C[e]=o}},internal:function(e,o){if(t.isPlainObject(e))t.extend(!0,T,e);else{if(o===n)return T[e];T[e]=o}},debug:function(){!C.silent&&C.debug&&(C.performance?T.performance.log(arguments):(T.debug=Function.prototype.bind.call(console.info,console,C.name+":"),T.debug.apply(console,arguments)))},verbose:function(){!C.silent&&C.verbose&&C.debug&&(C.performance?T.performance.log(arguments):(T.verbose=Function.prototype.bind.call(console.info,console,C.name+":"),T.verbose.apply(console,arguments)))},error:function(){C.silent||(T.error=Function.prototype.bind.call(console.error,console,C.name+":"),T.error.apply(console,arguments))},performance:{log:function(t){var e,o,n;C.performance&&(e=(new Date).getTime(),n=d||e,o=e-n,d=e,f.push({Name:t[0],Arguments:[].slice.call(t,1)||"",Element:G,"Execution Time":o})),clearTimeout(T.performance.timer),T.performance.timer=setTimeout(T.performance.display,500)},display:function(){var e=C.name+":",o=0;d=!1,clearTimeout(T.performance.timer),t.each(f,function(t,e){o+=e["Execution Time"]}),e+=" "+o+"ms",u&&(e+=" '"+u+"'"),(console.group!==n||console.table!==n)&&f.length>0&&(console.groupCollapsed(e),console.table?console.table(f):t.each(f,function(t,e){console.log(e.Name+": "+e["Execution Time"]+"ms")}),console.groupEnd()),f=[]}},invoke:function(e,o,i){var a,s,p,l=I;return o=o||m,i=G||i,"string"==typeof e&&l!==n&&(e=e.split(/[\. ]/),a=e.length-1,t.each(e,function(o,i){var r=o!=a?i+e[o+1].charAt(0).toUpperCase()+e[o+1].slice(1):e;if(t.isPlainObject(l[r])&&o!=a)l=l[r];else{if(l[r]!==n)return s=l[r],!1;if(!t.isPlainObject(l[i])||o==a)return l[i]!==n?(s=l[i],!1):!1;l=l[i]}})),t.isFunction(s)?p=s.apply(i,o):s!==n&&(p=s),t.isArray(r)?r.push(p):r!==n?r=[r,p]:p!==n&&(r=p),s}},h?(I===n&&T.initialize(),T.invoke(g)):(I!==n&&I.invoke("destroy"),T.initialize())}),r!==n?r:this},t.fn.popup.settings={name:"Popup",silent:!1,debug:!1,verbose:!1,performance:!0,namespace:"popup",observeChanges:!0,onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onUnplaceable:function(){},onHidden:function(){},on:"hover",boundary:e,addTouchEvents:!0,position:"top left",variation:"",movePopup:!0,target:!1,popup:!1,inline:!1,preserve:!1,hoverable:!1,content:!1,html:!1,title:!1,closable:!0,hideOnScroll:"auto",exclusive:!1,context:"body",scrollContext:e,prefer:"opposite",lastResort:!1,delay:{show:50,hide:70},setFluidWidth:!0,duration:200,transition:"scale",distanceAway:0,jitter:2,offset:0,maxSearchDepth:15,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"Popup does not fit within the boundaries of the viewport",method:"The method you called is not defined.",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>",notFound:"The target or popup you specified does not exist on the page"},metadata:{activator:"activator",content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"wojo popup",position:"top left center bottom right",visible:"visible"},selector:{popup:".wojo.popup"},templates:{escape:function(t){var e=/[&<>"'`]/g,o=/[&<>"'`]/,n={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=function(t){return n[t]};return o.test(t)?t.replace(e,i):t},popup:function(e){var o="",i=t.fn.popup.settings.templates.escape;return typeof e!==n&&(typeof e.title!==n&&e.title&&(e.title=i(e.title),o+='<div class="header">'+e.title+"</div>"),typeof e.content!==n&&e.content&&(e.content=i(e.content),o+='<div class="content">'+e.content+"</div>")),o}}}}(jQuery,window,document);
/*
 * # Semantic UI 0.0.8 - Calendar
 * http://github.com/semantic-org/semantic-ui/
 */
(function($,bh,bi,bj){"use strict";bh=(typeof bh!='undefined'&&bh.Math==Math)?bh:(typeof self!='undefined'&&self.Math==Math)?self:Function('return this')();$.fn.calendar=function(ba){var bk=$(this),moduleSelector=bk.selector||'',time=new Date().getTime(),performance=[],query=arguments[0],methodInvoked=(typeof query=='string'),queryArguments=[].slice.call(arguments,1),returnedValue;bk.each(function(){var bl=($.isPlainObject(ba))?$.extend(true,{},$.fn.calendar.settings,ba):$.extend({},$.fn.calendar.settings),className=bl.className,namespace=bl.namespace,selector=bl.selector,formatter=bl.formatter,parser=bl.parser,metadata=bl.metadata,error=bl.error,eventNamespace='.'+namespace,moduleNamespace='module-'+namespace,$module=$(this),$input=$module.find(selector.input),$container=$module.find(selector.popup),$activator=$module.find(selector.activator),element=this,instance=$module.data(moduleNamespace),isTouch,isTouchDown=false,focusDateUsedForRange=false,module;module={initialize:function(){module.debug('Initializing calendar for',element);isTouch=module.get.isTouch();module.setup.popup();module.setup.inline();module.setup.input();module.setup.date();module.create.calendar();module.bind.events();module.instantiate()},instantiate:function(){module.verbose('Storing instance of calendar');instance=module;$module.data(moduleNamespace,instance)},destroy:function(){module.verbose('Destroying previous calendar for',element);$module.removeData(moduleNamespace);module.unbind.events()},setup:{popup:function(){if(bl.inline){return}if(!$activator.length){$activator=$module.children().first();if(!$activator.length){return}}if($.fn.popup===bj){module.error(error.popup);return}if(!$container.length){$container=$('<div/>').addClass(className.popup).prependTo($activator.parent())}$container.addClass(className.calendar);var a=bl.onVisible;var b=bl.onHidden;if(!$input.length){$container.attr('tabindex','0');a=function(){module.focus();return bl.onVisible.apply($container,arguments)};b=function(){module.blur();return bl.onHidden.apply($container,arguments)}}var c=function(){module.set.focusDate(module.get.date());module.set.mode(bl.startMode);return bl.onShow.apply($container,arguments)};var d=bl.on||($input.length?'focus':'click');var e=$.extend({},bl.popupOptions,{popup:$container,on:d,hoverable:d==='hover',onShow:c,onVisible:a,onHide:bl.onHide,onHidden:b});module.popup(e)},inline:function(){if($activator.length&&!bl.inline){return}$container=$('<div/>').addClass(className.calendar).appendTo($module);if(!$input.length){$container.attr('tabindex','0')}},input:function(){if(bl.touchReadonly&&$input.length&&isTouch){$input.prop('readonly',true)}},date:function(){if($input.length){var a=$input.val();var b=parser.date(a,bl);module.set.date(b,bl.formatInput,false)}}},create:{calendar:function(){var i,r,c,p,row,cell,pageGrid;var a=module.get.mode();var b=new Date();var d=module.get.date();var e=module.get.focusDate();var f=e||d||bl.initialDate||b;f=module.helper.dateInRange(f);if(!e){e=f;module.set.focusDate(e,false,false)}var g=a==='year';var h=a==='month';var j=a==='day';var k=a==='hour';var l=a==='minute';var m=bl.type==='time';var n=Math.max(bl.multiMonth,1);var o=!j?0:module.get.monthOffset();var q=f.getMinutes();var s=f.getHours();var t=f.getDate();var u=f.getMonth()+o;var v=f.getFullYear();var w=j?7:k?4:3;var x=w===7?'seven':w===4?'four':'three';var y=j||k?6:4;var z=j?n:1;var A=$container;A.empty();if(z>1){pageGrid=$('<div/>').addClass(className.grid).appendTo(A)}for(p=0;p<z;p++){if(z>1){var B=$('<div/>').addClass(className.column).appendTo(pageGrid);A=B}var C=u+p;var D=(new Date(v,C,1).getDay()-bl.firstDayOfWeek%7+7)%7;if(!bl.constantHeight&&j){var E=new Date(v,C+1,0).getDate()+D;y=Math.ceil(E/7)}var F=g?10:h?1:0;var G=j?1:0;var H=k||l?1:0;var I=k||l?t:1;var J=new Date(v-F,C-G,I-H,s);var K=new Date(v+F,C+G,I+H,s);var L=g?new Date(Math.ceil(v/10)*10-9,0,0):h?new Date(v,0,0):j?new Date(v,C,0):new Date(v,C,t,-1);var M=g?new Date(Math.ceil(v/10)*10+1,0,1):h?new Date(v+1,0,1):j?new Date(v,C+1,1):new Date(v,C,t+1);var N=$('<table/>').addClass(className.table).addClass(x+' column').addClass(a).appendTo(A);if(!m){var O=$('<thead/>').appendTo(N);row=$('<tr/>').appendTo(O);cell=$('<th/>').attr('colspan',''+w).appendTo(row);var P=g||h?new Date(v,0,1):j?new Date(v,C,1):new Date(v,C,t,s,q);var Q=$('<span/>').addClass(className.link).appendTo(cell);Q.text(formatter.header(P,a,bl));var R=h?(bl.disableYear?'day':'year'):j?(bl.disableMonth?'year':'month'):'day';Q.data(metadata.mode,R);if(p===0){var S=$('<span/>').addClass(className.prev).appendTo(cell);S.data(metadata.focusDate,J);S.toggleClass(className.disabledCell,!module.helper.isDateInRange(L,a));$('<i/>').addClass(className.prevIcon).appendTo(S)}if(p===z-1){var T=$('<span/>').addClass(className.next).appendTo(cell);T.data(metadata.focusDate,K);T.toggleClass(className.disabledCell,!module.helper.isDateInRange(M,a));$('<i/>').addClass(className.nextIcon).appendTo(T)}if(j){row=$('<tr/>').appendTo(O);for(i=0;i<w;i++){cell=$('<th/>').appendTo(row);cell.text(formatter.dayColumnHeader((i+bl.firstDayOfWeek)%7,bl))}}}var U=$('<tbody/>').appendTo(N);i=g?Math.ceil(v/10)*10-9:j?1-D:0;for(r=0;r<y;r++){row=$('<tr/>').appendTo(U);for(c=0;c<w;c++,i++){var V=g?new Date(i,C,1,s,q):h?new Date(v,i,1,s,q):j?new Date(v,C,i,s,q):k?new Date(v,C,t,i):new Date(v,C,t,s,i*5);var W=g?i:h?bl.text.monthsShort[i]:j?V.getDate():formatter.time(V,bl,true);cell=$('<td/>').addClass(className.cell).appendTo(row);cell.text(W);cell.data(metadata.date,V);var X=j&&V.getMonth()!==((C+12)%12);var Y=X||!module.helper.isDateInRange(V,a)||bl.isDisabled(V,a);var Z=module.helper.dateEqual(V,d,a);var bm=module.helper.dateEqual(V,b,a);cell.toggleClass(className.adjacentCell,X);cell.toggleClass(className.disabledCell,Y);cell.toggleClass(className.activeCell,Z&&!X);if(!k&&!l){cell.toggleClass(className.todayCell,!X&&bm)}var bn={mode:a,adjacent:X,disabled:Y,active:Z,today:bm};formatter.cell(cell,V,bn);if(module.helper.dateEqual(V,e,a)){module.set.focusDate(V,false,false)}}}if(bl.today){var bo=$('<tr/>').appendTo(U);var bp=$('<td/>').attr('colspan',''+w).addClass(className.today).appendTo(bo);bp.text(formatter.today(bl));bp.data(metadata.date,b)}module.update.focus(false,N)}}},update:{focus:function(h,i){i=i||$container;var j=module.get.mode();var k=module.get.date();var l=module.get.focusDate();var m=module.get.startDate();var n=module.get.endDate();var o=(h?l:null)||k||(!isTouch?l:null);i.find('td').each(function(){var a=$(this);var b=a.data(metadata.date);if(!b){return}var c=a.hasClass(className.disabledCell);var d=a.hasClass(className.activeCell);var e=a.hasClass(className.adjacentCell);var f=module.helper.dateEqual(b,l,j);var g=!o?false:((!!m&&module.helper.isDateInRange(b,j,m,o))||(!!n&&module.helper.isDateInRange(b,j,o,n)));a.toggleClass(className.focusCell,f&&(!isTouch||isTouchDown)&&!e);a.toggleClass(className.rangeCell,g&&!d&&!c)})}},refresh:function(){module.create.calendar()},bind:{events:function(){$container.on('mousedown'+eventNamespace,module.event.mousedown);$container.on('touchstart'+eventNamespace,module.event.mousedown);$container.on('mouseup'+eventNamespace,module.event.mouseup);$container.on('touchend'+eventNamespace,module.event.mouseup);$container.on('mouseover'+eventNamespace,module.event.mouseover);if($input.length){$input.on('input'+eventNamespace,module.event.inputChange);$input.on('focus'+eventNamespace,module.event.inputFocus);$input.on('blur'+eventNamespace,module.event.inputBlur);$input.on('click'+eventNamespace,module.event.inputClick);$input.on('keydown'+eventNamespace,module.event.keydown)}else{$container.on('keydown'+eventNamespace,module.event.keydown)}}},unbind:{events:function(){$container.off(eventNamespace);if($input.length){$input.off(eventNamespace)}}},event:{mouseover:function(a){var b=$(a.target);var c=b.data(metadata.date);var d=a.buttons===1;if(c){module.set.focusDate(c,false,true,d)}},mousedown:function(a){if($input.length){a.preventDefault()}isTouchDown=a.type.indexOf('touch')>=0;var b=$(a.target);var c=b.data(metadata.date);if(c){module.set.focusDate(c,false,true,true)}},mouseup:function(a){module.focus();a.preventDefault();a.stopPropagation();isTouchDown=false;var b=$(a.target);var c=b.parent();if(c.data(metadata.date)||c.data(metadata.focusDate)||c.data(metadata.mode)){b=c}var d=b.data(metadata.date);var e=b.data(metadata.focusDate);var f=b.data(metadata.mode);if(d){var g=b.hasClass(className.today);module.selectDate(d,g)}else if(e){module.set.focusDate(e)}else if(f){module.set.mode(f)}},keydown:function(a){if(a.keyCode===27||a.keyCode===9){module.popup('hide')}if(module.popup('is visible')){if(a.keyCode===37||a.keyCode===38||a.keyCode===39||a.keyCode===40){var b=module.get.mode();var c=b==='day'?7:b==='hour'?4:3;var d=a.keyCode===37?-1:a.keyCode===38?-c:a.keyCode==39?1:c;d*=b==='minute'?5:1;var e=module.get.focusDate()||module.get.date()||new Date();var f=e.getFullYear()+(b==='year'?d:0);var g=e.getMonth()+(b==='month'?d:0);var h=e.getDate()+(b==='day'?d:0);var i=e.getHours()+(b==='hour'?d:0);var j=e.getMinutes()+(b==='minute'?d:0);var k=new Date(f,g,h,i,j);if(bl.type==='time'){k=module.helper.mergeDateTime(e,k)}if(module.helper.isDateInRange(k,b)){module.set.focusDate(k)}}else if(a.keyCode===13){var b=module.get.mode();var l=module.get.focusDate();if(l&&!bl.isDisabled(l,b)){module.selectDate(l)}a.preventDefault();a.stopPropagation()}}if(a.keyCode===38||a.keyCode===40){a.preventDefault();module.popup('show')}},inputChange:function(){var a=$input.val();var b=parser.date(a,bl);module.set.date(b,false)},inputFocus:function(){$container.addClass(className.active)},inputBlur:function(){$container.removeClass(className.active);if(bl.formatInput){var a=module.get.date();var b=formatter.datetime(a,bl);$input.val(b)}},inputClick:function(){module.popup('show')}},get:{date:function(){return $module.data(metadata.date)||null},focusDate:function(){return $module.data(metadata.focusDate)||null},startDate:function(){var a=module.get.calendarModule(bl.startCalendar);return(a?a.get.date():$module.data(metadata.startDate))||null},endDate:function(){var a=module.get.calendarModule(bl.endCalendar);return(a?a.get.date():$module.data(metadata.endDate))||null},monthOffset:function(){return $module.data(metadata.monthOffset)||0},mode:function(){var a=$module.data(metadata.mode)||bl.startMode;var b=module.get.validModes();if($.inArray(a,b)>=0){return a}return bl.type==='time'?'hour':bl.type==='month'?'month':bl.type==='year'?'year':'day'},validModes:function(){var a=[];if(bl.type!=='time'){if(!bl.disableYear||bl.type==='year'){a.push('year')}if(!(bl.disableMonth||bl.type==='year')||bl.type==='month'){a.push('month')}if(bl.type.indexOf('date')>=0){a.push('day')}}if(bl.type.indexOf('time')>=0){a.push('hour');if(!bl.disableMinute){a.push('minute')}}return a},isTouch:function(){try{bi.createEvent('TouchEvent');return true}catch(e){return false}},calendarModule:function(a){if(!a){return null}if(!(a instanceof $)){a=$module.parent().children(a).first()}return a.data(moduleNamespace)}},set:{date:function(a,b,c){b=b!==false;c=c!==false;a=module.helper.sanitiseDate(a);a=module.helper.dateInRange(a);var e=module.get.mode();var f=formatter.datetime(a,bl);if(c&&bl.onChange.call(element,a,f,e)===false){return false}module.set.focusDate(a);if(bl.isDisabled(a,e)){return false}var g=module.get.endDate();if(!!g&&!!a&&a>g){module.set.endDate(bj)}module.set.dataKeyValue(metadata.date,a);if(b&&$input.length){$input.val(f);var h=$input.prop('name');var d=new Date(a);var i=d.getFullYear()+'-'+('0'+(d.getMonth()+1)).slice(-2)+'-'+('0'+d.getDate()).slice(-2)+" "+("0"+d.getHours()).slice(-2)+":"+("0"+d.getMinutes()).slice(-2);if(!$('input[name="'+h+'_submit"]').length){$('<input>',{type:"hidden",name:h+'_submit',value:i,}).insertAfter($input)}else{$('input[name="'+h+'_submit"]').val(i)}}},startDate:function(a,b){a=module.helper.sanitiseDate(a);var c=module.get.calendarModule(bl.startCalendar);if(c){c.set.date(a)}module.set.dataKeyValue(metadata.startDate,a,b)},endDate:function(a,b){a=module.helper.sanitiseDate(a);var c=module.get.calendarModule(bl.endCalendar);if(c){c.set.date(a)}module.set.dataKeyValue(metadata.endDate,a,b)},focusDate:function(a,b,c,d){a=module.helper.sanitiseDate(a);a=module.helper.dateInRange(a);var e=module.get.mode()==='day';var f=module.get.focusDate();if(e&&a&&f){var g=a.getFullYear()-f.getFullYear();var h=g*12+a.getMonth()-f.getMonth();if(h){var i=module.get.monthOffset()-h;module.set.monthOffset(i,false)}}var j=module.set.dataKeyValue(metadata.focusDate,a,b);c=(c!==false&&j&&b===false)||focusDateUsedForRange!=d;focusDateUsedForRange=d;if(c){module.update.focus(d)}},monthOffset:function(a,b){var c=Math.max(bl.multiMonth,1);a=Math.max(1-c,Math.min(0,a));module.set.dataKeyValue(metadata.monthOffset,a,b)},mode:function(a,b){module.set.dataKeyValue(metadata.mode,a,b)},dataKeyValue:function(a,b,c){var d=$module.data(a);var e=d===b||(d<=b&&d>=b);if(b){$module.data(a,b)}else{$module.removeData(a)}c=c!==false&&!e;if(c){module.create.calendar()}return!e}},selectDate:function(a,b){var c=module.get.mode();var d=b||c==='minute'||(bl.disableMinute&&c==='hour')||(bl.type==='date'&&c==='day')||(bl.type==='month'&&c==='month')||(bl.type==='year'&&c==='year');if(d){var e=module.set.date(a)===false;if(!e&&bl.closable){module.popup('hide');var f=module.get.calendarModule(bl.endCalendar);if(f){f.popup('show');f.focus()}}}else{var g=c==='year'?(!bl.disableMonth?'month':'day'):c==='month'?'day':c==='day'?'hour':'minute';module.set.mode(g);if(c==='hour'||(c==='day'&&module.get.date())){module.set.date(a)}else{module.set.focusDate(a)}}},changeDate:function(a){module.set.date(a)},clear:function(){module.set.date(bj)},popup:function(){return $activator.popup.apply($activator,arguments)},focus:function(){if($input.length){$input.focus()}else{$container.focus()}},blur:function(){if($input.length){$input.blur()}else{$container.blur()}},helper:{sanitiseDate:function(a){if(!a){return bj}if(!(a instanceof Date)){a=parser.date(''+a,bl)}if(isNaN(a.getTime())){return bj}return a},dateDiff:function(a,b,c){c=c||'day';var d=bl.type==='time';var e=c==='year';var f=e||c==='month';var g=c==='minute';var h=g||c==='hour';a=new Date(d?2000:a.getFullYear(),d?0:e?0:a.getMonth(),d?1:f?1:a.getDate(),!h?0:a.getHours(),!g?0:5*Math.floor(a.getMinutes()/5));b=new Date(d?2000:b.getFullYear(),d?0:e?0:b.getMonth(),d?1:f?1:b.getDate(),!h?0:b.getHours(),!g?0:5*Math.floor(b.getMinutes()/5));return b.getTime()-a.getTime()},dateEqual:function(a,b,c){return!!a&&!!b&&module.helper.dateDiff(a,b,c)===0},isDateInRange:function(a,b,c,d){if(!c&&!d){var e=module.get.startDate();c=e&&bl.minDate?new Date(Math.max(e,bl.minDate)):e||bl.minDate;d=bl.maxDate}c=c&&new Date(c.getFullYear(),c.getMonth(),c.getDate(),c.getHours(),5*Math.ceil(c.getMinutes()/5));return!(!a||(c&&module.helper.dateDiff(a,c,b)>0)||(d&&module.helper.dateDiff(d,a,b)>0))},dateInRange:function(a,b,c){if(!b&&!c){var d=module.get.startDate();b=d&&bl.minDate?new Date(Math.max(d,bl.minDate)):d||bl.minDate;c=bl.maxDate}b=b&&new Date(b.getFullYear(),b.getMonth(),b.getDate(),b.getHours(),5*Math.ceil(b.getMinutes()/5));var e=bl.type==='time';return!a?a:(b&&module.helper.dateDiff(a,b,'minute')>0)?(e?module.helper.mergeDateTime(a,b):b):(c&&module.helper.dateDiff(c,a,'minute')>0)?(e?module.helper.mergeDateTime(a,c):c):a},mergeDateTime:function(a,b){return(!a||!b)?b:new Date(a.getFullYear(),a.getMonth(),a.getDate(),b.getHours(),b.getMinutes())}},setting:function(a,b){module.debug('Changing setting',a,b);if($.isPlainObject(a)){$.extend(true,bl,a)}else if(b!==bj){if($.isPlainObject(bl[a])){$.extend(true,bl[a],b)}else{bl[a]=b}}else{return bl[a]}},internal:function(a,b){module.debug('Changing internal',a,b);if(b!==bj){if($.isPlainObject(a)){$.extend(true,module,a)}else{module[a]=b}}else{return module[a]}},debug:function(){if(!bl.silent&&bl.debug){if(bl.performance){module.performance.log(arguments)}else{module.debug=Function.prototype.bind.call(console.info,console,bl.name+':');module.debug.apply(console,arguments)}}},verbose:function(){if(!bl.silent&&bl.verbose&&bl.debug){if(bl.performance){module.performance.log(arguments)}else{module.verbose=Function.prototype.bind.call(console.info,console,bl.name+':');module.verbose.apply(console,arguments)}}},error:function(){if(!bl.silent){module.error=Function.prototype.bind.call(console.error,console,bl.name+':');module.error.apply(console,arguments)}},performance:{log:function(a){var b,executionTime,previousTime;if(bl.performance){b=new Date().getTime();previousTime=time||b;executionTime=b-previousTime;time=b;performance.push({'Name':a[0],'Arguments':[].slice.call(a,1)||'','Element':element,'Execution Time':executionTime})}clearTimeout(module.performance.timer);module.performance.timer=setTimeout(module.performance.display,500)},display:function(){var c=bl.name+':',totalTime=0;time=false;clearTimeout(module.performance.timer);$.each(performance,function(a,b){totalTime+=b['Execution Time']});c+=' '+totalTime+'ms';if(moduleSelector){c+=' \''+moduleSelector+'\''}if((console.group!==bj||console.table!==bj)&&performance.length>0){console.groupCollapsed(c);if(console.table){console.table(performance)}else{$.each(performance,function(a,b){console.log(b['Name']+': '+b['Execution Time']+'ms')})}console.groupEnd()}performance=[]}},invoke:function(d,e,f){var g=instance,maxDepth,found,response;e=e||queryArguments;f=element||f;if(typeof d=='string'&&g!==bj){d=d.split(/[\. ]/);maxDepth=d.length-1;$.each(d,function(a,b){var c=(a!=maxDepth)?b+d[a+1].charAt(0).toUpperCase()+d[a+1].slice(1):d;if($.isPlainObject(g[c])&&(a!=maxDepth)){g=g[c]}else if(g[c]!==bj){found=g[c];return false}else if($.isPlainObject(g[b])&&(a!=maxDepth)){g=g[b]}else if(g[b]!==bj){found=g[b];return false}else{module.error(error.method,d);return false}})}if($.isFunction(found)){response=found.apply(f,e)}else if(found!==bj){response=found}if($.isArray(returnedValue)){returnedValue.push(response)}else if(returnedValue!==bj){returnedValue=[returnedValue,response]}else if(response!==bj){returnedValue=response}return found}};if(methodInvoked){if(instance===bj){module.initialize()}module.invoke(query)}else{if(instance!==bj){instance.invoke('destroy')}module.initialize()}});return(returnedValue!==bj)?returnedValue:this};$.fn.calendar.settings={name:'Calendar',namespace:'calendar',silent:false,debug:false,verbose:false,performance:false,type:'datetime',firstDayOfWeek:0,constantHeight:true,today:false,closable:true,monthFirst:true,touchReadonly:true,inline:false,on:null,initialDate:null,startMode:false,minDate:null,maxDate:null,ampm:true,disableYear:false,disableMonth:false,disableMinute:false,formatInput:true,startCalendar:null,endCalendar:null,multiMonth:1,popupOptions:{position:'bottom left',lastResort:'bottom left',prefer:'opposite',hideOnScroll:false},text:{days:['S','M','T','W','T','F','S'],months:['January','February','March','April','May','June','July','August','September','October','November','December'],monthsShort:['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],today:'Today',now:'Now',am:'AM',pm:'PM'},formatter:{header:function(a,b,c){return b==='year'?c.formatter.yearHeader(a,c):b==='month'?c.formatter.monthHeader(a,c):b==='day'?c.formatter.dayHeader(a,c):b==='hour'?c.formatter.hourHeader(a,c):c.formatter.minuteHeader(a,c)},yearHeader:function(a,b){var c=Math.ceil(a.getFullYear()/10)*10;return(c-9)+' - '+(c+2)},monthHeader:function(a,b){return a.getFullYear()},dayHeader:function(a,b){var c=b.text.months[a.getMonth()];var d=a.getFullYear();return c+' '+d},hourHeader:function(a,b){return b.formatter.date(a,b)},minuteHeader:function(a,b){return b.formatter.date(a,b)},dayColumnHeader:function(a,b){return b.text.days[a]},datetime:function(a,b){if(!a){return''}var c=b.type==='time'?'':b.formatter.date(a,b);var d=b.type.indexOf('time')<0?'':b.formatter.time(a,b,false);var e=b.type==='datetime'?' ':'';return c+e+d},date:function(a,b){if(!a){return''}var c=a.getDate();var d=b.text.months[a.getMonth()];var e=a.getFullYear();return b.type==='year'?e:b.type==='month'?d+' '+e:(b.monthFirst?d+' '+c:c+' '+d)+', '+e},time:function(a,b,c){if(!a){return''}var d=a.getHours();var e=a.getMinutes();var f='';if(b.ampm){f=' '+(d<12?b.text.am:b.text.pm);d=d===0?12:d>12?d-12:d}return d+':'+(e<10?'0':'')+e+f},today:function(a){return a.type==='date'?a.text.today:a.text.now},cell:function(a,b,c){}},parser:{date:function(a,b){if(!a){return null}a=(''+a).trim().toLowerCase();if(a.length===0){return null}var i,j,k;var c=-1,hour=-1,day=-1,month=-1,year=-1;var d=bj;var e=b.type==='time';var f=b.type.indexOf('time')<0;var g=a.split(b.regExp.dateWords);var h=a.split(b.regExp.dateNumbers);if(!f){d=$.inArray(b.text.am.toLowerCase(),g)>=0?true:$.inArray(b.text.pm.toLowerCase(),g)>=0?false:bj;for(i=0;i<h.length;i++){var l=h[i];if(l.indexOf(':')>=0){if(hour<0||c<0){var m=l.split(':');for(k=0;k<Math.min(2,m.length);k++){j=parseInt(m[k]);if(isNaN(j)){j=0}if(k===0){hour=j%24}else{c=j%60}}}h.splice(i,1)}}}if(!e){for(i=0;i<g.length;i++){var n=g[i];if(n.length<=0){continue}n=n.substring(0,Math.min(n.length,3));for(j=0;j<b.text.months.length;j++){var o=b.text.months[j];o=o.substring(0,Math.min(n.length,Math.min(o.length,3))).toLowerCase();if(o===n){month=j+1;break}}if(month>=0){break}}for(i=0;i<h.length;i++){j=parseInt(h[i]);if(isNaN(j)){continue}if(j>59){year=j;h.splice(i,1);break}}if(month<0){for(i=0;i<h.length;i++){k=i>1||b.monthFirst?i:i===1?0:1;j=parseInt(h[k]);if(isNaN(j)){continue}if(1<=j&&j<=12){month=j;h.splice(k,1);break}}}for(i=0;i<h.length;i++){j=parseInt(h[i]);if(isNaN(j)){continue}if(1<=j&&j<=31){day=j;h.splice(i,1);break}}if(year<0){for(i=h.length-1;i>=0;i--){j=parseInt(h[i]);if(isNaN(j)){continue}if(j<99){j+=2000}year=j;h.splice(i,1);break}}}if(!f){if(hour<0){for(i=0;i<h.length;i++){j=parseInt(h[i]);if(isNaN(j)){continue}if(0<=j&&j<=23){hour=j;h.splice(i,1);break}}}if(c<0){for(i=0;i<h.length;i++){j=parseInt(h[i]);if(isNaN(j)){continue}if(0<=j&&j<=59){c=j;h.splice(i,1);break}}}}if(c<0&&hour<0&&day<0&&month<0&&year<0){return null}if(c<0){c=0}if(hour<0){hour=0}if(day<0){day=1}if(month<0){month=1}if(year<0){year=new Date().getFullYear()}if(d!==bj){if(d){if(hour===12){hour=0}}else if(hour<12){hour+=12}}var p=new Date(year,month-1,day,hour,c);if(p.getMonth()!==month-1||p.getFullYear()!==year){p=new Date(year,month,0,hour,c)}return isNaN(p.getTime())?null:p}},onChange:function(a,b,c){return true},onShow:function(){},onVisible:function(){},onHide:function(){},onHidden:function(){},isDisabled:function(a,b){return false},selector:{popup:'.wojo.popup',input:'input',activator:'input'},regExp:{dateWords:/[^A-Za-z\u00C0-\u024F]+/g,dateNumbers:/[^\d:]+/g},error:{popup:'UI Popup, a required component is not included in this page',method:'The method you called is not defined.'},className:{calendar:'calendar',active:'active',popup:'wojo popup',grid:'wojo equal width grid',column:'column',table:'wojo celled center aligned unstackable table',prev:'prev link',next:'next link',prevIcon:'chevron left icon',nextIcon:'chevron right icon',link:'link',cell:'link',disabledCell:'disabled',adjacentCell:'adjacent',activeCell:'active',rangeCell:'range',focusCell:'focus',todayCell:'today',today:'today link'},metadata:{date:'date',focusDate:'focusDate',startDate:'startDate',endDate:'endDate',mode:'mode',monthOffset:'monthOffset'}}})(jQuery,window,document);
/*!
 * # Semantic UI 2.1.7 - Progress
 * http://github.com/semantic-org/semantic-ui/
 *
 */
!function(e,t,n,r){"use strict";e.fn.progress=function(t){var a,o=e(this),s=o.selector||"",i=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,g=[].slice.call(arguments,1);return o.each(function(){var o,v,p=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),d=p.className,m=p.metadata,b=p.namespace,f=p.selector,h=p.error,w="."+b,x="module-"+b,y=e(this),C=e(this).find(f.bar),T=e(this).find(f.progress),E=e(this).find(f.label),A=this,S=y.data(x),V=!1;v={initialize:function(){v.debug("Initializing progress bar",p),v.set.duration(),v.set.transitionEvent(),v.read.metadata(),v.read.settings(),v.instantiate()},instantiate:function(){v.verbose("Storing instance of progress",v),S=v,y.data(x,v)},destroy:function(){v.verbose("Destroying previous progress for",y),clearInterval(S.interval),v.remove.state(),y.removeData(x),S=r},reset:function(){v.set.percent(0),v.set.value(0)},complete:function(){(v.percent===r||v.percent<100)&&v.set.percent(100)},read:{metadata:function(){var e={percent:y.data(m.percent),total:y.data(m.total),value:y.data(m.value)};e.percent&&(v.debug("Current percent value set from metadata",e.percent),v.set.percent(e.percent)),e.total&&(v.debug("Total value set from metadata",e.total),v.set.total(e.total)),e.value&&(v.debug("Current value set from metadata",e.value),v.set.value(e.value),v.set.progress(e.value))},settings:function(){p.total!==!1&&(v.debug("Current total set in settings",p.total),v.set.total(p.total)),p.value!==!1&&(v.debug("Current value set in settings",p.value),v.set.value(p.value),v.set.progress(v.value)),p.percent!==!1&&(v.debug("Current percent set in settings",p.percent),v.set.percent(p.percent))}},increment:function(e){var t,n,r;v.has.total()?(n=v.get.value(),e=e||1,r=n+e,t=v.get.total(),v.debug("Incrementing value",n,r,t),r>t&&(v.debug("Value cannot increment above total",t),r=t)):(n=v.get.percent(),e=e||v.get.randomValue(),r=n+e,t=100,v.debug("Incrementing percentage by",n,r),r>t&&(v.debug("Value cannot increment above 100 percent"),r=t)),v.set.progress(r)},decrement:function(e){var t,n,r=v.get.total();r?(t=v.get.value(),e=e||1,n=t-e,v.debug("Decrementing value by",e,t)):(t=v.get.percent(),e=e||v.get.randomValue(),n=t-e,v.debug("Decrementing percentage by",e,t)),0>n&&(v.debug("Value cannot decrement below 0"),n=0),v.set.progress(n)},has:{total:function(){return v.get.total()!==!1}},get:{text:function(e){var t=v.value||0,n=v.total||0,r=V?v.get.displayPercent():v.percent||0,a=v.total>0?n-t:100-r;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{left}",a).replace("{percent}",r),v.debug("Adding variables to progress bar text",e),e},randomValue:function(){return v.debug("Generating random increment percentage"),Math.floor(Math.random()*p.random.max+p.random.min)},numericValue:function(e){return"string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e},transitionEnd:function(){var e,t=n.createElement("element"),a={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in a)if(t.style[e]!==r)return a[e]},displayPercent:function(){var e=C.width(),t=y.width(),n=parseInt(C.css("min-width"),10),r=e>n?e/t*100:v.percent;return p.precision>0?Math.round(r*(10*p.precision))/(10*p.precision):Math.round(r)},percent:function(){return v.percent||0},value:function(){return v.value||0},total:function(){return v.total||!1}},is:{success:function(){return y.hasClass(d.success)},warning:function(){return y.hasClass(d.warning)},error:function(){return y.hasClass(d.error)},active:function(){return y.hasClass(d.active)},visible:function(){return y.is(":visible")}},remove:{state:function(){v.verbose("Removing stored state"),delete v.total,delete v.percent,delete v.value},active:function(){v.verbose("Removing active state"),y.removeClass(d.active)},success:function(){v.verbose("Removing success state"),y.removeClass(d.success)},warning:function(){v.verbose("Removing warning state"),y.removeClass(d.warning)},error:function(){v.verbose("Removing error state"),y.removeClass(d.error)}},set:{barWidth:function(e){e>100?v.error(h.tooHigh,e):0>e?v.error(h.tooLow,e):(C.css("width",e+"%"),y.attr("data-percent",parseInt(e,10)))},duration:function(e){e=e||p.duration,e="number"==typeof e?e+"ms":e,v.verbose("Setting progress bar transition duration",e),C.css({"transition-duration":e})},percent:function(e){e="string"==typeof e?+e.replace("%",""):e,e=p.precision>0?Math.round(e*(10*p.precision))/(10*p.precision):Math.round(e),v.percent=e,v.has.total()||(v.value=p.precision>0?Math.round(e/100*v.total*(10*p.precision))/(10*p.precision):Math.round(e/100*v.total*10)/10,p.limitValues&&(v.value=v.value>100?100:v.value<0?0:v.value)),v.set.barWidth(e),v.set.labelInterval(),v.set.labels(),p.onChange.call(A,e,v.value,v.total)},labelInterval:function(){var e=function(){v.verbose("Bar finished animating, removing continuous label updates"),clearInterval(v.interval),V=!1,v.set.labels()};clearInterval(v.interval),C.one(o+w,e),v.timer=setTimeout(e,p.duration+100),V=!0,v.interval=setInterval(v.set.labels,p.framerate)},labels:function(){v.verbose("Setting both bar progress and outer label text"),v.set.barLabel(),v.set.state()},label:function(e){e=e||"",e&&(e=v.get.text(e),v.debug("Setting label to text",e),E.text(e))},state:function(e){e=e!==r?e:v.percent,100===e?!p.autoSuccess||v.is.warning()||v.is.error()?(v.verbose("Reached 100% removing active state"),v.remove.active()):(v.set.success(),v.debug("Automatically triggering success at 100%")):e>0?(v.verbose("Adjusting active progress bar label",e),v.set.active()):(v.remove.active(),v.set.label(p.text.active))},barLabel:function(e){e!==r?T.text(v.get.text(e)):"ratio"==p.label&&v.total?(v.debug("Adding ratio to bar label"),T.text(v.get.text(p.text.ratio))):"percent"==p.label&&(v.debug("Adding percentage to bar label"),T.text(v.get.text(p.text.percent)))},active:function(e){e=e||p.text.active,v.debug("Setting active state"),p.showActivity&&!v.is.active()&&y.addClass(d.active),v.remove.warning(),v.remove.error(),v.remove.success(),e&&v.set.label(e),p.onActive.call(A,v.value,v.total)},success:function(e){e=e||p.text.success,v.debug("Setting success state"),y.addClass(d.success),v.remove.active(),v.remove.warning(),v.remove.error(),v.complete(),e&&v.set.label(e),p.onSuccess.call(A,v.total)},warning:function(e){e=e||p.text.warning,v.debug("Setting warning state"),y.addClass(d.warning),v.remove.active(),v.remove.success(),v.remove.error(),v.complete(),e&&v.set.label(e),p.onWarning.call(A,v.value,v.total)},error:function(e){e=e||p.text.error,v.debug("Setting error state"),y.addClass(d.error),v.remove.active(),v.remove.success(),v.remove.warning(),v.complete(),e&&v.set.label(e),p.onError.call(A,v.value,v.total)},transitionEvent:function(){o=v.get.transitionEnd()},total:function(e){v.total=e},value:function(e){v.value=e},progress:function(e){var t,n=v.get.numericValue(e);n===!1&&v.error(h.nonNumeric,e),v.has.total()?(v.set.value(n),t=n/v.total*100,v.debug("Calculating percent complete from total",t),v.set.percent(t)):(t=n,v.debug("Setting value to exact percentage value",t),v.set.percent(t))}},setting:function(t,n){if(v.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,p,t);else{if(n===r)return p[t];p[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,v,t);else{if(n===r)return v[t];v[t]=n}},debug:function(){p.debug&&(p.performance?v.performance.log(arguments):(v.debug=Function.prototype.bind.call(console.info,console,p.name+":"),v.debug.apply(console,arguments)))},verbose:function(){p.verbose&&p.debug&&(p.performance?v.performance.log(arguments):(v.verbose=Function.prototype.bind.call(console.info,console,p.name+":"),v.verbose.apply(console,arguments)))},error:function(){v.error=Function.prototype.bind.call(console.error,console,p.name+":"),v.error.apply(console,arguments)},performance:{log:function(e){var t,n,r;p.performance&&(t=(new Date).getTime(),r=i||t,n=t-r,i=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:A,"Execution Time":n})),clearTimeout(v.performance.timer),v.performance.timer=setTimeout(v.performance.display,500)},display:function(){var t=p.name+":",n=0;i=!1,clearTimeout(v.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",s&&(t+=" '"+s+"'"),(console.group!==r||console.table!==r)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,o){var s,i,c,l=S;return n=n||g,o=A||o,"string"==typeof t&&l!==r&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var o=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[o])&&n!=s)l=l[o];else{if(l[o]!==r)return i=l[o],!1;if(!e.isPlainObject(l[a])||n==s)return l[a]!==r?(i=l[a],!1):(v.error(h.method,t),!1);l=l[a]}})),e.isFunction(i)?c=i.apply(o,n):i!==r&&(c=i),e.isArray(a)?a.push(c):a!==r?a=[a,c]:c!==r&&(a=c),i}},u?(S===r&&v.initialize(),v.invoke(l)):(S!==r&&S.invoke("destroy"),v.initialize())}),a!==r?a:this},e.fn.progress.settings={name:"Progress",namespace:"progress",debug:!1,verbose:!1,performance:!0,random:{min:2,max:5},duration:300,autoSuccess:!0,showActivity:!0,limitValues:!0,label:"percent",precision:0,framerate:1e3/30,percent:!1,total:!1,value:!1,onChange:function(e,t,n){},onSuccess:function(e){},onActive:function(e,t){},onError:function(e,t){},onWarning:function(e,t){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric",tooHigh:"Value specified is above 100%",tooLow:"Value specified is below 0%"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);
/* Cookie Plugin 
* @author Klaus Hartl/klaus.hartl@stilbuero.de
*/
!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof exports?module.exports=e(require("jquery")):e(jQuery)}(function(e){function n(e){return u.raw?e:encodeURIComponent(e)}function o(e){return u.raw?e:decodeURIComponent(e)}function i(e){return n(u.json?JSON.stringify(e):String(e))}function t(e){0===e.indexOf('"')&&(e=e.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\"));try{return e=decodeURIComponent(e.replace(c," ")),u.json?JSON.parse(e):e}catch(n){}}function r(n,o){var i=u.raw?n:t(n);return e.isFunction(o)?o(i):i}var c=/\+/g,u=e.cookie=function(t,c,s){if(arguments.length>1&&!e.isFunction(c)){if(s=e.extend({},u.defaults,s),"number"==typeof s.expires){var a=s.expires,d=s.expires=new Date;d.setMilliseconds(d.getMilliseconds()+864e5*a)}return document.cookie=[n(t),"=",i(c),s.expires?"; expires="+s.expires.toUTCString():"",s.path?"; path="+s.path:"",s.domain?"; domain="+s.domain:"",s.secure?"; secure":""].join("")}for(var f=t?void 0:{},p=document.cookie?document.cookie.split("; "):[],l=0,m=p.length;m>l;l++){var x=p[l].split("="),g=o(x.shift()),j=x.join("=");if(t===g){f=r(j,c);break}t||void 0===(j=r(j))||(f[g]=j)}return f};u.defaults={},e.removeCookie=function(n,o){return e.cookie(n,"",e.extend({},o,{expires:-1})),!e.cookie(n)}});
/**
 * EU Cookie Notice
 */
jQuery.fn.extend({acceptCookies:function(options){var defaults={position:"top",textcolour:"#FFF",notice:"We use cookies to track visits to our website.",accept:"ACCEPT COOKIES",decline:"DECLINE COOKIES",whatc:"What are cookies?",decline_t:"In doing so this website may function incorrectly. Do you wish to proceed?",fontfamily:"Helvetica, Arial, sans-serif"};var options=$.extend(defaults,options);return this.each(function(){var o=options;if($.cookie("CDP_EU_COOKIE")!=null){return $()}else{if($.cookie("CDP_EU_COOKIE")!=null){return setInterval(function(){$().deleteAllCookies()},1000)}}$("body").append('<div id="accept_cookies"><div class="euinner">'+o.notice+' <span><a href="http://www.allaboutcookies.org/" target="_blank">'+o.whatc+'</a></span><div><button id="ac_accept">'+o.accept+'</button><button id="ac_decline">'+o.decline+"</button></div></div></div>");$("#accept_cookies").css({"background-color":"#000","z-index":999999,opacity:0.85,position:"fixed",padding:"0px",width:"100%","text-align":"center",left:0,color:o.textcolour,"font-family":o.fontfamily,});$(".euinner").css({padding:"50px",width:"70%",margin:"0 auto"});if(o.position=="top"){$("#accept_cookies").css("top",0)}else{$("#accept_cookies").css("bottom",0)}$("#accept_cookies span").css({display:"block","font-size":"90%",margin:"10px 0"});$("#accept_cookies a").css({"text-decoration":"underline",color:"#FFF"});$("#accept_cookies button").css({"background-color":"#7DAF3B",border:0,color:"#FFF",padding:"16px","font-weight":"bold",cursor:"pointer",margin:"0 16px"});$("#accept_cookies button#ac_decline").css({"background-color":"#fd1046",}).click(function(e){e.preventDefault();var conf=confirm(o.decline_t);if(conf){setInterval(function(){$().deleteAllCookies()},1000);window.location.href="http://google.com"}});$("#accept_cookies button#ac_accept").click(function(e){e.preventDefault();$.cookie("CDP_EU_COOKIE",true,{expires:365,path:"/"});$.cookie("CDP_EU_COOKIE",true,{expires:365,path:"/"});$("#accept_cookies").fadeOut()})})},deleteAllCookies:function(){var cookies=document.cookie.split(";");var ccc=document.cookie;for(var i=0;i<cookies.length;i++){var cookie=cookies[i];var eqPos=cookie.indexOf("=");var name=eqPos>-1?cookie.substr(0,eqPos):cookie;if($.trim(name)!="CDP_EU_COOKIE"){$.cookie($.trim(name),null,{domain:$().getDomain(),path:"/"});$.cookie($.trim(name),null,{domain:"www."+$().getDomain(),path:"/"});$.cookie($.trim(name),null,{domain:"."+$().getDomain(),path:"/"});$.cookie($.trim(name),null,{domain:document.domain,path:"/"});$.cookie($.trim(name),null,{path:"/"})}}return $()},getDomain:function(){return window.location.hostname.replace(/([a-zA-Z0-9]+.)/,"")}});
// Ezdz [izy-dizy]
// Licensed under the MIT license.
// http://github.com/jaysalvat/ezdz/
(function(factory){if(typeof define==="function"&&define.amd){define(["jquery"],factory)}else{if(typeof exports==="object"){factory(require("jquery"))}else{factory(jQuery)}}}(function($){var defaults={className:"",text:"Drop a file",previewImage:true,value:null,classes:{main:"ezdz-dropzone",enter:"ezdz-enter",reject:"ezdz-reject",accept:"ezdz-accept",focus:"ezdz-focus"},validators:{maxSize:null,width:null,maxWidth:null,minWidth:null,height:null,maxHeight:null,minHeight:null},init:function(){},enter:function(){},leave:function(){},reject:function(){},accept:function(){},format:function(filename){return filename}};$.ezdz=function(element,options){this.settings=$.extend(true,{},defaults,$.ezdz.defaults,options);this.$input=$(element);var self=this,settings=self.settings,$input=self.$input;if(!$input.is('input[type="file"]')){return}if(!$.ezdz.isBrowserCompatible()){return}var init=function(){var $ezdz,$container,value;$container=$('<div class="'+settings.classes.main+' '+$input.data('class')+'" />').on("dragover.ezdz",function(){$(this).addClass(settings.classes.enter);if($.isFunction(settings.enter)){settings.enter.apply(this)}}).on("dragleave.ezdz",function(){$(this).removeClass(settings.classes.enter);if($.isFunction(settings.leaved)){settings.leaved.apply(this)}}).addClass(settings.className);$input.wrap($container).before("<div>"+settings.text+"</div>");$ezdz=$input.parent("."+settings.classes.main);value=settings.value||$input.data("value");if($input.data("exist")){basename=$input.data("exist").replace(/\\/g,"/").replace(/.*\//,""),formatted=settings.format(basename);var img=new Image();img.src=$input.data("exist");img.onload=function(){$ezdz.find("div").html($(img).fadeIn())};img.onerror=function(){$ezdz.find("div").html("<span>"+formatted+"</span>")};$ezdz.addClass(settings.classes.accept)}if(value){self.preview(value)}if($.isFunction(settings.init)){settings.init.apply($input,[value])}$input.on("focus.ezdz",function(){$ezdz.addClass(settings.classes.focus)}).on("blur.ezdz",function(){$ezdz.removeClass(settings.classes.focus)}).on("change.ezdz",function(){var file=this.files[0];if(!file){return}var basename=file.name.replace(/\\/g,"/").replace(/.*\//,""),extension=file.name.split(".").pop(),formatted=settings.format(basename);file.extension=extension;var allowed=$input.attr("accept"),accepted=false,valid=true,errors={mimeType:false,maxSize:false,width:false,minWidth:false,maxWidth:false,height:false,minHeight:false,maxHeight:false};if(allowed){var types=allowed.split(/[,|]/);$.each(types,function(i,type){type=$.trim(type);if(file.type===type){accepted=true;return false}if(type.indexOf("/*")!==false){var a=type.replace("/*",""),b=file.type.replace(/(\/.*)$/g,"");if(a===b){accepted=true;return false}}});if(accepted===false){errors.mimeType=true}}else{accepted=true}$ezdz.removeClass(settings.classes.reject+" "+settings.classes.accept);if(accepted!==true){$input.val("");$ezdz.addClass(settings.classes.reject);if($.isFunction(settings.reject)){settings.reject.apply($input,[file,errors])}return false}var reader=new FileReader(file);reader.readAsDataURL(file);reader.onload=function(e){var img=new Image(),isImage;file.data=e.target.result;img.src=file.data;setTimeout(function(){isImage=(img.width&&img.height);if(settings.validators.maxSize&&file.size>settings.validators.maxSize){valid=false;errors.maxSize=true}if(isImage){file.width=img.width;file.height=img.height;if(settings.validators.width&&img.width!==settings.validators.width){valid=false;errors.width=true}if(settings.validators.maxWidth&&img.width>settings.validators.maxWidth){valid=false;errors.maxWidth=true}if(settings.validators.minWidth&&img.width<settings.validators.minWidth){valid=false;errors.minWidth=true}if(settings.validators.height&&img.height!==settings.validators.height){valid=false;errors.height=true}if(settings.validators.maxHeight&&img.height>settings.validators.maxHeight){valid=false;errors.maxHeight=true}if(settings.validators.minHeight&&img.height<settings.validators.minHeight){valid=false;errors.minHeight=true}}if(valid===true){$ezdz.find("img").remove();if(isImage&&settings.previewImage===true){$ezdz.find("div").html($(img).fadeIn())}else{$ezdz.find("div").html("<span>"+formatted+"</span>")}$ezdz.addClass(settings.classes.accept);if($.isFunction(settings.accept)){settings.accept.apply($input,[file])}}else{$input.val("");$ezdz.addClass(settings.classes.reject);if($.isFunction(settings.reject)){settings.reject.apply($input,[file,errors])}}},250)}})};init()};$.ezdz.prototype.preview=function(path,callback){var settings=this.settings,$input=this.$input,$ezdz=$input.parent("."+settings.classes.main),basename=path.replace(/\\/g,"/").replace(/.*\//,""),formatted=settings.format(basename);var img=new Image();img.src=path;img.onload=function(){$ezdz.find("div").html($(img).fadeIn());if($.isFunction(callback)){callback.apply(this)}};img.onerror=function(){$ezdz.find("div").html("<span>"+formatted+"</span>");if($.isFunction(callback)){callback.apply(this)}};$ezdz.addClass(settings.classes.accept)};$.ezdz.prototype.destroy=function(){var settings=this.settings,$input=this.$input;$input.parent("."+settings.classes.main).replaceWith($input);$input.off("*.ezdz");$input.removeData("ezdz")};$.ezdz.prototype.options=function(options){var settings=this.settings;if(!options){return settings}$.extend(true,this.settings,options)};$.ezdz.prototype.container=function(){var settings=this.settings,$input=this.$input;return $input.parent("."+settings.classes.main)};$.ezdz.isBrowserCompatible=function(){return !!(window.File&&window.FileList&&window.FileReader)};$.ezdz.defaults=defaults;$.fn.ezdz=function(options){var args=arguments,plugin=$(this).data("ezdz");if(!plugin){return $(this).data("ezdz",new $.ezdz(this,options))}if(plugin[options]){return plugin[options].apply(plugin,Array.prototype.slice.call(args,1))}else{$.error("Ezdz error - Method "+options+" does not exist.")}}}));
/*
Edit In Place
*/
$.fn.editableTableWidget=function(options){return $(this).each(function(){var buildDefaultOptions=function(){var opts=$.extend({},$.fn.editableTableWidget.defaultOptions);opts.editor=opts.editor.clone();return opts},activeOptions=$.extend(buildDefaultOptions(),options),ARROW_LEFT=37,ARROW_UP=38,ARROW_RIGHT=39,ARROW_DOWN=40,ENTER=13,ESC=27,TAB=9,element=$(this),editor=activeOptions.editor.css("position","absolute").hide().appendTo(element.parent()),active,showEditor=function(select){active=element.find("[data-editable]:focus");if(active.length){editor.val(active.text()).removeClass("error").show().offset(active.offset()).css(active.css(activeOptions.cloneProperties)).width(active.width()).height(active.height()).focus();if(select){editor.select()}}},setActiveText=function(){var text=editor.val(),evt=$.Event("change"),originalContent;if(active.text()===text||editor.hasClass("error")){return true}originalContent=active.html();active.text(text).trigger(evt,text);if(evt.result===false){active.html(originalContent)}},movement=function(element,keycode){if(keycode===ARROW_RIGHT){return element.next()}else{if(keycode===ARROW_LEFT){return element.prev()}else{if(keycode===ARROW_UP){return element.parent().prev().children().eq(element.index())}else{if(keycode===ARROW_DOWN){return element.parent().next().children().eq(element.index())}}}}return[]};editor.blur(function(){setActiveText();editor.hide()}).keydown(function(e){if(e.which===ENTER){setActiveText();editor.hide();active.focus();e.preventDefault();e.stopPropagation()}else{if(e.which===ESC){editor.val(active.text());e.preventDefault();e.stopPropagation();editor.hide();active.focus()}else{if(e.which===TAB){active.focus()}else{if(this.selectionEnd-this.selectionStart===this.value.length){var possibleMove=movement(active,e.which);if(possibleMove.length>0){possibleMove.focus();e.preventDefault();e.stopPropagation()}}}}}}).on("input paste",function(){var evt=$.Event("validate");active.trigger(evt,editor.val());if(evt.result===false){editor.addClass("error")}else{editor.removeClass("error")}});element.on("click keypress dblclick",showEditor).keydown(function(e){var prevent=true,possibleMove=movement($(e.target),e.which);if(possibleMove.length>0){possibleMove.focus()}else{if(e.which===ENTER){showEditor(false)}else{if(e.which===17||e.which===91||e.which===93){showEditor(true);prevent=false}else{prevent=false}}}if(prevent){e.stopPropagation();e.preventDefault()}});element.find("[data-editable]").css("cursor","pointer").prop("tabindex",1);$(window).on("resize",function(){if(editor.is(":visible")){editor.offset(active.offset()).width(active.width()).height(active.height())}})})};$.fn.editableTableWidget.defaultOptions={cloneProperties:["padding","padding-top","padding-bottom","padding-left","padding-right","text-align","font","font-size","font-family","font-weight","border","border-top","border-bottom","border-left","border-right"],editor:$("<input>").addClass("wojo editable")};
/*
 * wojoUpload.js - Jquery File Uploader
 * 
 */
(function($){var pluginName='wojoUpload';var defaults={url:document.URL,method:'POST',extraData:{},maxFileSize:0,maxFiles:0,allowedTypes:'*',extFilter:null,dataType:null,fileName:'file',onInit:function(){},onFallbackMode:function(message){},onNewFile:function(id,file){},onBeforeUpload:function(id){},onComplete:function(){},onUploadProgress:function(id,percent){},onUploadSuccess:function(id,data){},onUploadError:function(id,message){},onFileTypeError:function(file){},onFileSizeError:function(file){},onFileExtError:function(file){},onFilesMaxError:function(file){}};var wojoUpload=function(element,options){this.element=$(element);this.settings=$.extend({},defaults,options);if(!this.checkBrowser()){return false}this.init();return true};wojoUpload.prototype.checkBrowser=function(){if(window.FormData===undefined){this.settings.onFallbackMode.call(this.element,'Browser doesn\'t support Form API');return false}if(this.element.find('input[type=file]').length>0){return true}if(!this.checkEvent('drop',this.element)||!this.checkEvent('dragstart',this.element)){this.settings.onFallbackMode.call(this.element,'Browser doesn\'t support Ajax Drag and Drop');return false}return true};wojoUpload.prototype.checkEvent=function(eventName,element){var element=element||document.createElement('div');var eventName='on'+eventName;var isSupported=eventName in element;if(!isSupported){if(!element.setAttribute){element=document.createElement('div')}if(element.setAttribute&&element.removeAttribute){element.setAttribute(eventName,'');isSupported=typeof element[eventName]=='function';if(typeof element[eventName]!='undefined'){element[eventName]=undefined}element.removeAttribute(eventName)}}element=null;return isSupported};wojoUpload.prototype.init=function(){var widget=this;widget.queue=new Array();widget.queuePos=-1;widget.queueRunning=false;widget.element.on('drop',function(evt){evt.preventDefault();var files=evt.originalEvent.dataTransfer.files;widget.queueFiles(files)});widget.element.find('input[type=file]').on('change',function(evt){var files=evt.target.files;widget.queueFiles(files);$(this).val('')});this.settings.onInit.call(this.element)};wojoUpload.prototype.queueFiles=function(files){var j=this.queue.length;for(var i=0;i<files.length;i++){var file=files[i];if((this.settings.maxFileSize>0)&&(file.size>this.settings.maxFileSize)){this.settings.onFileSizeError.call(this.element,file);continue}if((this.settings.allowedTypes!='*')&&!file.type.match(this.settings.allowedTypes)){this.settings.onFileTypeError.call(this.element,file);continue}if(this.settings.extFilter!=null){var extList=this.settings.extFilter.toLowerCase().split(';');var ext=file.name.toLowerCase().split('.').pop();if($.inArray(ext,extList)<0){this.settings.onFileExtError.call(this.element,file);continue}}if(this.settings.maxFiles>0){if(this.queue.length>=this.settings.maxFiles){this.settings.onFilesMaxError.call(this.element,file);continue}}this.queue.push(file);var index=this.queue.length-1;this.settings.onNewFile.call(this.element,index,file)}if(this.queueRunning){return false}if(this.queue.length==j){return false}this.processQueue();return true};wojoUpload.prototype.processQueue=function(){var widget=this;widget.queuePos++;if(widget.queuePos>=widget.queue.length){widget.settings.onComplete.call(widget.element);widget.queuePos=(widget.queue.length-1);widget.queueRunning=false;return}var file=widget.queue[widget.queuePos];var fd=new FormData();fd.append(widget.settings.fileName,file);var can_continue=widget.settings.onBeforeUpload.call(widget.element,widget.queuePos);if(false===can_continue){return}$.each(widget.settings.extraData,function(exKey,exVal){fd.append(exKey,exVal)});widget.queueRunning=true;$.ajax({url:widget.settings.url,type:widget.settings.method,dataType:widget.settings.dataType,data:fd,cache:false,contentType:false,processData:false,forceSync:false,xhr:function(){var xhrobj=$.ajaxSettings.xhr();if(xhrobj.upload){xhrobj.upload.addEventListener('progress',function(event){var percent=0;var position=event.loaded||event.position;var total=event.total||e.totalSize;if(event.lengthComputable){percent=Math.ceil(position/total*100)}widget.settings.onUploadProgress.call(widget.element,widget.queuePos,percent)},false)}return xhrobj},success:function(data,message,xhr){widget.settings.onUploadSuccess.call(widget.element,widget.queuePos,data)},error:function(xhr,status,errMsg){widget.settings.onUploadError.call(widget.element,widget.queuePos,errMsg)},complete:function(xhr,textStatus){widget.processQueue()}})};$.fn.wojoUpload=function(options){return this.each(function(){if(!$.data(this,pluginName)){$.data(this,pluginName,new wojoUpload(this,options))}})};$(document).on('dragenter',function(e){e.stopPropagation();e.preventDefault()});$(document).on('dragover',function(e){e.stopPropagation();e.preventDefault()});$(document).on('drop',function(e){e.stopPropagation();e.preventDefault()})})(jQuery);
/*!
 * Simple File Upload with Preview
 */
(function(scope,$){var simpleUpload=[],simpleUploadCount=0;$.fn.simpleUpload=function(options){var def={url:null,change:null,error:null,types:null,fields:null,size:5120};return this.each(function(){var $this=$(this),id=++simpleUploadCount;$this.data("simpleUpload",id);options=options||{};$.each($this.data(),function(name,value){if("simpleUpload"==name){return}options[name]=(typeof window[value]=="function")?window[value]:value});var params=$.extend({},def,options);if(typeof params.change=="function"){$this.change(function(){params.change($this[0].files)})}if(params.trigger){if(params.trigger instanceof jQuery){params.trigger.click(send)}else{$(document).on("click",params.trigger,send)}}else{$this.change(send)}simpleUpload[id]=params;function send(event){event.preventDefault();$this.simpleUploadSend()}})};$.fn.simpleUploadSend=function(fields){return this.each(function(){var $this=$(this),id=$this.data("simpleUpload"),name=$this.attr("name"),data=new FormData();params=simpleUpload[id];for(var i in $this[0].files){if(typeof $this[0].files[i]=="object"){var file=$this[0].files[i];if(!$.typeCheck(file.name,params.types)){if(typeof params.error=="function"){params.error({type:"fileType"})}return false}if((file.size/params.size)>params.size){if(typeof params.error=="function"){params.error({type:"size"})}return false}data.append(name+"["+i+"]",file)}}if(typeof params.fields=="object"){for(i in params.fields){if($.isArray(params.fields[i])){for(var k in params.fields[i]){data.append(i+"["+k+"]",params.fields[i][k])}}else{data.append(i,params.fields[i])}}}var ajax={url:params.url,data:data,cache:false,contentType:false,processData:false,type:"POST",complete:function(){$this.val("");if(params.complete){params.complete(arguments)}}};if(params.error!=null){ajax.error=params.error}if(params.success){ajax.success=params.success}if(params.async){ajax.async=params.async}if(params.beforeSend){ajax.beforeSend=params.beforeSend}if(params.global){ajax.global=params.global}if(params.dataType){ajax.dataType=params.dataType}if(params.contents){ajax.contents=params.contents}if(params.jsonp){ajax.jsonp=params.jsonp}if(params.jsonpCallback){ajax.jsonpCallback=params.jsonpCallback}if(params.password){ajax.password=params.password}if(params.username){ajax.username=params.username}if(params.statusCode){ajax.statusCode=params.statusCode}$.ajax(ajax)})};$.extend(true,{typeCheck:function(name,types){if($.isArray(types)){if(types.indexOf($.getExt(name))>-1){return true}return false}return true},getExt:function(name){return name.substr(name.lastIndexOf(".")+1)}})})(window,window.jQuery);
/* Custom File Input 
 * bootstrap-filestyle
 * doc: http://dev.tudosobreweb.com.br/bootstrap-filestyle/
 * github: https://github.com/markusslima/bootstrap-filestyle
 */
(function($){var nextId=0;var Filestyle=function(element,options){this.options=options;this.$elementFilestyle=[];this.$element=$(element)};Filestyle.prototype={clear:function(){this.$element.val("");this.$elementFilestyle.find(":text").val("");this.$elementFilestyle.find(".label").remove()},destroy:function(){this.$element.removeAttr("style").removeData("filestyle");this.$elementFilestyle.remove()},disabled:function(value){if(value===true){if(!this.options.disabled){this.$element.attr("disabled","true");this.$elementFilestyle.find("label").attr("disabled","true");this.options.disabled=true}}else{if(value===false){if(this.options.disabled){this.$element.removeAttr("disabled");this.$elementFilestyle.find("label").removeAttr("disabled");this.options.disabled=false}}else{return this.options.disabled}}},buttonBefore:function(value){if(value===true){if(!this.options.buttonBefore){this.options.buttonBefore=true;if(this.options.input){this.$elementFilestyle.remove();this.constructor();this.pushNameFiles()}}}else{if(value===false){if(this.options.buttonBefore){this.options.buttonBefore=false;if(this.options.input){this.$elementFilestyle.remove();this.constructor();this.pushNameFiles()}}}else{return this.options.buttonBefore}}},icon:function(value){if(value===true){if(!this.options.icon){this.options.icon=true;this.$elementFilestyle.find("label").prepend(this.htmlIcon())}}else{if(value===false){if(this.options.icon){this.options.icon=false;this.$elementFilestyle.find(".icon-span-filestyle").remove()}}else{return this.options.icon}}},input:function(value){if(value===true){if(!this.options.input){this.options.input=true;if(this.options.buttonBefore){this.$elementFilestyle.append(this.htmlInput())}else{this.$elementFilestyle.prepend(this.htmlInput())}this.$elementFilestyle.find(".label").remove();this.pushNameFiles();this.$elementFilestyle.find(".group-span-filestyle").addClass("input-group-btn")}}else{if(value===false){if(this.options.input){this.options.input=false;this.$elementFilestyle.find(":text").remove();var files=this.pushNameFiles();if(files.length>0&&this.options.badge){this.$elementFilestyle.find("label").append(' <span class="wojo label">'+files.length+"</span>")}this.$elementFilestyle.find(".group-span-filestyle").removeClass("input-group-btn")}}else{return this.options.input}}},size:function(value){if(value!==undefined){var btn=this.$elementFilestyle.find("label"),input=this.$elementFilestyle.find("input");btn.removeClass("btn-lg btn-sm");input.removeClass("input-lg input-sm");if(value!="nr"){btn.addClass("btn-"+value);input.addClass("input-"+value)}}else{return this.options.size}},placeholder:function(value){if(value!==undefined){this.options.placeholder=value;this.$elementFilestyle.find("input").attr("placeholder",value)}else{return this.options.placeholder}},buttonText:function(value){if(value!==undefined){this.options.buttonText=value;this.$elementFilestyle.find("label .buttonText").html(this.options.buttonText)}else{return this.options.buttonText}},buttonName:function(value){if(value!==undefined){this.options.buttonName=value;this.$elementFilestyle.find("label").attr({"class":"btn "+this.options.buttonName})}else{return this.options.buttonName}},iconName:function(value){if(value!==undefined){this.$elementFilestyle.find(".icon-span-filestyle").attr({"class":"icon-span-filestyle "+this.options.iconName})}else{return this.options.iconName}},htmlIcon:function(){if(this.options.icon){return'<i class="icon-span-filestyle '+this.options.iconName+'"></i> '}else{return""}},htmlInput:function(){if(this.options.input){return'<input type="text" class="form-control'+(this.options.size==" nr"?"":" input-"+this.options.size)+'" placeholder="'+this.options.placeholder+'" disabled> '}else{return""}},pushNameFiles:function(){var content="",files=[];if(this.$element[0].files===undefined){files[0]={name:this.$element[0]&&this.$element[0].value}}else{files=this.$element[0].files}for(var i=0;i<files.length;i++){content+=files[i].name.split("\\").pop()+", "}if(content!==""){this.$elementFilestyle.find(":text").val(content.replace(/\, $/g,""))}else{this.$elementFilestyle.find(":text").val("")}return files},constructor:function(){var _self=this,html="",id=_self.$element.attr("id"),files=[],btn="",$label;if(id===""||!id){id="filestyle-"+nextId;_self.$element.attr({id:id});nextId++}btn='<button type="button" class="wojo button '+_self.options.buttonClass+' group-span-filestyle '+(_self.options.input?"input-group-btn":"")+'"><label for="'+id+'" class="btn '+_self.options.buttonName+" "+(_self.options.size=="nr"?"":"btn-"+_self.options.size)+'" '+(_self.options.disabled?'disabled="true"':"")+">"+_self.htmlIcon()+'<span class="buttonText">'+_self.options.buttonText+"</span></label></button>";html=_self.options.buttonBefore?btn+_self.htmlInput():_self.htmlInput()+btn;_self.$elementFilestyle=(_self.$element.attr("data-input")==true||_self.options.input==true)?$('<div class="wojo right action input">'+html+"</div>"):$('<div class="wojo-input-group-single">'+html+"</div>");_self.$elementFilestyle.find(".group-span-filestyle").attr("tabindex","0").keypress(function(e){if(e.keyCode===13||e.charCode===32){_self.$elementFilestyle.find("label").click();return false}});_self.$element.css({position:"absolute",clip:"rect(0px 0px 0px 0px)"}).attr("tabindex","-1").after(_self.$elementFilestyle);if(_self.options.disabled){_self.$element.attr("disabled","true")}_self.$element.change(function(){var files=_self.pushNameFiles();if(_self.options.input==false&&_self.options.badge){if(_self.$elementFilestyle.find(".label").length==0){_self.$elementFilestyle.find("label").append(' <span class="wojo small label">'+files.length+"</span>")}else{if(files.length==0){_self.$elementFilestyle.find(".label").remove()}else{_self.$elementFilestyle.find(".label").html(files.length)}}}else{_self.$elementFilestyle.find(".label").remove()}});if(window.navigator.userAgent.search(/firefox/i)>-1){_self.$elementFilestyle.find("button").click(function(){_self.$element.click();return false})}}};var old=$.fn.filestyle;$.fn.filestyle=function(option,value){var get="",element=this.each(function(){if($(this).attr("type")==="file"){var $this=$(this),data=$this.data("filestyle"),options=$.extend({},$.fn.filestyle.defaults,option,typeof option==="object"&&option);if(!data){$this.data("filestyle",(data=new Filestyle(this,options)));data.constructor()}if(typeof option==="string"){get=data[option](value)}}});if(typeof get!==undefined){return get}else{return element}};$.fn.filestyle.defaults={buttonText:"Choose file",iconName:"icon folder open",buttonName:"wojo finput",buttonClass:"primary",size:"nr",input:true,badge:true,icon:true,buttonBefore:false,disabled:false,placeholder:""};$.fn.filestyle.noConflict=function(){$.fn.filestyle=old;return this};$(function(){$(".filefield").each(function(){var $this=$(this),options={input:$this.attr("data-input")==="false"?false:true,icon:$this.attr("data-icon")==="false"?false:true,buttonBefore:$this.attr("data-buttonBefore")==="true"?true:false,disabled:$this.attr("data-disabled")==="true"?true:false,size:$this.attr("data-size"),buttonText:$this.attr("data-buttonText"),buttonName:$this.attr("data-buttonName"),buttonClass:$this.attr("data-buttonClass"),iconName:$this.attr("data-iconName"),badge:$this.attr("data-badge")==="false"?false:true,placeholder:$this.attr("data-placeholder")};$this.filestyle(options)})})})(window.jQuery);
/*
 * Spectrum Colorpicker v1.8.0
 * https://github.com/bgrins/spectrum
 * Author: Brian Grinstead
 * License: MIT
*/
(function(factory){"use strict";if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports=="object"&&typeof module=="object"){module.exports=factory(require('jquery'))}else{factory(jQuery)}})(function($,undefined){"use strict";var defaultOpts={beforeShow:noop,move:noop,change:noop,show:noop,hide:noop,color:false,flat:false,showInput:false,allowEmpty:false,showButtons:true,clickoutFiresChange:true,showInitial:false,showPalette:false,showPaletteOnly:false,hideAfterPaletteSelect:false,togglePaletteOnly:false,showSelectionPalette:true,localStorageKey:false,appendTo:"body",maxSelectionSize:7,cancelText:"cancel",chooseText:"choose",togglePaletteMoreText:"more",togglePaletteLessText:"less",clearText:"Clear Color Selection",noColorSelectedText:"No Color Selected",preferredFormat:"rgb",className:"",containerClassName:"",replacerClassName:"",showAlpha:false,theme:"",palette:['#f44336','#e91e63','#9c27b0','#673ab7','#3f51b5','#2196f3','#03a9f4','#00bcd4','#009688','#4caf50','#8bc34a','#cddc39','#ffeb3b','#ffc107','#ff9800','#ff5722','#795548','#9e9e9e','#607d8b','#000000'],selectionPalette:[],disabled:false,offset:null},spectrums=[],IE=!!/msie/i.exec(window.navigator.userAgent),rgbaSupport=(function(){function contains(str,substr){return!!~(''+str).indexOf(substr)}var elem=document.createElement('div');var style=elem.style;style.cssText='background-color:rgba(0,0,0,.5)';return contains(style.backgroundColor,'rgba')||contains(style.backgroundColor,'hsla')})(),replaceInput=["<div class='sp-replacer'>","<div class='sp-preview'><div class='sp-preview-inner'></div></div>","<div class='sp-dd'>&#9660;</div>","</div>"].join(''),markup=(function(){var gradientFix="";if(IE){for(var i=1;i<=6;i++){gradientFix+="<div class='sp-"+i+"'></div>"}}return["<div class='sp-container sp-hidden'>","<div class='sp-palette-container'>","<div class='sp-palette sp-thumb sp-cf'></div>","<div class='sp-palette-button-container sp-cf'>","<button type='button' class='sp-palette-toggle'></button>","</div>","</div>","<div class='sp-picker-container'>","<div class='sp-top sp-cf'>","<div class='sp-fill'></div>","<div class='sp-top-inner'>","<div class='sp-color'>","<div class='sp-sat'>","<div class='sp-val'>","<div class='sp-dragger'></div>","</div>","</div>","</div>","<div class='sp-clear sp-clear-display'><i class=\"icon delete\"></i>","</div>","<div class='sp-hue'>","<div class='sp-slider'></div>",gradientFix,"</div>","</div>","<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>","</div>","<div class='sp-input-container sp-cf'>","<input class='sp-input' type='text' spellcheck='false'  />","</div>","<div class='sp-initial sp-thumb sp-cf'></div>","<div class='sp-button-container sp-cf'>","<a class='sp-cancel' href='#'></a>","<button type='button' class='sp-choose'></button>","</div>","</div>","</div>"].join("")})();function paletteTemplate(p,color,className,opts){var html=[];for(var i=0;i<p.length;i++){var current=p[i];if(current){var tiny=tinycolor(current);var c=tiny.toHsl().l<0.5?"sp-thumb-el sp-thumb-dark":"sp-thumb-el sp-thumb-light";c+=(tinycolor.equals(color,current))?" sp-thumb-active":"";var formattedString=tiny.toString(opts.preferredFormat||"rgb");var swatchStyle=rgbaSupport?("background-color:"+tiny.toRgbString()):"filter:"+tiny.toFilter();html.push('<span title="'+formattedString+'" data-color="'+tiny.toRgbString()+'" class="'+c+'"><span class="sp-thumb-inner" style="'+swatchStyle+';" /></span>')}else{var cls='sp-clear-display';html.push($('<div />').append($('<span data-color="" style="background-color:transparent;" class="'+cls+'"></span>').attr('title',opts.noColorSelectedText)).html())}}return"<div class='sp-cf "+className+"'>"+html.join('')+"</div>"}function hideAll(){for(var i=0;i<spectrums.length;i++){if(spectrums[i]){spectrums[i].hide()}}}function instanceOptions(o,callbackContext){var opts=$.extend({},defaultOpts,o);opts.callbacks={'move':bind(opts.move,callbackContext),'change':bind(opts.change,callbackContext),'show':bind(opts.show,callbackContext),'hide':bind(opts.hide,callbackContext),'beforeShow':bind(opts.beforeShow,callbackContext)};return opts}function spectrum(element,o){var opts=instanceOptions(o,element),flat=opts.flat,showSelectionPalette=opts.showSelectionPalette,localStorageKey=opts.localStorageKey,theme=opts.theme,callbacks=opts.callbacks,resize=throttle(reflow,10),visible=false,isDragging=false,dragWidth=0,dragHeight=0,dragHelperHeight=0,slideHeight=0,slideWidth=0,alphaWidth=0,alphaSlideHelperWidth=0,slideHelperHeight=0,currentHue=0,currentSaturation=0,currentValue=0,currentAlpha=1,palette=[],paletteArray=[],paletteLookup={},selectionPalette=opts.selectionPalette.slice(0),maxSelectionSize=opts.maxSelectionSize,draggingClass="sp-dragging",shiftMovementDirection=null;var doc=element.ownerDocument,body=doc.body,boundElement=$(element),disabled=false,container=$(markup,doc).addClass(theme),pickerContainer=container.find(".sp-picker-container"),dragger=container.find(".sp-color"),dragHelper=container.find(".sp-dragger"),slider=container.find(".sp-hue"),slideHelper=container.find(".sp-slider"),alphaSliderInner=container.find(".sp-alpha-inner"),alphaSlider=container.find(".sp-alpha"),alphaSlideHelper=container.find(".sp-alpha-handle"),textInput=container.find(".sp-input"),paletteContainer=container.find(".sp-palette"),initialColorContainer=container.find(".sp-initial"),cancelButton=container.find(".sp-cancel"),clearButton=container.find(".sp-clear"),chooseButton=container.find(".sp-choose"),toggleButton=container.find(".sp-palette-toggle"),isInput=boundElement.is("input"),isInputTypeColor=isInput&&boundElement.attr("type")==="color"&&inputTypeColorSupport(),shouldReplace=isInput&&!flat,replacer=(shouldReplace)?$(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName):$([]),offsetElement=(shouldReplace)?replacer:boundElement,previewElement=replacer.find(".sp-preview-inner"),initialColor=opts.color||(isInput&&boundElement.val()),colorOnShow=false,currentPreferredFormat=opts.preferredFormat,clickoutFiresChange=!opts.showButtons||opts.clickoutFiresChange,isEmpty=!initialColor,allowEmpty=opts.allowEmpty&&!isInputTypeColor;function applyOptions(){if(opts.showPaletteOnly){opts.showPalette=true}toggleButton.text(opts.showPaletteOnly?opts.togglePaletteMoreText:opts.togglePaletteLessText);if(opts.palette){palette=opts.palette.slice(0);paletteArray=$.isArray(palette[0])?palette:[palette];paletteLookup={};for(var i=0;i<paletteArray.length;i++){for(var j=0;j<paletteArray[i].length;j++){var rgb=tinycolor(paletteArray[i][j]).toRgbString();paletteLookup[rgb]=true}}}container.toggleClass("sp-flat",flat);container.toggleClass("sp-input-disabled",!opts.showInput);container.toggleClass("sp-alpha-enabled",opts.showAlpha);container.toggleClass("sp-clear-enabled",allowEmpty);container.toggleClass("sp-buttons-disabled",!opts.showButtons);container.toggleClass("sp-palette-buttons-disabled",!opts.togglePaletteOnly);container.toggleClass("sp-palette-disabled",!opts.showPalette);container.toggleClass("sp-palette-only",opts.showPaletteOnly);container.toggleClass("sp-initial-disabled",!opts.showInitial);container.addClass(opts.className).addClass(opts.containerClassName);reflow()}function initialize(){if(IE){container.find("*:not(input)").attr("unselectable","on")}applyOptions();if(shouldReplace){boundElement.after(replacer).hide()}if(!allowEmpty){clearButton.hide()}if(flat){boundElement.after(container).hide()}else{var appendTo=opts.appendTo==="parent"?boundElement.parent():$(opts.appendTo);if(appendTo.length!==1){appendTo=$("body")}appendTo.append(container)}updateSelectionPaletteFromStorage();offsetElement.on("click.spectrum touchstart.spectrum",function(e){if(!disabled){toggle()}e.stopPropagation();if(!$(e.target).is("input")){e.preventDefault()}});if(boundElement.is(":disabled")||(opts.disabled===true)){disable()}container.click(stopPropagation);textInput.change(setFromTextInput);textInput.on("paste",function(){setTimeout(setFromTextInput,1)});textInput.keydown(function(e){if(e.keyCode==13){setFromTextInput()}});cancelButton.text(opts.cancelText);cancelButton.on("click.spectrum",function(e){e.stopPropagation();e.preventDefault();revert();hide()});clearButton.attr("title",opts.clearText);clearButton.on("click.spectrum",function(e){e.stopPropagation();e.preventDefault();isEmpty=true;move();if(flat){updateOriginalInput(true)}});chooseButton.text(opts.chooseText);chooseButton.on("click.spectrum",function(e){e.stopPropagation();e.preventDefault();if(IE&&textInput.is(":focus")){textInput.trigger('change')}if(isValid()){updateOriginalInput(true);hide()}});toggleButton.text(opts.showPaletteOnly?opts.togglePaletteMoreText:opts.togglePaletteLessText);toggleButton.on("click.spectrum",function(e){e.stopPropagation();e.preventDefault();opts.showPaletteOnly=!opts.showPaletteOnly;if(!opts.showPaletteOnly&&!flat){container.css('left','-='+(pickerContainer.outerWidth(true)+5))}applyOptions()});draggable(alphaSlider,function(dragX,dragY,e){currentAlpha=(dragX/alphaWidth);isEmpty=false;if(e.shiftKey){currentAlpha=Math.round(currentAlpha*10)/10}move()},dragStart,dragStop);draggable(slider,function(dragX,dragY){currentHue=parseFloat(dragY/slideHeight);isEmpty=false;if(!opts.showAlpha){currentAlpha=1}move()},dragStart,dragStop);draggable(dragger,function(dragX,dragY,e){if(!e.shiftKey){shiftMovementDirection=null}else if(!shiftMovementDirection){var oldDragX=currentSaturation*dragWidth;var oldDragY=dragHeight-(currentValue*dragHeight);var furtherFromX=Math.abs(dragX-oldDragX)>Math.abs(dragY-oldDragY);shiftMovementDirection=furtherFromX?"x":"y"}var setSaturation=!shiftMovementDirection||shiftMovementDirection==="x";var setValue=!shiftMovementDirection||shiftMovementDirection==="y";if(setSaturation){currentSaturation=parseFloat(dragX/dragWidth)}if(setValue){currentValue=parseFloat((dragHeight-dragY)/dragHeight)}isEmpty=false;if(!opts.showAlpha){currentAlpha=1}move()},dragStart,dragStop);if(!!initialColor){set(initialColor);updateUI();currentPreferredFormat=opts.preferredFormat||tinycolor(initialColor).format;addColorToSelectionPalette(initialColor)}else{updateUI()}if(flat){show()}function paletteElementClick(e){if(e.data&&e.data.ignore){set($(e.target).closest(".sp-thumb-el").data("color"));move()}else{set($(e.target).closest(".sp-thumb-el").data("color"));move();if(opts.hideAfterPaletteSelect){updateOriginalInput(true);hide()}else{updateOriginalInput()}}return false}var paletteEvent=IE?"mousedown.spectrum":"click.spectrum touchstart.spectrum";paletteContainer.on(paletteEvent,".sp-thumb-el",paletteElementClick);initialColorContainer.on(paletteEvent,".sp-thumb-el:nth-child(1)",{ignore:true},paletteElementClick)}function updateSelectionPaletteFromStorage(){if(localStorageKey&&window.localStorage){try{var oldPalette=window.localStorage[localStorageKey].split(",#");if(oldPalette.length>1){delete window.localStorage[localStorageKey];$.each(oldPalette,function(i,c){addColorToSelectionPalette(c)})}}catch(e){}try{selectionPalette=window.localStorage[localStorageKey].split(";")}catch(e){}}}function addColorToSelectionPalette(color){if(showSelectionPalette){var rgb=tinycolor(color).toRgbString();if(!paletteLookup[rgb]&&$.inArray(rgb,selectionPalette)===-1){selectionPalette.push(rgb);while(selectionPalette.length>maxSelectionSize){selectionPalette.shift()}}if(localStorageKey&&window.localStorage){try{window.localStorage[localStorageKey]=selectionPalette.join(";")}catch(e){}}}}function getUniqueSelectionPalette(){var unique=[];if(opts.showPalette){for(var i=0;i<selectionPalette.length;i++){var rgb=tinycolor(selectionPalette[i]).toRgbString();if(!paletteLookup[rgb]){unique.push(selectionPalette[i])}}}return unique.reverse().slice(0,opts.maxSelectionSize)}function drawPalette(){var currentColor=get();var html=$.map(paletteArray,function(palette,i){return paletteTemplate(palette,currentColor,"sp-palette-row sp-palette-row-"+i,opts)});updateSelectionPaletteFromStorage();if(selectionPalette){html.push(paletteTemplate(getUniqueSelectionPalette(),currentColor,"sp-palette-row sp-palette-row-selection",opts))}paletteContainer.html(html.join(""))}function drawInitial(){if(opts.showInitial){var initial=colorOnShow;var current=get();initialColorContainer.html(paletteTemplate([initial,current],current,"sp-palette-row-initial",opts))}}function dragStart(){if(dragHeight<=0||dragWidth<=0||slideHeight<=0){reflow()}isDragging=true;container.addClass(draggingClass);shiftMovementDirection=null;boundElement.trigger('dragstart.spectrum',[get()])}function dragStop(){isDragging=false;container.removeClass(draggingClass);boundElement.trigger('dragstop.spectrum',[get()])}function setFromTextInput(){var value=textInput.val();if((value===null||value==="")&&allowEmpty){set(null);move();updateOriginalInput()}else{var tiny=tinycolor(value);if(tiny.isValid()){set(tiny);move();updateOriginalInput()}else{textInput.addClass("sp-validation-error")}}}function toggle(){if(visible){hide()}else{show()}}function show(){var event=$.Event('beforeShow.spectrum');if(visible){reflow();return}boundElement.trigger(event,[get()]);if(callbacks.beforeShow(get())===false||event.isDefaultPrevented()){return}hideAll();visible=true;$(doc).on("keydown.spectrum",onkeydown);$(doc).on("click.spectrum",clickout);$(window).on("resize.spectrum",resize);replacer.addClass("sp-active");container.removeClass("sp-hidden");reflow();updateUI();colorOnShow=get();drawInitial();callbacks.show(colorOnShow);boundElement.trigger('show.spectrum',[colorOnShow])}function onkeydown(e){if(e.keyCode===27){hide()}}function clickout(e){if(e.button==2){return}if(isDragging){return}if(clickoutFiresChange){updateOriginalInput(true)}else{revert()}hide()}function hide(){if(!visible||flat){return}visible=false;$(doc).off("keydown.spectrum",onkeydown);$(doc).off("click.spectrum",clickout);$(window).off("resize.spectrum",resize);replacer.removeClass("sp-active");container.addClass("sp-hidden");callbacks.hide(get());boundElement.trigger('hide.spectrum',[get()])}function revert(){set(colorOnShow,true);updateOriginalInput(true)}function set(color,ignoreFormatChange){if(tinycolor.equals(color,get())){updateUI();return}var newColor,newHsv;if(!color&&allowEmpty){isEmpty=true}else{isEmpty=false;newColor=tinycolor(color);newHsv=newColor.toHsv();currentHue=(newHsv.h%360)/360;currentSaturation=newHsv.s;currentValue=newHsv.v;currentAlpha=newHsv.a}updateUI();if(newColor&&newColor.isValid()&&!ignoreFormatChange){currentPreferredFormat=opts.preferredFormat||newColor.getFormat()}}function get(opts){opts=opts||{};if(allowEmpty&&isEmpty){return null}return tinycolor.fromRatio({h:currentHue,s:currentSaturation,v:currentValue,a:Math.round(currentAlpha*1000)/1000},{format:opts.format||currentPreferredFormat})}function isValid(){return!textInput.hasClass("sp-validation-error")}function move(){updateUI();callbacks.move(get());boundElement.trigger('move.spectrum',[get()])}function updateUI(){textInput.removeClass("sp-validation-error");updateHelperLocations();var flatColor=tinycolor.fromRatio({h:currentHue,s:1,v:1});dragger.css("background-color",flatColor.toHexString());var format=currentPreferredFormat;if(currentAlpha<1&&!(currentAlpha===0&&format==="name")){if(format==="hex"||format==="hex3"||format==="hex6"||format==="name"){format="rgb"}}var realColor=get({format:format}),displayColor='';previewElement.removeClass("sp-clear-display");previewElement.css('background-color','transparent');if(!realColor&&allowEmpty){previewElement.addClass("sp-clear-display")}else{var realHex=realColor.toHexString(),realRgb=realColor.toRgbString();if(rgbaSupport||realColor.alpha===1){previewElement.css("background-color",realRgb)}else{previewElement.css("background-color","transparent");previewElement.css("filter",realColor.toFilter())}if(opts.showAlpha){var rgb=realColor.toRgb();rgb.a=0;var realAlpha=tinycolor(rgb).toRgbString();var gradient="linear-gradient(left, "+realAlpha+", "+realHex+")";if(IE){alphaSliderInner.css("filter",tinycolor(realAlpha).toFilter({gradientType:1},realHex))}else{alphaSliderInner.css("background","-webkit-"+gradient);alphaSliderInner.css("background","-moz-"+gradient);alphaSliderInner.css("background","-ms-"+gradient);alphaSliderInner.css("background","linear-gradient(to right, "+realAlpha+", "+realHex+")")}}displayColor=realColor.toString(format)}if(opts.showInput){textInput.val(displayColor)}if(opts.showPalette){drawPalette()}drawInitial()}function updateHelperLocations(){var s=currentSaturation;var v=currentValue;if(allowEmpty&&isEmpty){alphaSlideHelper.hide();slideHelper.hide();dragHelper.hide()}else{alphaSlideHelper.show();slideHelper.show();dragHelper.show();var dragX=s*dragWidth;var dragY=dragHeight-(v*dragHeight);dragX=Math.max(-dragHelperHeight,Math.min(dragWidth-dragHelperHeight,dragX-dragHelperHeight));dragY=Math.max(-dragHelperHeight,Math.min(dragHeight-dragHelperHeight,dragY-dragHelperHeight));dragHelper.css({"top":dragY+"px","left":dragX+"px"});var alphaX=currentAlpha*alphaWidth;alphaSlideHelper.css({"left":(alphaX-(alphaSlideHelperWidth/2))+"px"});var slideY=(currentHue)*slideHeight;slideHelper.css({"top":(slideY-slideHelperHeight)+"px"})}}function updateOriginalInput(fireCallback){var color=get(),displayColor='',hasChanged=!tinycolor.equals(color,colorOnShow);if(color){displayColor=color.toString(currentPreferredFormat);addColorToSelectionPalette(color)}if(isInput){boundElement.val(displayColor)}if(fireCallback&&hasChanged){callbacks.change(color);boundElement.trigger('change',[color])}}function reflow(){if(!visible){return}dragWidth=dragger.width();dragHeight=dragger.height();dragHelperHeight=dragHelper.height();slideWidth=slider.width();slideHeight=slider.height();slideHelperHeight=slideHelper.height();alphaWidth=alphaSlider.width();alphaSlideHelperWidth=alphaSlideHelper.width();if(!flat){container.css("position","absolute");if(opts.offset){container.offset(opts.offset)}else{container.offset(getOffset(container,offsetElement))}}updateHelperLocations();if(opts.showPalette){drawPalette()}boundElement.trigger('reflow.spectrum')}function destroy(){boundElement.show();offsetElement.off("click.spectrum touchstart.spectrum");container.remove();replacer.remove();spectrums[spect.id]=null}function option(optionName,optionValue){if(optionName===undefined){return $.extend({},opts)}if(optionValue===undefined){return opts[optionName]}opts[optionName]=optionValue;if(optionName==="preferredFormat"){currentPreferredFormat=opts.preferredFormat}applyOptions()}function enable(){disabled=false;boundElement.attr("disabled",false);offsetElement.removeClass("sp-disabled")}function disable(){hide();disabled=true;boundElement.attr("disabled",true);offsetElement.addClass("sp-disabled")}function setOffset(coord){opts.offset=coord;reflow()}initialize();var spect={show:show,hide:hide,toggle:toggle,reflow:reflow,option:option,enable:enable,disable:disable,offset:setOffset,set:function(c){set(c);updateOriginalInput()},get:get,destroy:destroy,container:container};spect.id=spectrums.push(spect)-1;return spect}function getOffset(picker,input){var extraY=0;var dpWidth=picker.outerWidth();var dpHeight=picker.outerHeight();var inputHeight=input.outerHeight();var doc=picker[0].ownerDocument;var docElem=doc.documentElement;var viewWidth=docElem.clientWidth+$(doc).scrollLeft();var viewHeight=docElem.clientHeight+$(doc).scrollTop();var offset=input.offset();var offsetLeft=offset.left;var offsetTop=offset.top;offsetTop+=inputHeight;offsetLeft-=Math.min(offsetLeft,(offsetLeft+dpWidth>viewWidth&&viewWidth>dpWidth)?Math.abs(offsetLeft+dpWidth-viewWidth):0);offsetTop-=Math.min(offsetTop,((offsetTop+dpHeight>viewHeight&&viewHeight>dpHeight)?Math.abs(dpHeight+inputHeight-extraY):extraY));return{top:offsetTop,bottom:offset.bottom,left:offsetLeft,right:offset.right,width:offset.width,height:offset.height}}function noop(){}function stopPropagation(e){e.stopPropagation()}function bind(func,obj){var slice=Array.prototype.slice;var args=slice.call(arguments,2);return function(){return func.apply(obj,args.concat(slice.call(arguments)))}}function draggable(element,onmove,onstart,onstop){onmove=onmove||function(){};onstart=onstart||function(){};onstop=onstop||function(){};var doc=document;var dragging=false;var offset={};var maxHeight=0;var maxWidth=0;var hasTouch=('ontouchstart'in window);var duringDragEvents={};duringDragEvents["selectstart"]=prevent;duringDragEvents["dragstart"]=prevent;duringDragEvents["touchmove mousemove"]=move;duringDragEvents["touchend mouseup"]=stop;function prevent(e){if(e.stopPropagation){e.stopPropagation()}if(e.preventDefault){e.preventDefault()}e.returnValue=false}function move(e){if(dragging){if(IE&&doc.documentMode<9&&!e.button){return stop()}var t0=e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches[0];var pageX=t0&&t0.pageX||e.pageX;var pageY=t0&&t0.pageY||e.pageY;var dragX=Math.max(0,Math.min(pageX-offset.left,maxWidth));var dragY=Math.max(0,Math.min(pageY-offset.top,maxHeight));if(hasTouch){prevent(e)}onmove.apply(element,[dragX,dragY,e])}}function start(e){var rightclick=(e.which)?(e.which==3):(e.button==2);if(!rightclick&&!dragging){if(onstart.apply(element,arguments)!==false){dragging=true;maxHeight=$(element).height();maxWidth=$(element).width();offset=$(element).offset();$(doc).on(duringDragEvents);$(doc.body).addClass("sp-dragging");move(e);prevent(e)}}}function stop(){if(dragging){$(doc).off(duringDragEvents);$(doc.body).removeClass("sp-dragging");setTimeout(function(){onstop.apply(element,arguments)},0)}dragging=false}$(element).on("touchstart mousedown",start)}function throttle(func,wait,debounce){var timeout;return function(){var context=this,args=arguments;var throttler=function(){timeout=null;func.apply(context,args)};if(debounce)clearTimeout(timeout);if(debounce||!timeout)timeout=setTimeout(throttler,wait)}}function inputTypeColorSupport(){return $.fn.spectrum.inputTypeColorSupport()}var dataID="spectrum.id";$.fn.spectrum=function(opts,extra){if(typeof opts=="string"){var returnValue=this;var args=Array.prototype.slice.call(arguments,1);this.each(function(){var spect=spectrums[$(this).data(dataID)];if(spect){var method=spect[opts];if(!method){throw new Error("Spectrum: no such method: '"+opts+"'");}if(opts=="get"){returnValue=spect.get()}else if(opts=="container"){returnValue=spect.container}else if(opts=="option"){returnValue=spect.option.apply(spect,args)}else if(opts=="destroy"){spect.destroy();$(this).removeData(dataID)}else{method.apply(spect,args)}}});return returnValue}return this.spectrum("destroy").each(function(){var options=$.extend({},$(this).data(),opts);var spect=spectrum(this,options);$(this).data(dataID,spect.id)})};$.fn.spectrum.load=true;$.fn.spectrum.loadOpts={};$.fn.spectrum.draggable=draggable;$.fn.spectrum.defaults=defaultOpts;$.fn.spectrum.inputTypeColorSupport=function inputTypeColorSupport(){if(typeof inputTypeColorSupport._cachedResult==="undefined"){var colorInput=$("<input type='color'/>")[0];inputTypeColorSupport._cachedResult=colorInput.type==="color"&&colorInput.value!==""}return inputTypeColorSupport._cachedResult};$.spectrum={};$.spectrum.localization={};$.spectrum.palettes={};$.fn.spectrum.processNativeColorInputs=function(){var colorInputs=$("input[type=color]");if(colorInputs.length&&!inputTypeColorSupport()){colorInputs.spectrum({preferredFormat:"hex6"})}};(function(){var trimLeft=/^[\s,#]+/,trimRight=/\s+$/,tinyCounter=0,math=Math,mathRound=math.round,mathMin=math.min,mathMax=math.max,mathRandom=math.random;var tinycolor=function(color,opts){color=(color)?color:'';opts=opts||{};if(color instanceof tinycolor){return color}if(!(this instanceof tinycolor)){return new tinycolor(color,opts)}var rgb=inputToRGB(color);this._originalInput=color,this._r=rgb.r,this._g=rgb.g,this._b=rgb.b,this._a=rgb.a,this._roundA=mathRound(1000*this._a)/1000,this._format=opts.format||rgb.format;this._gradientType=opts.gradientType;if(this._r<1){this._r=mathRound(this._r)}if(this._g<1){this._g=mathRound(this._g)}if(this._b<1){this._b=mathRound(this._b)}this._ok=rgb.ok;this._tc_id=tinyCounter++};tinycolor.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var rgb=this.toRgb();return(rgb.r*299+rgb.g*587+rgb.b*114)/1000},setAlpha:function(value){this._a=boundAlpha(value);this._roundA=mathRound(1000*this._a)/1000;return this},toHsv:function(){var hsv=rgbToHsv(this._r,this._g,this._b);return{h:hsv.h*360,s:hsv.s,v:hsv.v,a:this._a}},toHsvString:function(){var hsv=rgbToHsv(this._r,this._g,this._b);var h=mathRound(hsv.h*360),s=mathRound(hsv.s*100),v=mathRound(hsv.v*100);return(this._a==1)?"hsv("+h+", "+s+"%, "+v+"%)":"hsva("+h+", "+s+"%, "+v+"%, "+this._roundA+")"},toHsl:function(){var hsl=rgbToHsl(this._r,this._g,this._b);return{h:hsl.h*360,s:hsl.s,l:hsl.l,a:this._a}},toHslString:function(){var hsl=rgbToHsl(this._r,this._g,this._b);var h=mathRound(hsl.h*360),s=mathRound(hsl.s*100),l=mathRound(hsl.l*100);return(this._a==1)?"hsl("+h+", "+s+"%, "+l+"%)":"hsla("+h+", "+s+"%, "+l+"%, "+this._roundA+")"},toHex:function(allow3Char){return rgbToHex(this._r,this._g,this._b,allow3Char)},toHexString:function(allow3Char){return'#'+this.toHex(allow3Char)},toHex8:function(){return rgbaToHex(this._r,this._g,this._b,this._a)},toHex8String:function(){return'#'+this.toHex8()},toRgb:function(){return{r:mathRound(this._r),g:mathRound(this._g),b:mathRound(this._b),a:this._a}},toRgbString:function(){return(this._a==1)?"rgb("+mathRound(this._r)+", "+mathRound(this._g)+", "+mathRound(this._b)+")":"rgba("+mathRound(this._r)+", "+mathRound(this._g)+", "+mathRound(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:mathRound(bound01(this._r,255)*100)+"%",g:mathRound(bound01(this._g,255)*100)+"%",b:mathRound(bound01(this._b,255)*100)+"%",a:this._a}},toPercentageRgbString:function(){return(this._a==1)?"rgb("+mathRound(bound01(this._r,255)*100)+"%, "+mathRound(bound01(this._g,255)*100)+"%, "+mathRound(bound01(this._b,255)*100)+"%)":"rgba("+mathRound(bound01(this._r,255)*100)+"%, "+mathRound(bound01(this._g,255)*100)+"%, "+mathRound(bound01(this._b,255)*100)+"%, "+this._roundA+")"},toName:function(){if(this._a===0){return"transparent"}if(this._a<1){return false}return hexNames[rgbToHex(this._r,this._g,this._b,true)]||false},toFilter:function(secondColor){var hex8String='#'+rgbaToHex(this._r,this._g,this._b,this._a);var secondHex8String=hex8String;var gradientType=this._gradientType?"GradientType = 1, ":"";if(secondColor){var s=tinycolor(secondColor);secondHex8String=s.toHex8String()}return"progid:DXImageTransform.Microsoft.gradient("+gradientType+"startColorstr="+hex8String+",endColorstr="+secondHex8String+")"},toString:function(format){var formatSet=!!format;format=format||this._format;var formattedString=false;var hasAlpha=this._a<1&&this._a>=0;var needsAlphaFormat=!formatSet&&hasAlpha&&(format==="hex"||format==="hex6"||format==="hex3"||format==="name");if(needsAlphaFormat){if(format==="name"&&this._a===0){return this.toName()}return this.toRgbString()}if(format==="rgb"){formattedString=this.toRgbString()}if(format==="prgb"){formattedString=this.toPercentageRgbString()}if(format==="hex"||format==="hex6"){formattedString=this.toHexString()}if(format==="hex3"){formattedString=this.toHexString(true)}if(format==="hex8"){formattedString=this.toHex8String()}if(format==="name"){formattedString=this.toName()}if(format==="hsl"){formattedString=this.toHslString()}if(format==="hsv"){formattedString=this.toHsvString()}return formattedString||this.toHexString()},_applyModification:function(fn,args){var color=fn.apply(null,[this].concat([].slice.call(args)));this._r=color._r;this._g=color._g;this._b=color._b;this.setAlpha(color._a);return this},lighten:function(){return this._applyModification(lighten,arguments)},brighten:function(){return this._applyModification(brighten,arguments)},darken:function(){return this._applyModification(darken,arguments)},desaturate:function(){return this._applyModification(desaturate,arguments)},saturate:function(){return this._applyModification(saturate,arguments)},greyscale:function(){return this._applyModification(greyscale,arguments)},spin:function(){return this._applyModification(spin,arguments)},_applyCombination:function(fn,args){return fn.apply(null,[this].concat([].slice.call(args)))},analogous:function(){return this._applyCombination(analogous,arguments)},complement:function(){return this._applyCombination(complement,arguments)},monochromatic:function(){return this._applyCombination(monochromatic,arguments)},splitcomplement:function(){return this._applyCombination(splitcomplement,arguments)},triad:function(){return this._applyCombination(triad,arguments)},tetrad:function(){return this._applyCombination(tetrad,arguments)}};tinycolor.fromRatio=function(color,opts){if(typeof color=="object"){var newColor={};for(var i in color){if(color.hasOwnProperty(i)){if(i==="a"){newColor[i]=color[i]}else{newColor[i]=convertToPercentage(color[i])}}}color=newColor}return tinycolor(color,opts)};function inputToRGB(color){var rgb={r:0,g:0,b:0};var a=1;var ok=false;var format=false;if(typeof color=="string"){color=stringInputToObject(color)}if(typeof color=="object"){if(color.hasOwnProperty("r")&&color.hasOwnProperty("g")&&color.hasOwnProperty("b")){rgb=rgbToRgb(color.r,color.g,color.b);ok=true;format=String(color.r).substr(-1)==="%"?"prgb":"rgb"}else if(color.hasOwnProperty("h")&&color.hasOwnProperty("s")&&color.hasOwnProperty("v")){color.s=convertToPercentage(color.s);color.v=convertToPercentage(color.v);rgb=hsvToRgb(color.h,color.s,color.v);ok=true;format="hsv"}else if(color.hasOwnProperty("h")&&color.hasOwnProperty("s")&&color.hasOwnProperty("l")){color.s=convertToPercentage(color.s);color.l=convertToPercentage(color.l);rgb=hslToRgb(color.h,color.s,color.l);ok=true;format="hsl"}if(color.hasOwnProperty("a")){a=color.a}}a=boundAlpha(a);return{ok:ok,format:color.format||format,r:mathMin(255,mathMax(rgb.r,0)),g:mathMin(255,mathMax(rgb.g,0)),b:mathMin(255,mathMax(rgb.b,0)),a:a}}function rgbToRgb(r,g,b){return{r:bound01(r,255)*255,g:bound01(g,255)*255,b:bound01(b,255)*255}}function rgbToHsl(r,g,b){r=bound01(r,255);g=bound01(g,255);b=bound01(b,255);var max=mathMax(r,g,b),min=mathMin(r,g,b);var h,s,l=(max+min)/2;if(max==min){h=s=0}else{var d=max-min;s=l>0.5?d/(2-max-min):d/(max+min);switch(max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break}h/=6}return{h:h,s:s,l:l}}function hslToRgb(h,s,l){var r,g,b;h=bound01(h,360);s=bound01(s,100);l=bound01(l,100);function hue2rgb(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p}if(s===0){r=g=b=l}else{var q=l<0.5?l*(1+s):l+s-l*s;var p=2*l-q;r=hue2rgb(p,q,h+1/3);g=hue2rgb(p,q,h);b=hue2rgb(p,q,h-1/3)}return{r:r*255,g:g*255,b:b*255}}function rgbToHsv(r,g,b){r=bound01(r,255);g=bound01(g,255);b=bound01(b,255);var max=mathMax(r,g,b),min=mathMin(r,g,b);var h,s,v=max;var d=max-min;s=max===0?0:d/max;if(max==min){h=0}else{switch(max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break}h/=6}return{h:h,s:s,v:v}}function hsvToRgb(h,s,v){h=bound01(h,360)*6;s=bound01(s,100);v=bound01(v,100);var i=math.floor(h),f=h-i,p=v*(1-s),q=v*(1-f*s),t=v*(1-(1-f)*s),mod=i%6,r=[v,q,p,p,t,v][mod],g=[t,v,v,q,p,p][mod],b=[p,p,t,v,v,q][mod];return{r:r*255,g:g*255,b:b*255}}function rgbToHex(r,g,b,allow3Char){var hex=[pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16))];if(allow3Char&&hex[0].charAt(0)==hex[0].charAt(1)&&hex[1].charAt(0)==hex[1].charAt(1)&&hex[2].charAt(0)==hex[2].charAt(1)){return hex[0].charAt(0)+hex[1].charAt(0)+hex[2].charAt(0)}return hex.join("")}function rgbaToHex(r,g,b,a){var hex=[pad2(convertDecimalToHex(a)),pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16))];return hex.join("")}tinycolor.equals=function(color1,color2){if(!color1||!color2){return false}return tinycolor(color1).toRgbString()==tinycolor(color2).toRgbString()};tinycolor.random=function(){return tinycolor.fromRatio({r:mathRandom(),g:mathRandom(),b:mathRandom()})};function desaturate(color,amount){amount=(amount===0)?0:(amount||10);var hsl=tinycolor(color).toHsl();hsl.s-=amount/100;hsl.s=clamp01(hsl.s);return tinycolor(hsl)}function saturate(color,amount){amount=(amount===0)?0:(amount||10);var hsl=tinycolor(color).toHsl();hsl.s+=amount/100;hsl.s=clamp01(hsl.s);return tinycolor(hsl)}function greyscale(color){return tinycolor(color).desaturate(100)}function lighten(color,amount){amount=(amount===0)?0:(amount||10);var hsl=tinycolor(color).toHsl();hsl.l+=amount/100;hsl.l=clamp01(hsl.l);return tinycolor(hsl)}function brighten(color,amount){amount=(amount===0)?0:(amount||10);var rgb=tinycolor(color).toRgb();rgb.r=mathMax(0,mathMin(255,rgb.r-mathRound(255*-(amount/100))));rgb.g=mathMax(0,mathMin(255,rgb.g-mathRound(255*-(amount/100))));rgb.b=mathMax(0,mathMin(255,rgb.b-mathRound(255*-(amount/100))));return tinycolor(rgb)}function darken(color,amount){amount=(amount===0)?0:(amount||10);var hsl=tinycolor(color).toHsl();hsl.l-=amount/100;hsl.l=clamp01(hsl.l);return tinycolor(hsl)}function spin(color,amount){var hsl=tinycolor(color).toHsl();var hue=(mathRound(hsl.h)+amount)%360;hsl.h=hue<0?360+hue:hue;return tinycolor(hsl)}function complement(color){var hsl=tinycolor(color).toHsl();hsl.h=(hsl.h+180)%360;return tinycolor(hsl)}function triad(color){var hsl=tinycolor(color).toHsl();var h=hsl.h;return[tinycolor(color),tinycolor({h:(h+120)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+240)%360,s:hsl.s,l:hsl.l})]}function tetrad(color){var hsl=tinycolor(color).toHsl();var h=hsl.h;return[tinycolor(color),tinycolor({h:(h+90)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+180)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+270)%360,s:hsl.s,l:hsl.l})]}function splitcomplement(color){var hsl=tinycolor(color).toHsl();var h=hsl.h;return[tinycolor(color),tinycolor({h:(h+72)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+216)%360,s:hsl.s,l:hsl.l})]}function analogous(color,results,slices){results=results||6;slices=slices||30;var hsl=tinycolor(color).toHsl();var part=360/slices;var ret=[tinycolor(color)];for(hsl.h=((hsl.h-(part*results>>1))+720)%360;--results;){hsl.h=(hsl.h+part)%360;ret.push(tinycolor(hsl))}return ret}function monochromatic(color,results){results=results||6;var hsv=tinycolor(color).toHsv();var h=hsv.h,s=hsv.s,v=hsv.v;var ret=[];var modification=1/results;while(results--){ret.push(tinycolor({h:h,s:s,v:v}));v=(v+modification)%1}return ret}tinycolor.mix=function(color1,color2,amount){amount=(amount===0)?0:(amount||50);var rgb1=tinycolor(color1).toRgb();var rgb2=tinycolor(color2).toRgb();var p=amount/100;var w=p*2-1;var a=rgb2.a-rgb1.a;var w1;if(w*a==-1){w1=w}else{w1=(w+a)/(1+w*a)}w1=(w1+1)/2;var w2=1-w1;var rgba={r:rgb2.r*w1+rgb1.r*w2,g:rgb2.g*w1+rgb1.g*w2,b:rgb2.b*w1+rgb1.b*w2,a:rgb2.a*p+rgb1.a*(1-p)};return tinycolor(rgba)};tinycolor.readability=function(color1,color2){var c1=tinycolor(color1);var c2=tinycolor(color2);var rgb1=c1.toRgb();var rgb2=c2.toRgb();var brightnessA=c1.getBrightness();var brightnessB=c2.getBrightness();var colorDiff=(Math.max(rgb1.r,rgb2.r)-Math.min(rgb1.r,rgb2.r)+Math.max(rgb1.g,rgb2.g)-Math.min(rgb1.g,rgb2.g)+Math.max(rgb1.b,rgb2.b)-Math.min(rgb1.b,rgb2.b));return{brightness:Math.abs(brightnessA-brightnessB),color:colorDiff}};tinycolor.isReadable=function(color1,color2){var readability=tinycolor.readability(color1,color2);return readability.brightness>125&&readability.color>500};tinycolor.mostReadable=function(baseColor,colorList){var bestColor=null;var bestScore=0;var bestIsReadable=false;for(var i=0;i<colorList.length;i++){var readability=tinycolor.readability(baseColor,colorList[i]);var readable=readability.brightness>125&&readability.color>500;var score=3*(readability.brightness/125)+(readability.color/500);if((readable&&!bestIsReadable)||(readable&&bestIsReadable&&score>bestScore)||((!readable)&&(!bestIsReadable)&&score>bestScore)){bestIsReadable=readable;bestScore=score;bestColor=tinycolor(colorList[i])}}return bestColor};var names=tinycolor.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};var hexNames=tinycolor.hexNames=flip(names);function flip(o){var flipped={};for(var i in o){if(o.hasOwnProperty(i)){flipped[o[i]]=i}}return flipped}function boundAlpha(a){a=parseFloat(a);if(isNaN(a)||a<0||a>1){a=1}return a}function bound01(n,max){if(isOnePointZero(n)){n="100%"}var processPercent=isPercentage(n);n=mathMin(max,mathMax(0,parseFloat(n)));if(processPercent){n=parseInt(n*max,10)/100}if((math.abs(n-max)<0.000001)){return 1}return(n%max)/parseFloat(max)}function clamp01(val){return mathMin(1,mathMax(0,val))}function parseIntFromHex(val){return parseInt(val,16)}function isOnePointZero(n){return typeof n=="string"&&n.indexOf('.')!=-1&&parseFloat(n)===1}function isPercentage(n){return typeof n==="string"&&n.indexOf('%')!=-1}function pad2(c){return c.length==1?'0'+c:''+c}function convertToPercentage(n){if(n<=1){n=(n*100)+"%"}return n}function convertDecimalToHex(d){return Math.round(parseFloat(d)*255).toString(16)}function convertHexToDecimal(h){return(parseIntFromHex(h)/255)}var matchers=(function(){var CSS_INTEGER="[-\\+]?\\d+%?";var CSS_NUMBER="[-\\+]?\\d*\\.\\d+%?";var CSS_UNIT="(?:"+CSS_NUMBER+")|(?:"+CSS_INTEGER+")";var PERMISSIVE_MATCH3="[\\s|\\(]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")\\s*\\)?";var PERMISSIVE_MATCH4="[\\s|\\(]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")\\s*\\)?";return{rgb:new RegExp("rgb"+PERMISSIVE_MATCH3),rgba:new RegExp("rgba"+PERMISSIVE_MATCH4),hsl:new RegExp("hsl"+PERMISSIVE_MATCH3),hsla:new RegExp("hsla"+PERMISSIVE_MATCH4),hsv:new RegExp("hsv"+PERMISSIVE_MATCH3),hsva:new RegExp("hsva"+PERMISSIVE_MATCH4),hex3:/^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex8:/^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/}})();function stringInputToObject(color){color=color.replace(trimLeft,'').replace(trimRight,'').toLowerCase();var named=false;if(names[color]){color=names[color];named=true}else if(color=='transparent'){return{r:0,g:0,b:0,a:0,format:"name"}}var match;if((match=matchers.rgb.exec(color))){return{r:match[1],g:match[2],b:match[3]}}if((match=matchers.rgba.exec(color))){return{r:match[1],g:match[2],b:match[3],a:match[4]}}if((match=matchers.hsl.exec(color))){return{h:match[1],s:match[2],l:match[3]}}if((match=matchers.hsla.exec(color))){return{h:match[1],s:match[2],l:match[3],a:match[4]}}if((match=matchers.hsv.exec(color))){return{h:match[1],s:match[2],v:match[3]}}if((match=matchers.hsva.exec(color))){return{h:match[1],s:match[2],v:match[3],a:match[4]}}if((match=matchers.hex8.exec(color))){return{a:convertHexToDecimal(match[1]),r:parseIntFromHex(match[2]),g:parseIntFromHex(match[3]),b:parseIntFromHex(match[4]),format:named?"name":"hex8"}}if((match=matchers.hex6.exec(color))){return{r:parseIntFromHex(match[1]),g:parseIntFromHex(match[2]),b:parseIntFromHex(match[3]),format:named?"name":"hex"}}if((match=matchers.hex3.exec(color))){return{r:parseIntFromHex(match[1]+''+match[1]),g:parseIntFromHex(match[2]+''+match[2]),b:parseIntFromHex(match[3]+''+match[3]),format:named?"name":"hex"}}return false}window.tinycolor=tinycolor})();$(function(){if($.fn.spectrum.load){$.fn.spectrum.processNativeColorInputs()}})});
/*!
 * jQeury Table row sorter
 */
(function(e,c){var h=c(e.document),i=!!("ontouchstart" in h[0].documentElement),d=i?"touchstart":"mousedown",f=i?"touchend":"mouseup",g=!!("onselectstart" in h[0].documentElement),j=false,b={handler:"tbody > tr",tableDragClass:"sorting-table",disabledRowClass:"nodrag",dragClass:"sorting-row",onDragStart:null,onDrop:null};if(g){h[0].onselectstart=function(){if(j){return false}}}function a(u,w){var m=c.extend({},b,w),n=null,v=null,q=null,r=0,o=0;u=c(u);if(u.is("table")===false){throw new Error("Specified parameter is not a table.")}if(u.data("row-sorter-attached")!==true){u.on(d,m.handler,t);u.data("row-sorter-attached",true)}function t(x){n=u.find("tbody");n=n.length>0?n:u;v=n.find("tr");if(v.length<2){return true}q=c(this).closest("tr");if(q.length===0){return true}if(q.hasClass(m.disabledRowClass)){return true}j=true;o=v.index(q[0]);if(m.dragClass){q.addClass(m.dragClass)}if(m.tableDragClass){u.addClass(m.tableDragClass)}if(typeof m.onDragStart==="function"){m.onDragStart(n[0],q[0],o)}if(i){r=parseInt(x.originalEvent.touches[0].pageY,10);h.on("touchmove",k)}else{r=parseInt(x.pageY,10);v.not(q[0]).on("mousemove",p)}h.on(f,s);x.preventDefault();return false}function k(x){var z=x.originalEvent.touches[0],y=h[0].elementFromPoint(z.clientX,z.clientY);if(!y){return true}y=c(y).closest("tr");if(y&&y[0]!==q[0]&&y[0].parentNode===n[0]){l(y[0],z.pageY)}}function p(x){l(this,x.pageY)}function l(y,x){if(x>r&&y.nextSibling!==q[0]){if(y.nextSibling){n[0].insertBefore(q[0],y.nextSibling)}else{n[0].appendChild(q[0])}}else{if(x<=r&&y.previousSibling!==q[0]){n[0].insertBefore(q[0],y)}}r=x}function s(){var x;if(i){h.off("touchmove",k)}else{v.off("mousemove",p)}h.off(f,s);if(m.dragClass){q.removeClass(m.dragClass)}if(m.tableDragClass){u.removeClass(m.tableDragClass)}x=n.find("tr").index(q[0]);if(x!==o){if(typeof m.onDrop==="function"){m.onDrop(n[0],q[0],x,o)}}q=null;j=false;o=0}}c.fn.extend({rowSorter:function(k){this.each(function(l,m){a(m,k)})}})})(this,this.jQuery);
/*
 * Notices
 */
(function($){$.notice=function(note,options,callback){return $.fn.notice(note,options,callback)};$.fn.notice=function(note,options,callback){var settings={duplicates:true,autoclose:5000,title:"",type:""};if(!note){note=this.html()}if(options){$.extend(settings,options)}var display=true;var duplicate="no";var uniqID=Math.floor(Math.random()*99999);$(".sticky-note").each(function(){if($(this).html()==note&&$(this).is(":visible")){duplicate="yes";if(!settings.duplicates){display=false}}if($(this).attr("id")==uniqID){uniqID=Math.floor(Math.random()*9999999)}});if(!$("body").find("#wojo-overlay").html()){$("body").append('<div id="wojo-overlay"></div>')}if(display){$("#wojo-overlay").prepend('<div class="transition hidden wojo notice '+settings.type+'" id="'+uniqID+'"></div>');$("#"+uniqID).append('<div class="wojo attached transparent progress" data-value="100" data-total="100"><div class="bar"></div></div><div class="content"><span>'+settings.title+'</span><a class="notice-close" data-id="'+uniqID+'"title="Close"><i class="icon delete"></i></a><p class="sticky-note" data-id="'+uniqID+'">'+note+"</p></div>");$("#"+uniqID).transition('drop');$("#"+uniqID+' .progress').progress({duration:settings.autoclose,total:100});display=true}$(".wojo.notice").ready(function(){if(settings.autoclose){setTimeout(function(){$("#"+uniqID).transition('vertical flip')},settings.autoclose)}});$(".wojo.notice").click(function(){$(this).dequeue().transition({animation:'slide left',onComplete:function(){$("#"+uniqID).remove()}})});var response={id:uniqID,duplicate:duplicate,displayed:display,type:settings.type,title:settings.title};if(callback){callback(response)}else{return(response)}}})(jQuery);
/* 
Password Generator
*/
$.extend({password:function(length,special){var iteration=0;var password="";var randomNumber;if(special==undefined){var special=false}while(iteration<length){randomNumber=(Math.floor((Math.random()*100))%94)+33;if(!special){if((randomNumber>=33)&&(randomNumber<=47)){continue}if((randomNumber>=58)&&(randomNumber<=64)){continue}if((randomNumber>=91)&&(randomNumber<=96)){continue}if((randomNumber>=123)&&(randomNumber<=126)){continue}}iteration++;password+=String.fromCharCode(randomNumber)}return password}});
/* 
http://jquery.github.io/Stupid-Table-Plugin/ 
*/
(function($){$.fn.tablesort=function(sortFns){return this.each(function(){var $table=$(this);sortFns=sortFns||{};sortFns=$.extend({},$.fn.tablesort.default_sort_fns,sortFns);$table.on("click.tablesort","th",function(){var $this=$(this);var th_index=0;var dir=$.fn.tablesort.dir;$table.find("th").slice(0,$this.index()).each(function(){var cols=$(this).attr("colspan")||1;th_index+=parseInt(cols,10);});var sort_dir=$this.data("sort-default")||dir.ASC;if($this.data("sort-dir"))
sort_dir=$this.data("sort-dir")===dir.ASC?dir.DESC:dir.ASC;var type=$this.data("sort")||null;if(type===null){return;}
$table.trigger("beforetablesort",{column:th_index,direction:sort_dir});$table.css("display");setTimeout(function(){var column=[];var sortMethod=sortFns[type];var trs=$table.children("tbody").children("tr");trs.each(function(index,tr){var $e=$(tr).children().eq(th_index);var sort_val=$e.data("sort-value");var order_by=typeof(sort_val)!=="undefined"?sort_val:$e.text();column.push([order_by,tr]);});column.sort(function(a,b){return sortMethod(a[0],b[0]);});if(sort_dir!=dir.ASC)
column.reverse();trs=$.map(column,function(kv){return kv[1];});$table.children("tbody").append(trs);$table.find("th").data("sort-dir",null).removeClass("desc asc");$this.data("sort-dir",sort_dir).addClass(sort_dir);$table.trigger("aftertablesort",{column:th_index,direction:sort_dir});$table.css("display");},10);});});};$.fn.tablesort.dir={ASC:"asc",DESC:"desc"};$.fn.tablesort.default_sort_fns={"int":function(a,b){return parseInt(a,10)-parseInt(b,10);},"float":function(a,b){return parseFloat(a)-parseFloat(b);},"string":function(a,b){if(a<b)return-1;if(a>b)return+1;return 0;},"string-ins":function(a,b){a=a.toLowerCase();b=b.toLowerCase();if(a<b)return-1;if(a>b)return+1;return 0;}};})(jQuery);
/*
 * Purl (A JavaScript URL parser) v2.3.1
 * Developed and maintanined by Mark Perkins, mark@allmarkedup.com
 * Source repository: https://github.com/allmarkedup/jQuery-URL-Parser
 */
(function(a){if(typeof define==='function'&&define.amd){define(a)}else{window.purl=a()}})(function(){var g={a:'href',img:'src',form:'action',base:'href',script:'src',iframe:'src',link:'href',embed:'src',object:'data'},key=['source','protocol','authority','userInfo','user','password','host','port','relative','path','directory','file','query','fragment'],aliases={'anchor':'fragment'},parser={strict:/^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,loose:/^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/},isint=/^[0-9]+$/;function parseUri(a,b){var c=decodeURI(a),res=parser[b||false?'strict':'loose'].exec(c),uri={attr:{},param:{},seg:{}},i=14;while(i--){uri.attr[key[i]]=res[i]||''}uri.param['query']=parseString(uri.attr['query']);uri.param['fragment']=parseString(uri.attr['fragment']);uri.seg['path']=uri.attr.path.replace(/^\/+|\/+$/g,'').split('/');uri.seg['fragment']=uri.attr.fragment.replace(/^\/+|\/+$/g,'').split('/');uri.attr['base']=uri.attr.host?(uri.attr.protocol?uri.attr.protocol+'://'+uri.attr.host:uri.attr.host)+(uri.attr.port?':'+uri.attr.port:''):'';return uri}function getAttrName(a){var b=a.tagName;if(typeof b!=='undefined')return g[b.toLowerCase()];return b}function promote(a,b){if(a[b].length===0)return a[b]={};var t={};for(var i in a[b])t[i]=a[b][i];a[b]=t;return t}function parse(a,b,c,d){var e=a.shift();if(!e){if(isArray(b[c])){b[c].push(d)}else if('object'==typeof b[c]){b[c]=d}else if('undefined'==typeof b[c]){b[c]=d}else{b[c]=[b[c],d]}}else{var f=b[c]=b[c]||[];if(']'==e){if(isArray(f)){if(''!==d)f.push(d)}else if('object'==typeof f){f[keys(f).length]=d}else{f=b[c]=[b[c],d]}}else if(~e.indexOf(']')){e=e.substr(0,e.length-1);if(!isint.test(e)&&isArray(f))f=promote(b,c);parse(a,f,e,d)}else{if(!isint.test(e)&&isArray(f))f=promote(b,c);parse(a,f,e,d)}}}function merge(a,b,c){if(~b.indexOf(']')){var d=b.split('[');parse(d,a,'base',c)}else{if(!isint.test(b)&&isArray(a.base)){var t={};for(var k in a.base)t[k]=a.base[k];a.base=t}if(b!==''){set(a.base,b,c)}}return a}function parseString(d){return reduce(String(d).split(/&|;/),function(a,b){try{b=decodeURIComponent(b.replace(/\+/g,' '))}catch(e){}var c=b.indexOf('='),brace=lastBraceInKey(b),key=b.substr(0,brace||c),val=b.substr(brace||c,b.length);val=val.substr(val.indexOf('=')+1,val.length);if(key===''){key=b;val=''}return merge(a,key,val)},{base:{}}).base}function set(a,b,c){var v=a[b];if(typeof v==='undefined'){a[b]=c}else if(isArray(v)){v.push(c)}else{a[b]=[v,c]}}function lastBraceInKey(a){var b=a.length,brace,c;for(var i=0;i<b;++i){c=a[i];if(']'==c)brace=false;if('['==c)brace=true;if('='==c&&!brace)return i}}function reduce(a,b){var i=0,l=a.length>>0,curr=arguments[2];while(i<l){if(i in a)curr=b.call(undefined,curr,a[i],i,a);++i}return curr}function isArray(a){return Object.prototype.toString.call(a)==="[object Array]"}function keys(a){var b=[];for(var c in a){if(a.hasOwnProperty(c))b.push(c)}return b}function purl(b,c){if(arguments.length===1&&b===true){c=true;b=undefined}c=c||false;b=b||window.location.toString();return{data:parseUri(b,c),attr:function(a){a=aliases[a]||a;return typeof a!=='undefined'?this.data.attr[a]:this.data.attr},param:function(a){return typeof a!=='undefined'?this.data.param.query[a]:this.data.param.query},fparam:function(a){return typeof a!=='undefined'?this.data.param.fragment[a]:this.data.param.fragment},segment:function(a){if(typeof a==='undefined'){return this.data.seg.path}else{a=a<0?this.data.seg.path.length+a:a-1;return this.data.seg.path[a]}},fsegment:function(a){if(typeof a==='undefined'){return this.data.seg.fragment}else{a=a<0?this.data.seg.fragment.length+a:a-1;return this.data.seg.fragment[a]}}}}purl.jQuery=function($){if($!=null){$.fn.url=function(a){var b='';if(this.length){b=$(this).attr(getAttrName(this[0]))||''}return purl(b,a)};$.url=purl}};purl.jQuery(window.jQuery);return purl});
/*
Responsive Tables
*/
(function($){$.fn.responsiveTable=function(options){var setup=function(table,data){var headings=[];if(data.tableWrap){table.wrap('<div class="bt-wrapper"></div>')}var format='';if(table.find('thead tr th').length){format='thead th'}else if(table.find('tbody tr th').length){format='tbody tr th'}else if(table.find('th').length){format='tr:first th'}else{format='tr:first td'}$.each(table.find(format),function(){var $heading=$(this);var colspan=parseInt($heading.attr('colspan'),10)||1;var row=$heading.closest('tr').index();if(!headings[row]){headings[row]=[]}for(var i=0;i<colspan;i++){headings[row].push($heading)}});$.each(table.find('tbody tr'),function(){setupRow($(this),headings,data)});$.each(table.find('tfoot tr'),function(){setupRow($(this),headings,data)})};var setupRow=function($row,headings,data){$row.children().each(function(){var $cell=$(this);if(($cell.html()===''||$cell.html()==='&nbsp;')&&(!data.showEmptyCells)){$cell.addClass('bt-hide')}else{var cellIndex=$cell.index();var headingText='';for(var j=0;j<headings.length;j++){if(j!=0){headingText+=': '}var $heading=headings[j][cellIndex];headingText+=$heading.text()}$cell.attr('data-th',headingText);if(data.contentWrap&&!$cell.children().hasClass('bt-content')){$cell.wrapInner('<div class="bt-content" />')}}})};var unwrap=function(table){$.each(table.find('td'),function(){var $cell=$(this);var content=$cell.children('.bt-content').html();$cell.html(content)})};var check=function(table,data){if(!data.forceResponsive){if(table.removeClass('bt').outerWidth()>table.parent().width()){start(table,data)}else{end(table,data)}}else{if($(window).width()<=data.breakpoint){start(table,data)}else{end(table,data)}}};var start=function(table,data){table.addClass('bt');if(data.tableWrap){table.parent('.bt-wrapper').addClass('active')}};var end=function(table,data){table.removeClass('bt');if(data.tableWrap){table.parent('.bt-wrapper').removeClass('active')}};var destroy=function(table,data){table.find('td').removeAttr('data-th');if(data.tableWrap){table.unwrap()}if(data.contentWrap){unwrap(table)}table.removeData('responsiveTable')};var resize=function(table){if(table.data('responsiveTable')){check(table,table.data('responsiveTable'))}};this.each(function(){var table=$(this);if(table.length===0||table.data('responsiveTable')){if(table.data('responsiveTable')){if(options=='destroy'){destroy(table,table.data('responsiveTable'))}else if(options==='start'){start(table,table.data('responsiveTable'))}else if(options==='stop'){end(table,table.data('responsiveTable'))}else{check(table,table.data('responsiveTable'))}}return false}var settings=$.extend({},$.fn.responsiveTable.defaults,options);var vars={breakpoint:settings.breakpoint,contentWrap:settings.contentWrap,forceResponsive:settings.forceResponsive,noResize:settings.noResize,tableWrap:settings.tableWrap,showEmptyCells:settings.showEmptyCells};table.data('responsiveTable',vars);setup(table,table.data('responsiveTable'));if(!vars.noResize){check(table,table.data('responsiveTable'));$(window).bind('resize.responsiveTable',function(){resize(table)})}})};$.fn.responsiveTable.defaults={breakpoint:769,contentWrap:true,forceResponsive:true,noResize:false,tableWrap:true,showEmptyCells:true}})(jQuery);
/*
Responsive Tabs
*/
$(function(){var $nav=$('.wojo.tab.wrap');var $btn=$('.wojo.tab.wrap button');var $vlinks=$('.wojo.tab.wrap .tabs');var $hlinks=$('.wojo.tab.wrap .hidden-links');var numOfItems=0;var totalSpace=0;var breakWidths=[];$vlinks.children().outerWidth(function(i,w){totalSpace+=w;numOfItems+=1;breakWidths.push(totalSpace)});var availableSpace,numOfVisibleItems,requiredSpace;function resize(){availableSpace=$vlinks.width()-10;numOfVisibleItems=$vlinks.children().length;requiredSpace=breakWidths[numOfVisibleItems-1];if(requiredSpace>availableSpace){$vlinks.children().last().prependTo($hlinks);numOfVisibleItems-=1;resize()}else if(availableSpace>breakWidths[numOfVisibleItems]){$hlinks.children().first().appendTo($vlinks);numOfVisibleItems+=1}$btn.attr("count",numOfItems-numOfVisibleItems);if(numOfVisibleItems===numOfItems){$btn.addClass('hidden')}else $btn.removeClass('hidden')}$(window).on('resize',resize.bind(this));$(window).trigger('resize');$btn.on('click',function(){$hlinks.toggleClass('hidden')});resize()});
/**
 * asRange v0.3.4
 * https://github.com/amazingSurge/jquery-asRange
 */
(function(a,b){if(typeof define==='function'&&define.amd){define(['jquery'],b)}else if(typeof exports!=='undefined'){b(require('jquery'))}else{var c={exports:{}};b(a.jQuery);a.jqueryAsRangeEs=c.exports}})(this,function(k){'use strict';var l=_interopRequireDefault(k);function _interopRequireDefault(a){return a&&a.__esModule?a:{default:a}}var m=typeof Symbol==='function'&&typeof Symbol.iterator==='symbol'?function(a){return typeof a}:function(a){return a&&typeof Symbol==='function'&&a.constructor===Symbol&&a!==Symbol.prototype?'symbol':typeof a};function _classCallCheck(a,b){if(!(a instanceof b)){throw new TypeError('Cannot call a class as a function');}}var n=(function(){function defineProperties(a,b){for(var i=0;i<b.length;i++){var c=b[i];c.enumerable=c.enumerable||false;c.configurable=true;if('value'in c)c.writable=true;Object.defineProperty(a,c.key,c)}}return function(a,b,c){if(b)defineProperties(a.prototype,b);if(c)defineProperties(a,c);return a}})();var o={namespace:'asRange',skin:null,max:100,min:0,value:null,step:10,limit:true,range:false,direction:'h',keyboard:true,replaceFirst:false,tip:true,format:function format(a){return a}};function getEventObject(a){var e=a.originalEvent;if(e.touches&&e.touches.length&&e.touches[0]){e=e.touches[0]}return e}var q=(function(){function q(a,b,c){_classCallCheck(this,q);this.$element=a;this.uid=b;this.parent=c;this.options=l.default.extend(true,{},this.parent.options);this.direction=this.options.direction;this.value=null;this.classes={active:this.parent.namespace+'-pointer_active'}}n(q,[{key:'mousedown',value:function mousedown(d){var e=this.parent.direction.axis;var f=this.parent.direction.position;var g=this.parent.$wrap.offset();this.$element.trigger(this.parent.namespace+'::moveStart',this);this.data={};this.data.start=d[e];this.data.position=d[e]-g[f];var h=this.parent.getValueFromPosition(this.data.position);this.set(h);l.default.each(this.parent.pointer,function(i,p){p.deactive()});this.active();this.mousemove=function(a){var b=getEventObject(a);var c=this.parent.getValueFromPosition(this.data.position+(b[e]||this.data.start)-this.data.start);this.set(c);a.preventDefault();return false};this.mouseup=function(){(0,l.default)(document).off('.asRange mousemove.asRange touchend.asRange mouseup.asRange touchcancel.asRange');this.$element.trigger(this.parent.namespace+'::moveEnd',this);return false};(0,l.default)(document).on('touchmove.asRange mousemove.asRange',l.default.proxy(this.mousemove,this)).on('touchend.asRange mouseup.asRange',l.default.proxy(this.mouseup,this));return false}},{key:'active',value:function active(){this.$element.addClass(this.classes.active)}},{key:'deactive',value:function deactive(){this.$element.removeClass(this.classes.active)}},{key:'set',value:function set(a){if(this.value===a){return}if(this.parent.step){a=this.matchStep(a)}if(this.options.limit===true){a=this.matchLimit(a)}else{if(a<=this.parent.min){a=this.parent.min}if(a>=this.parent.max){a=this.parent.max}}this.value=a;this.updatePosition();this.$element.focus();this.$element.trigger(this.parent.namespace+'::move',this)}},{key:'updatePosition',value:function updatePosition(){var a={};a[this.parent.direction.position]=this.getPercent()+'%';this.$element.css(a)}},{key:'getPercent',value:function getPercent(){return(this.value-this.parent.min)/this.parent.interval*100}},{key:'get',value:function get(){return this.value}},{key:'matchStep',value:function matchStep(a){var b=this.parent.step;var c=b.toString().split('.')[1];a=Math.round(a/b)*b;if(c){a=a.toFixed(c.length)}return parseFloat(a)}},{key:'matchLimit',value:function matchLimit(a){var b=void 0;var c=void 0;var d=this.parent.pointer;if(this.uid===1){b=this.parent.min}else{b=d[this.uid-2].value}if(d[this.uid]&&d[this.uid].value!==null){c=d[this.uid].value}else{c=this.parent.max}if(a<=b){a=b}if(a>=c){a=c}return a}},{key:'destroy',value:function destroy(){this.$element.off('.asRange');this.$element.remove()}}]);return q})();var r={defaults:{},init:function init(c){var d=this;this.$arrow=(0,l.default)('<span></span>').appendTo(c.$wrap);this.$arrow.addClass(c.namespace+'-selected');if(c.options.range===false){c.p1.$element.on(c.namespace+'::move',function(e,a){d.$arrow.css({left:0,width:a.getPercent()+'%'})})}if(c.options.range===true){var f=function f(){var a=c.p2.getPercent()-c.p1.getPercent();var b=void 0;if(a>=0){b=c.p1.getPercent()}else{a=-a;b=c.p2.getPercent()}d.$arrow.css({left:b+'%',width:a+'%'})};c.p1.$element.on(c.namespace+'::move',f);c.p2.$element.on(c.namespace+'::move',f)}}};var s={defaults:{active:'always'},init:function init(d){var e=this;var f=l.default.extend({},this.defaults,d.options.tip);this.opts=f;this.classes={tip:d.namespace+'-tip',show:d.namespace+'-tip-show'};l.default.each(d.pointer,function(i,p){var c=(0,l.default)('<span></span>').appendTo(d.pointer[i].$element);c.addClass(e.classes.tip);if(e.opts.active==='onMove'){c.css({display:'none'});p.$element.on(d.namespace+'::moveEnd',function(){e.hide(c);return false}).on(d.namespace+'::moveStart',function(){e.show(c);return false})}p.$element.on(d.namespace+'::move',function(){var a=void 0;if(d.options.range){a=d.get()[i]}else{a=d.get()}if(typeof d.options.format==='function'){if(d.options.replaceFirst&&typeof a!=='number'){if(typeof d.options.replaceFirst==='string'){a=d.options.replaceFirst}if(m(d.options.replaceFirst)==='object'){for(var b in d.options.replaceFirst){if(Object.hasOwnProperty(d.options.replaceFirst,b)){a=d.options.replaceFirst[b]}}}}else{a=d.options.format(a)}}c.text(a);$(this).parent().find('.'+d.namespace+'-label').text(a);return false})})},show:function show(a){a.addClass(this.classes.show);a.css({display:'block'})},hide:function hide(a){a.removeClass(this.classes.show);a.css({display:'none'})}};var t=function t(){var j=(0,l.default)(document);j.on('asRange::ready',function(d,f){var g=void 0;var h={keys:{UP:38,DOWN:40,LEFT:37,RIGHT:39,RETURN:13,ESCAPE:27,BACKSPACE:8,SPACE:32},map:{},bound:false,press:function press(e){var a=e.keyCode||e.which;if(a in h.map&&typeof h.map[a]==='function'){h.map[a](e);return false}},attach:function attach(a){var b=void 0;var c=void 0;for(b in a){if(a.hasOwnProperty(b)){c=b.toUpperCase();if(c in h.keys){h.map[h.keys[c]]=a[b]}else{h.map[c]=a[b]}}}if(!h.bound){h.bound=true;j.bind('keydown',h.press)}},detach:function detach(){h.bound=false;h.map={};j.unbind('keydown',h.press)}};if(f.options.keyboard===true){l.default.each(f.pointer,function(i,p){if(f.options.step){g=f.options.step}else{g=1}var b=function b(){var a=p.value;p.set(a-g)};var c=function c(){var a=p.value;p.set(a+g)};p.$element.attr('tabindex','0').on('focus',function(){h.attach({left:b,right:c});return false}).on('blur',function(){h.detach();return false})})}})};var u={};var v=(function(){function v(d,e){var f=this;_classCallCheck(this,v);var g={};this.element=d;this.$element=(0,l.default)(d);if(this.$element.is('input')){var h=this.$element.val();if(typeof h==='string'){g.value=h.split(',')}l.default.each(['min','max','step'],function(a,b){var c=parseFloat(f.$element.attr(b));if(!isNaN(c)){g[b]=c}});this.$element.css({display:'none'});this.$wrap=(0,l.default)('<div></div>');this.$element.after(this.$wrap)}else{this.$wrap=this.$element}this.options=l.default.extend({},o,e,this.$element.data(),g);this.namespace=this.options.namespace;this.components=l.default.extend(true,{},u);if(this.options.range){this.options.replaceFirst=false}this.value=this.options.value;if(this.value===null){this.value=this.options.min}if(!this.options.range){if(l.default.isArray(this.value)){this.value=this.value[0]}}else if(!l.default.isArray(this.value)){this.value=[this.value,this.value]}else if(this.value.length===1){this.value[1]=this.value[0]}this.min=this.options.min;this.max=this.options.max;this.step=this.options.step;this.interval=this.max-this.min;this.initialized=false;this.updating=false;this.disabled=false;if(this.options.direction==='v'){this.direction={axis:'pageY',position:'top'}}else{this.direction={axis:'pageX',position:'left'}}this.$wrap.addClass(this.namespace);if(this.options.skin){this.$wrap.addClass(this.namespace+'_'+this.options.skin)}if(this.max<this.min||this.step>=this.interval){throw new Error('error options about max min step');}this.init()}n(v,[{key:'init',value:function init(){this.$wrap.append('<span class="'+this.namespace+'-label" />');this.$wrap.append('<div class="'+this.namespace+'-bar" />');this.buildPointers();this.components.selected.init(this);if(this.options.tip!==false){this.components.tip.init(this)}this.set(this.value);this.bindEvents();this._trigger('ready');this.initialized=true}},{key:'_trigger',value:function _trigger(b){for(var c=arguments.length,params=Array(c>1?c-1:0),_key=1;_key<c;_key++){params[_key-1]=arguments[_key]}var d=[this].concat(params);this.$element.trigger(this.namespace+'::'+b,d);b=b.replace(/\b\w+\b/g,function(a){return a.substring(0,1).toUpperCase()+a.substring(1)});var e='on'+b;if(typeof this.options[e]==='function'){this.options[e].apply(this,params)}}},{key:'buildPointers',value:function buildPointers(){this.pointer=[];var a=1;if(this.options.range){a=2}for(var i=1;i<=a;i++){var b=(0,l.default)('<div class="'+this.namespace+'-pointer '+this.namespace+'-pointer-'+i+'"></div>').appendTo(this.$wrap);var p=new q(b,i,this);this.pointer.push(p)}this.p1=this.pointer[0];if(this.options.range){this.p2=this.pointer[1]}}},{key:'bindEvents',value:function bindEvents(){var e=this;var f=this;this.$wrap.on('touchstart.asRange mousedown.asRange',function(a){if(f.disabled===true){return}a=getEventObject(a);var b=a.which?a.which===3:a.button===2;if(b){return false}var c=f.$wrap.offset();var d=a[f.direction.axis]-c[f.direction.position];var p=f.getAdjacentPointer(d);p.mousedown(a);return false});if(this.$element.is('input')){this.$element.on(this.namespace+'::change',function(){var a=e.get();e.$element.val(a)})}l.default.each(this.pointer,function(i,p){p.$element.on(e.namespace+'::move',function(){f.value=f.get();if(!f.initialized||f.updating){return false}f._trigger('change',f.value);return false})})}},{key:'getValueFromPosition',value:function getValueFromPosition(a){if(a>0){return this.min+a/this.getLength()*this.interval}return 0}},{key:'getAdjacentPointer',value:function getAdjacentPointer(a){var b=this.getValueFromPosition(a);if(this.options.range){var c=this.p1.value;var d=this.p2.value;var e=Math.abs(c-d);if(c<=d){if(b>c+e/2){return this.p2}return this.p1}if(b>d+e/2){return this.p1}return this.p2}return this.p1}},{key:'getLength',value:function getLength(){if(this.options.direction==='v'){return this.$wrap.height()}return this.$wrap.width()}},{key:'update',value:function update(c){var d=this;this.updating=true;l.default.each(['max','min','step','limit','value'],function(a,b){if(c[b]){d[b]=c[b]}});if(c.max||c.min){this.setInterval(c.min,c.max)}if(!c.value){this.value=c.min}l.default.each(this.components,function(a,b){if(typeof b.update==='function'){b.update(d)}});this.set(this.value);this._trigger('update');this.updating=false}},{key:'get',value:function get(){var a=[];l.default.each(this.pointer,function(i,p){a[i]=p.get()});if(this.options.range){return a}if(a[0]===this.options.min){if(typeof this.options.replaceFirst==='string'){a[0]=this.options.replaceFirst}if(m(this.options.replaceFirst)==='object'){for(var b in this.options.replaceFirst){if(Object.hasOwnProperty(this.options.replaceFirst,b)){a[0]=b}}}}return a[0]}},{key:'set',value:function set(a){if(this.options.range){if(typeof a==='number'){a=[a]}if(!l.default.isArray(a)){return}l.default.each(this.pointer,function(i,p){p.set(a[i])})}else{this.p1.set(a)}this.value=a}},{key:'val',value:function val(a){if(a){this.set(a);return this}return this.get()}},{key:'setInterval',value:function setInterval(a,b){this.min=a;this.max=b;this.interval=b-a}},{key:'enable',value:function enable(){this.disabled=false;this.$wrap.removeClass(this.namespace+'_disabled');this._trigger('enable');return this}},{key:'disable',value:function disable(){this.disabled=true;this.$wrap.addClass(this.namespace+'_disabled');this._trigger('disable');return this}},{key:'destroy',value:function destroy(){l.default.each(this.pointer,function(i,p){p.destroy()});this.$wrap.destroy();this._trigger('destroy')}}],[{key:'registerComponent',value:function registerComponent(a,b){u[a]=b}},{key:'setDefaults',value:function setDefaults(a){l.default.extend(o,l.default.isPlainObject(a)&&a)}}]);return v})();v.registerComponent('selected',r);v.registerComponent('tip',s);t();var w={version:'0.3.4'};var x='asRange';var y=l.default.fn.asRange;function jQueryAsRange(b){for(var c=arguments.length,args=Array(c>1?c-1:0),_key2=1;_key2<c;_key2++){args[_key2-1]=arguments[_key2]}if(typeof b==='string'){var d=b;if(/^_/.test(d)){return false}else if(/^(get)$/.test(d)||(d==='val'&&args.length===0)){var e=this.first().data(x);if(e&&typeof e[d]==='function'){return e[d].apply(e,args)}}else{return this.each(function(){var a=l.default.data(this,x);if(a&&typeof a[d]==='function'){a[d].apply(a,args)}})}}return this.each(function(){if(!(0,l.default)(this).data(x)){(0,l.default)(this).data(x,new v(this,b))}})}l.default.fn.asRange=jQueryAsRange;l.default.asRange=l.default.extend({setDefaults:v.setDefaults,noConflict:function noConflict(){l.default.fn.asRange=y;return jQueryAsRange}},w)});
/**!
 * Sortable
 * @author	RubaXa   <trash@rubaxa.org>
 * @license MIT
 */
(function(a){"use strict";if(typeof define==="function"&&define.amd){define(a)}else if(typeof module!="undefined"&&typeof module.exports!="undefined"){module.exports=a()}else if(typeof Package!=="undefined"){Sortables=a()}else{window["Sortables"]=a()}})(function(){"use strict";if(typeof window=="undefined"||typeof window.document=="undefined"){return function(){throw new Error("Sortables.js requires a window with a document");}}var j,parentEl,ghostEl,cloneEl,rootEl,nextEl,scrollEl,scrollParentEl,lastEl,lastCSS,lastParentCSS,oldIndex,newIndex,activeGroup,autoScroll={},tapEvt,touchEvt,moved,RSPACE=/\s+/g,expando='Sortables'+(new Date).getTime(),win=window,document=win.document,parseInt=win.parseInt,supportDraggable=!!('draggable'in document.createElement('div')),supportCssPointerEvents=(function(a){a=document.createElement('x');a.style.cssText='pointer-events:auto';return a.style.pointerEvents==='auto'})(),_silent=false,abs=Math.abs,slice=[].slice,touchDragOverListeners=[],_autoScroll=_throttle(function(a,b,c){if(c&&b.scroll){var d,rect,sens=b.scrollSensitivity,speed=b.scrollSpeed,x=a.clientX,y=a.clientY,winWidth=window.innerWidth,winHeight=window.innerHeight,vx,vy;if(scrollParentEl!==c){scrollEl=b.scroll;scrollParentEl=c;if(scrollEl===true){scrollEl=c;do{if((scrollEl.offsetWidth<scrollEl.scrollWidth)||(scrollEl.offsetHeight<scrollEl.scrollHeight)){break}}while(scrollEl=scrollEl.parentNode)}}if(scrollEl){d=scrollEl;rect=scrollEl.getBoundingClientRect();vx=(abs(rect.right-x)<=sens)-(abs(rect.left-x)<=sens);vy=(abs(rect.bottom-y)<=sens)-(abs(rect.top-y)<=sens)}if(!(vx||vy)){vx=(winWidth-x<=sens)-(x<=sens);vy=(winHeight-y<=sens)-(y<=sens);(vx||vy)&&(d=win)}if(autoScroll.vx!==vx||autoScroll.vy!==vy||autoScroll.el!==d){autoScroll.el=d;autoScroll.vx=vx;autoScroll.vy=vy;clearInterval(autoScroll.pid);if(d){autoScroll.pid=setInterval(function(){if(d===win){win.scrollTo(win.pageXOffset+vx*speed,win.pageYOffset+vy*speed)}else{vy&&(d.scrollTop+=vy*speed);vx&&(d.scrollLeft+=vx*speed)}},24)}}}},30),_prepareGroup=function(b){var c=b.group;if(!c||typeof c!='object'){c=b.group={name:c}}['pull','put'].forEach(function(a){if(!(a in c)){c[a]=true}});b.groups=' '+c.name+(c.put.join?' '+c.put.join(' '):'')+' '};function Sortables(c,d){if(!(c&&c.nodeType&&c.nodeType===1)){throw'Sortables: `el` must be HTMLElement, and not '+{}.toString.call(c)}this.el=c;this.options=d=_extend({},d);c[expando]=this;var e={group:Math.random(),sort:true,disabled:false,store:null,handle:null,scroll:true,scrollSensitivity:30,scrollSpeed:10,draggable:/[uo]l/i.test(c.nodeName)?'li':'>*',ghostClass:'sortable-ghost',chosenClass:'sortable-chosen',ignore:'a, img',filter:null,animation:0,setData:function(a,b){a.setData('Text',b.textContent)},dropBubble:false,dragoverBubble:false,dataIdAttr:'data-id',delay:0,forceFallback:false,fallbackClass:'sortable-fallback',fallbackOnBody:false};for(var f in e){!(f in d)&&(d[f]=e[f])}_prepareGroup(d);for(var g in this){if(g.charAt(0)==='_'){this[g]=this[g].bind(this)}}this.nativeDraggable=d.forceFallback?false:supportDraggable;_on(c,'mousedown',this._onTapStart);_on(c,'touchstart',this._onTapStart);if(this.nativeDraggable){_on(c,'dragover',this);_on(c,'dragenter',this)}touchDragOverListeners.push(this._onDragOver);d.store&&this.sort(d.store.get(this))}Sortables.prototype={constructor:Sortables,_onTapStart:function(b){var c=this,el=this.el,options=this.options,type=b.type,touch=b.touches&&b.touches[0],target=(touch||b).target,originalTarget=target,filter=options.filter;if(type==='mousedown'&&b.button!==0||options.disabled){return}target=_closest(target,options.draggable,el);if(!target){return}oldIndex=_index(target,options.draggable);if(typeof filter==='function'){if(filter.call(this,b,target,this)){_dispatchEvent(c,originalTarget,'filter',target,el,oldIndex);b.preventDefault();return}}else if(filter){filter=filter.split(',').some(function(a){a=_closest(originalTarget,a.trim(),el);if(a){_dispatchEvent(c,a,'filter',target,el,oldIndex);return true}});if(filter){b.preventDefault();return}}if(options.handle&&!_closest(originalTarget,options.handle,el)){return}this._prepareDragStart(b,touch,target)},_prepareDragStart:function(b,c,d){var e=this,el=e.el,options=e.options,ownerDocument=el.ownerDocument,dragStartFn;if(d&&!j&&(d.parentNode===el)){tapEvt=b;rootEl=el;j=d;parentEl=j.parentNode;nextEl=j.nextSibling;activeGroup=options.group;dragStartFn=function(){e._disableDelayedDrag();j.draggable=true;_toggleClass(j,e.options.chosenClass,true);e._triggerDragStart(c)};options.ignore.split(',').forEach(function(a){_find(j,a.trim(),_disableDraggable)});_on(ownerDocument,'mouseup',e._onDrop);_on(ownerDocument,'touchend',e._onDrop);_on(ownerDocument,'touchcancel',e._onDrop);if(options.delay){_on(ownerDocument,'mouseup',e._disableDelayedDrag);_on(ownerDocument,'touchend',e._disableDelayedDrag);_on(ownerDocument,'touchcancel',e._disableDelayedDrag);_on(ownerDocument,'mousemove',e._disableDelayedDrag);_on(ownerDocument,'touchmove',e._disableDelayedDrag);e._dragStartTimer=setTimeout(dragStartFn,options.delay)}else{dragStartFn()}}},_disableDelayedDrag:function(){var a=this.el.ownerDocument;clearTimeout(this._dragStartTimer);_off(a,'mouseup',this._disableDelayedDrag);_off(a,'touchend',this._disableDelayedDrag);_off(a,'touchcancel',this._disableDelayedDrag);_off(a,'mousemove',this._disableDelayedDrag);_off(a,'touchmove',this._disableDelayedDrag)},_triggerDragStart:function(a){if(a){tapEvt={target:j,clientX:a.clientX,clientY:a.clientY};this._onDragStart(tapEvt,'touch')}else if(!this.nativeDraggable){this._onDragStart(tapEvt,true)}else{_on(j,'dragend',this);_on(rootEl,'dragstart',this._onDragStart)}try{if(document.selection){setTimeout(function(){document.selection.empty()})}else{window.getSelection().removeAllRanges()}}catch(err){}},_dragStarted:function(){if(rootEl&&j){_toggleClass(j,this.options.ghostClass,true);Sortables.active=this;_dispatchEvent(this,rootEl,'start',j,rootEl,oldIndex)}},_emulateDragOver:function(){if(touchEvt){if(this._lastX===touchEvt.clientX&&this._lastY===touchEvt.clientY){return}this._lastX=touchEvt.clientX;this._lastY=touchEvt.clientY;if(!supportCssPointerEvents){_css(ghostEl,'display','none')}var a=document.elementFromPoint(touchEvt.clientX,touchEvt.clientY),parent=a,groupName=' '+this.options.group.name+'',i=touchDragOverListeners.length;if(parent){do{if(parent[expando]&&parent[expando].options.groups.indexOf(groupName)>-1){while(i--){touchDragOverListeners[i]({clientX:touchEvt.clientX,clientY:touchEvt.clientY,target:a,rootEl:parent})}break}a=parent}while(parent=parent.parentNode)}if(!supportCssPointerEvents){_css(ghostEl,'display','')}}},_onTouchMove:function(a){if(tapEvt){if(!Sortables.active){this._dragStarted()}this._appendGhost();var b=a.touches?a.touches[0]:a,dx=b.clientX-tapEvt.clientX,dy=b.clientY-tapEvt.clientY,translate3d=a.touches?'translate3d('+dx+'px,'+dy+'px,0)':'translate('+dx+'px,'+dy+'px)';moved=true;touchEvt=b;_css(ghostEl,'webkitTransform',translate3d);_css(ghostEl,'mozTransform',translate3d);_css(ghostEl,'msTransform',translate3d);_css(ghostEl,'transform',translate3d);a.preventDefault()}},_appendGhost:function(){if(!ghostEl){var a=j.getBoundingClientRect(),css=_css(j),options=this.options,ghostRect;ghostEl=j.cloneNode(true);_toggleClass(ghostEl,options.ghostClass,false);_toggleClass(ghostEl,options.fallbackClass,true);_css(ghostEl,'top',a.top-parseInt(css.marginTop,10));_css(ghostEl,'left',a.left-parseInt(css.marginLeft,10));_css(ghostEl,'width',a.width);_css(ghostEl,'height',a.height);_css(ghostEl,'opacity','0.8');_css(ghostEl,'position','fixed');_css(ghostEl,'zIndex','100000');_css(ghostEl,'pointerEvents','none');options.fallbackOnBody&&document.body.appendChild(ghostEl)||rootEl.appendChild(ghostEl);ghostRect=ghostEl.getBoundingClientRect();_css(ghostEl,'width',a.width*2-ghostRect.width);_css(ghostEl,'height',a.height*2-ghostRect.height)}},_onDragStart:function(a,b){var c=a.dataTransfer,options=this.options;this._offUpEvents();if(activeGroup.pull=='clone'){cloneEl=j.cloneNode(true);_css(cloneEl,'display','none');rootEl.insertBefore(cloneEl,j)}if(b){if(b==='touch'){_on(document,'touchmove',this._onTouchMove);_on(document,'touchend',this._onDrop);_on(document,'touchcancel',this._onDrop)}else{_on(document,'mousemove',this._onTouchMove);_on(document,'mouseup',this._onDrop)}this._loopId=setInterval(this._emulateDragOver,50)}else{if(c){c.effectAllowed='move';options.setData&&options.setData.call(this,c,j)}_on(document,'drop',this);setTimeout(this._dragStarted,0)}},_onDragOver:function(a){var b=this.el,target,dragRect,revert,options=this.options,group=options.group,groupPut=group.put,isOwner=(activeGroup===group),canSort=options.sort;if(a.preventDefault!==void 0){a.preventDefault();!options.dragoverBubble&&a.stopPropagation()}moved=true;if(activeGroup&&!options.disabled&&(isOwner?canSort||(revert=!rootEl.contains(j)):activeGroup.pull&&groupPut&&((activeGroup.name===group.name)||(groupPut.indexOf&&~groupPut.indexOf(activeGroup.name))))&&(a.rootEl===void 0||a.rootEl===this.el)){_autoScroll(a,options,this.el);if(_silent){return}target=_closest(a.target,options.draggable,b);dragRect=j.getBoundingClientRect();if(revert){_cloneHide(true);if(cloneEl||nextEl){rootEl.insertBefore(j,cloneEl||nextEl)}else if(!canSort){rootEl.appendChild(j)}return}if((b.children.length===0)||(b.children[0]===ghostEl)||(b===a.target)&&(target=_ghostIsLast(b,a))){if(target){if(target.animated){return}c=target.getBoundingClientRect()}_cloneHide(isOwner);if(_onMove(rootEl,b,j,dragRect,target,c)!==false){if(!j.contains(b)){b.appendChild(j);parentEl=b}this._animate(dragRect,j);target&&this._animate(c,target)}}else if(target&&!target.animated&&target!==j&&(target.parentNode[expando]!==void 0)){if(lastEl!==target){lastEl=target;lastCSS=_css(target);lastParentCSS=_css(target.parentNode)}var c=target.getBoundingClientRect(),width=c.right-c.left,height=c.bottom-c.top,floating=/left|right|inline/.test(lastCSS.cssFloat+lastCSS.display)||(lastParentCSS.display=='flex'),isWide=(target.offsetWidth>j.offsetWidth),isLong=(target.offsetHeight>j.offsetHeight),halfway=(floating?(a.clientX-c.left)/width:(a.clientY-c.top)/height)>0.5,nextSibling=target.nextElementSibling,moveVector=_onMove(rootEl,b,j,dragRect,target,c),after;if(moveVector!==false){_silent=true;setTimeout(_unsilent,30);_cloneHide(isOwner);if(moveVector===1||moveVector===-1){after=(moveVector===1)}else if(floating){var d=j.offsetTop,tgTop=target.offsetTop;if(d===tgTop){after=(target.previousElementSibling===j)&&!isWide||halfway&&isWide}else{after=tgTop>d}}else{after=(nextSibling!==j)&&!isLong||halfway&&isLong}if(!j.contains(b)){if(after&&!nextSibling){b.appendChild(j)}else{target.parentNode.insertBefore(j,after?nextSibling:target)}}parentEl=j.parentNode;this._animate(dragRect,j);this._animate(c,target)}}}},_animate:function(a,b){var c=this.options.animation;if(c){var d=b.getBoundingClientRect();_css(b,'transition','none');_css(b,'transform','translate3d('+(a.left-d.left)+'px,'+(a.top-d.top)+'px,0)');b.offsetWidth;_css(b,'transition','all '+c+'ms');_css(b,'transform','translate3d(0,0,0)');clearTimeout(b.animated);b.animated=setTimeout(function(){_css(b,'transition','');_css(b,'transform','');b.animated=false},c)}},_offUpEvents:function(){var a=this.el.ownerDocument;_off(document,'touchmove',this._onTouchMove);_off(a,'mouseup',this._onDrop);_off(a,'touchend',this._onDrop);_off(a,'touchcancel',this._onDrop)},_onDrop:function(a){var b=this.el,options=this.options;clearInterval(this._loopId);clearInterval(autoScroll.pid);clearTimeout(this._dragStartTimer);_off(document,'mousemove',this._onTouchMove);if(this.nativeDraggable){_off(document,'drop',this);_off(b,'dragstart',this._onDragStart)}this._offUpEvents();if(a){if(moved){a.preventDefault();!options.dropBubble&&a.stopPropagation()}ghostEl&&ghostEl.parentNode.removeChild(ghostEl);if(j){if(this.nativeDraggable){_off(j,'dragend',this)}_disableDraggable(j);_toggleClass(j,this.options.ghostClass,false);_toggleClass(j,this.options.chosenClass,false);if(rootEl!==parentEl){newIndex=_index(j,options.draggable);if(newIndex>=0){_dispatchEvent(null,parentEl,'sort',j,rootEl,oldIndex,newIndex);_dispatchEvent(this,rootEl,'sort',j,rootEl,oldIndex,newIndex);_dispatchEvent(null,parentEl,'add',j,rootEl,oldIndex,newIndex);_dispatchEvent(this,rootEl,'remove',j,rootEl,oldIndex,newIndex)}}else{cloneEl&&cloneEl.parentNode.removeChild(cloneEl);if(j.nextSibling!==nextEl){newIndex=_index(j,options.draggable);if(newIndex>=0){_dispatchEvent(this,rootEl,'update',j,rootEl,oldIndex,newIndex);_dispatchEvent(this,rootEl,'sort',j,rootEl,oldIndex,newIndex)}}}if(Sortables.active){if(newIndex==null||newIndex===-1){newIndex=oldIndex}_dispatchEvent(this,rootEl,'end',j,rootEl,oldIndex,newIndex);this.save()}}}this._nulling()},_nulling:function(){if(Sortables.active===this){rootEl=j=parentEl=ghostEl=nextEl=cloneEl=scrollEl=scrollParentEl=tapEvt=touchEvt=moved=newIndex=lastEl=lastCSS=activeGroup=Sortables.active=null}},handleEvent:function(a){var b=a.type;if(b==='dragover'||b==='dragenter'){if(j){this._onDragOver(a);_globalDragOver(a)}}else if(b==='drop'||b==='dragend'){this._onDrop(a)}},toArray:function(){var a=[],el,children=this.el.children,i=0,n=children.length,options=this.options;for(;i<n;i++){el=children[i];if(_closest(el,options.draggable,this.el)){a.push(el.getAttribute(options.dataIdAttr)||_generateId(el))}}return a},sort:function(c){var d={},rootEl=this.el;this.toArray().forEach(function(a,i){var b=rootEl.children[i];if(_closest(b,this.options.draggable,rootEl)){d[a]=b}},this);c.forEach(function(a){if(d[a]){rootEl.removeChild(d[a]);rootEl.appendChild(d[a])}})},save:function(){var a=this.options.store;a&&a.set(this)},closest:function(a,b){return _closest(a,b||this.options.draggable,this.el)},option:function(a,b){var c=this.options;if(b===void 0){return c[a]}else{c[a]=b;if(a==='group'){_prepareGroup(c)}}},destroy:function(){var b=this.el;b[expando]=null;_off(b,'mousedown',this._onTapStart);_off(b,'touchstart',this._onTapStart);if(this.nativeDraggable){_off(b,'dragover',this);_off(b,'dragenter',this)}Array.prototype.forEach.call(b.querySelectorAll('[draggable]'),function(a){a.removeAttribute('draggable')});touchDragOverListeners.splice(touchDragOverListeners.indexOf(this._onDragOver),1);this._onDrop();this.el=b=null}};function _cloneHide(a){if(cloneEl&&(cloneEl.state!==a)){_css(cloneEl,'display',a?'none':'');!a&&cloneEl.state&&rootEl.insertBefore(cloneEl,j);cloneEl.state=a}}function _closest(a,b,c){if(a){c=c||document;do{if((b==='>*'&&a.parentNode===c)||_matches(a,b)){return a}}while(a!==c&&(a=a.parentNode))}return null}function _globalDragOver(a){if(a.dataTransfer){a.dataTransfer.dropEffect='move'}a.preventDefault()}function _on(a,b,c){a.addEventListener(b,c,false)}function _off(a,b,c){a.removeEventListener(b,c,false)}function _toggleClass(a,b,c){if(a){if(a.classList){a.classList[c?'add':'remove'](b)}else{var d=(' '+a.className+' ').replace(RSPACE,' ').replace(' '+b+' ',' ');a.className=(d+(c?' '+b:'')).replace(RSPACE,' ')}}}function _css(a,b,c){var d=a&&a.style;if(d){if(c===void 0){if(document.defaultView&&document.defaultView.getComputedStyle){c=document.defaultView.getComputedStyle(a,'')}else if(a.currentStyle){c=a.currentStyle}return b===void 0?c:c[b]}else{if(!(b in d)){b='-webkit-'+b}d[b]=c+(typeof c==='string'?'':'px')}}}function _find(a,b,c){if(a){var d=a.getElementsByTagName(b),i=0,n=d.length;if(c){for(;i<n;i++){c(d[i],i)}}return d}return[]}function _dispatchEvent(a,b,c,d,e,f,g){var h=document.createEvent('Event'),options=(a||b[expando]).options,onName='on'+c.charAt(0).toUpperCase()+c.substr(1);h.initEvent(c,true,true);h.to=b;h.from=e||b;h.item=d||b;h.clone=cloneEl;h.oldIndex=f;h.newIndex=g;b.dispatchEvent(h);if(options[onName]){options[onName].call(a,h)}}function _onMove(a,b,c,d,e,f){var g,sortables=a[expando],onMoveFn=sortables.options.onMove,retVal;g=document.createEvent('Event');g.initEvent('move',true,true);g.to=b;g.from=a;g.dragged=c;g.draggedRect=d;g.related=e||b;g.relatedRect=f||b.getBoundingClientRect();a.dispatchEvent(g);if(onMoveFn){retVal=onMoveFn.call(sortables,g)}return retVal}function _disableDraggable(a){a.draggable=false}function _unsilent(){_silent=false}function _ghostIsLast(a,b){var c=a.lastElementChild,rect=c.getBoundingClientRect();return((b.clientY-(rect.top+rect.height)>5)||(b.clientX-(rect.right+rect.width)>5))&&c}function _generateId(a){var b=a.tagName+a.className+a.src+a.href+a.textContent,i=b.length,sum=0;while(i--){sum+=b.charCodeAt(i)}return sum.toString(36)}function _index(a,b){var c=0;if(!a||!a.parentNode){return-1}while(a&&(a=a.previousElementSibling)){if(a.nodeName.toUpperCase()!=='TEMPLATE'&&_matches(a,b)){c++}}return c}function _matches(a,b){if(a){b=b.split('.');var c=b.shift().toUpperCase(),re=new RegExp('\\s('+b.join('|')+')(?=\\s)','g');return((c===''||a.nodeName.toUpperCase()==c)&&(!b.length||((' '+a.className+' ').match(re)||[]).length==b.length))}return false}function _throttle(a,b){var c,_this;return function(){if(c===void 0){c=arguments;_this=this;setTimeout(function(){if(c.length===1){a.call(_this,c[0])}else{a.apply(_this,c)}c=void 0},b)}}}function _extend(a,b){if(a&&b){for(var c in b){if(b.hasOwnProperty(c)){a[c]=b[c]}}}return a}Sortables.utils={on:_on,off:_off,css:_css,find:_find,is:function(a,b){return!!_closest(a,b,a)},extend:_extend,throttle:_throttle,closest:_closest,toggleClass:_toggleClass,index:_index};Sortables.create=function(a,b){return new Sortables(a,b)};Sortables.version='1.4.2';return Sortables});(function(a){"use strict";if(typeof define==="function"&&define.amd){define(["jquery"],a)}else{a(jQuery)}})(function($){"use strict";$.fn.sortables=function(b){var c,args=arguments;this.each(function(){var a=$(this),sortables=a.data('sortables');if(!sortables&&(b instanceof Object||!b)){sortables=new Sortables(this,b);a.data('sortables',sortables)}if(sortables){if(b==='widget'){return sortables}else if(b==='destroy'){sortables.destroy();a.removeData('sortables')}else if(typeof sortables[b]==='function'){c=sortables[b].apply(sortables,[].slice.call(args,1))}else if(b in sortables.options){c=sortables.option.apply(sortables,args)}}});return(c===void 0)?this:c}});
/*!
  Number Spinner
  */
(function($){$.fn.wojoSpinner=function(options){return this.each(function(e){var self=$(this);var settings=$.extend({upClass:'default',downClass:'default',size:'tiny',step:1,align:"center"},$(self).data('spinner'),options);var clone=self.clone();var min=self.attr('min');var max=self.attr('max');function setText(n){if((min&&n<min)||(max&&n>max)){return false}clone.val(n);return true}var group=$("<div class='wojo "+settings.size+" right labeled spinner input'></div>");var down=$('<button type="button">-</button>').attr('class','wojo button '+settings.downClass).click(function(){setText(parseInt(clone.val())-settings.step)});var up=$('<button type="button">+</button>').attr('class','wojo button '+settings.upClass).click(function(){setText(parseInt(clone.val())+settings.step)});clone.appendTo(group);var label=$('<div class="wojo basic label"></div>').appendTo(group);if(clone){clone.css('text-align',settings.align)}$(up).appendTo(label);$(down).appendTo(label);clone.attr('type','text').keydown(function(e){if($.inArray(e.keyCode,[46,8,9,27,13,110,190])!==-1||(e.keyCode==65&&e.ctrlKey===true)||(e.keyCode>=35&&e.keyCode<=39)){return}if((e.shiftKey||(e.keyCode<48||e.keyCode>57))&&(e.keyCode<96||e.keyCode>105)){e.preventDefault()}var c=String.fromCharCode(e.which);var n=parseInt(clone.val()+c);if((min&&n<min)||(max&&n>max)){e.preventDefault()}});self.replaceWith(group)})}}(jQuery));
/*!
  Wait for images
  */
!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):"object"==typeof exports?module.exports=a(require("jquery")):a(jQuery)}(function(a){var b="waitForImages";a.waitForImages={hasImageProperties:["backgroundImage","listStyleImage","borderImage","borderCornerImage","cursor"],hasImageAttributes:["srcset"]},a.expr[":"]["has-src"]=function(b){return a(b).is('img[src][src!=""]')},a.expr[":"].uncached=function(b){return a(b).is(":has-src")?!b.complete:!1},a.fn.waitForImages=function(){var c,d,e,f=0,g=0,h=a.Deferred();if(a.isPlainObject(arguments[0])?(e=arguments[0].waitForAll,d=arguments[0].each,c=arguments[0].finished):1===arguments.length&&"boolean"===a.type(arguments[0])?e=arguments[0]:(c=arguments[0],d=arguments[1],e=arguments[2]),c=c||a.noop,d=d||a.noop,e=!!e,!a.isFunction(c)||!a.isFunction(d))throw new TypeError("An invalid callback was supplied.");return this.each(function(){var i=a(this),j=[],k=a.waitForImages.hasImageProperties||[],l=a.waitForImages.hasImageAttributes||[],m=/url\(\s*(['"]?)(.*?)\1\s*\)/g;e?i.find("*").addBack().each(function(){var b=a(this);b.is("img:has-src")&&!b.is("[srcset]")&&j.push({src:b.attr("src"),element:b[0]}),a.each(k,function(a,c){var d,e=b.css(c);if(!e)return!0;for(;d=m.exec(e);)j.push({src:d[2],element:b[0]})}),a.each(l,function(a,c){var d=b.attr(c);return d?void j.push({src:b.attr("src"),srcset:b.attr("srcset"),element:b[0]}):!0})}):i.find("img:has-src").each(function(){j.push({src:this.src,element:this})}),f=j.length,g=0,0===f&&(c.call(i[0]),h.resolveWith(i[0])),a.each(j,function(e,j){var k=new Image,l="load."+b+" error."+b;a(k).one(l,function m(b){var e=[g,f,"load"==b.type];return g++,d.apply(j.element,e),h.notifyWith(j.element,e),a(this).off(l,m),g==f?(c.call(i[0]),h.resolveWith(i[0]),!1):void 0}),j.srcset&&(k.srcset=j.srcset),k.src=j.src})}),h.promise()}});
/*!
  Pinto jQuery Plugin
  @name jquery.pinto.js
  @copyright (c) 2015 Max Lawrence (http://www.avirtum.com)
  @license Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
*/
(function($){"use strict";var Util=(function(){function Util(){}Util.prototype.css2json=function(css){var s={};if(!css)return s;if(css instanceof CSSStyleDeclaration){for(var i in css){if((css[i]).toLowerCase){s[(css[i]).toLowerCase()]=(css[css[i]])}}}else if(typeof css=="string"){css=css.split(";");for(var i in css){var l=css[i].split(":");if(l.length==2){s[l[0].toLowerCase().trim()]=(l[1].trim())}}}return s};return Util}());var WeakMap=window.WeakMap||window.MozWeakMap||(WeakMap=(function(){function WeakMap(){this.keys=[];this.values=[]}WeakMap.prototype.get=function(key){var i,item,j,len,ref;ref=this.keys;for(i=j=0,len=ref.length;j<len;i=++j){item=ref[i];if(item===key){return this.values[i]}}};WeakMap.prototype.set=function(key,value){var i,item,j,len,ref;ref=this.keys;for(i=j=0,len=ref.length;j<len;i=++j){item=ref[i];if(item===key){this.values[i]=value;return}}this.keys.push(key);return this.values.push(value)};return WeakMap})());var ITEM_DATA_NAME="pinto";var _counter=0;function Pinto(container,config){this.container=null;this.items=null;this.config=null;this.containerStyleCache=null;this.styleCache=null;this.timer=null;this.id=++_counter;this.init(container,config)};Pinto.prototype={defaults:{itemClass:"item",itemSkipClass:"skip",itemWidth:'',gapX:32,gapY:32,align:"left",fitWidth:true,autoResize:true,resizeDelay:50,onItemLayout:function(el,column,position){},},init:function(container,config){this.destroy();this.container=container;this.config=config;this.styleCache=new WeakMap();this.build();this.layout()},applyHandlers:function(){if(this.config.autoResize){$(window).on("resize.pinto"+this.id,$.proxy(this.onResizeHandler,this))}this.container.on("remove",$.proxy(this.resetHandlers,this))},resetHandlers:function(){$(window).off("resize.pinto"+this.id,$.proxy(this.onResizeHandler,this));clearTimeout(this.timer)},onResizeHandler:function(){clearTimeout(this.timer);this.timer=setTimeout($.proxy(this.layout,this),this.config.resizeDelay)},build:function(){this.applyHandlers();this.containerStyleCache=this.util().css2json(this.container.attr("style"));this.items=this.container.find("> ."+this.config.itemClass);if(this.items.length){this.items.each($.proxy(function(index,item){this.cacheStyle(item)},this))}if(this.container.css("position")=="static"){this.container.css("position","relative")}},layout:function(){if(!this.container.is(":visible")){return}var width=this.container.innerWidth(),itemWidth=this.config.itemWidth?this.config.itemWidth:this.container.data('width'),gapX=parseInt(this.config.gapX||0),gapY=parseInt(this.config.gapY||0),offset=0,colsCount=0;while(width>offset){offset+=itemWidth;if(width>=offset){colsCount++}else{break}offset+=gapX};colsCount=Math.max(colsCount,1);var cols=[],colsH=[],i=colsCount;while(i--){cols.push(0);colsH.push(0)}offset=0;var gap=(colsCount-1)*gapX;if(this.config.fitWidth){itemWidth+=Math.floor(0.5+(width-gap-colsCount*itemWidth)/colsCount)}else{if(this.config.align==="center"){offset+=Math.floor(0.5+(width-gap-colsCount*itemWidth)>>1)}else if(this.config.align==="right"){offset+=Math.floor(0.5+(width-gap-colsCount*itemWidth))}};this.items.each($.proxy(function(index,item){var $item=$(item);if(!$item.is(":visible")||$item.hasClass(this.itemSkipClass)){return}var i=this.getSmallestIndex(colsH);$item.css({position:"absolute",top:colsH[i]+"px",left:(itemWidth+gapX)*i+offset+"px",width:itemWidth});colsH[i]+=$item.outerHeight()+gapY;if(typeof this.config.onItemLayout=="function"){this.config.onItemLayout.call(this,item,i,cols[i])}cols[i]++},this));var height=0;i=colsCount;while(i--)if(colsH[i]>height)height=colsH[i];this.container.css({height:height})},destroy:function(){this.resetHandlers();if(this.containerStyleCache){this.container.removeAttr("style").css(this.containerStyleCache)}if(this.items){this.items.each($.proxy(function(index,item){this.resetStyle(item)},this))}this.items=null;this.config=null;this.containerStyleCache=null,this.styleCache=null;this.timer=null},sync:function(){if(this.items){this.items.each($.proxy(function(index,item){this.resetStyle(item)},this))}this.items=$("> ."+this.config.itemClass);if(this.items.length){this.items.each($.proxy(function(index,item){this.cacheStyle(item)},this))}this.layout()},cacheStyle:function(item){return this.styleCache.set(item,this.util().css2json($(item).attr("style")))},resetStyle:function(item){$(item).removeAttr("style").css(this.styleCache.get(item))},getSmallestIndex:function(a){var index=0;for(var i=1,len=a.length;i<len;i++){if(a[i]<a[index])index=i}return index},util:function(){return this._util!=null?this._util:this._util=new Util()}};$.fn.pinto=function(CfgOrCmd,CmdArgs){return this.each(function(){var container=$(this),instance=container.data(ITEM_DATA_NAME),options=$.isPlainObject(CfgOrCmd)?CfgOrCmd:{};if(CfgOrCmd=="layout"){if(!instance){throw Error("Calling 'layout' method on not initialized instance is forbidden");}instance.layout();return}if(CfgOrCmd=="sync"){if(!instance){throw Error("Calling 'sync' method on not initialized instance is forbidden");}instance.sync();return}if(CfgOrCmd=="destroy"){if(!instance){throw Error("Calling 'destroy' method on not initialized instance is forbidden");}container.removeData(ITEM_DATA_NAME);instance.destroy();return}if(instance){var config=$.extend({},instance.config,options);instance.init(container,config)}else{var config=$.extend({},Pinto.prototype.defaults,options);instance=new Pinto(container,config);container.data(ITEM_DATA_NAME,instance)}})}})(window.jQuery);
/*
/* https://github.com/bootstrap-tagsinput/bootstrap-tagsinput
*/
(function($){"use strict";var o={tagClass:function(a){return'label label-info'},itemValue:function(a){return a?a.toString():a},itemText:function(a){return this.itemValue(a)},itemTitle:function(a){return null},freeInput:true,addOnBlur:true,maxTags:undefined,maxChars:undefined,confirmKeys:[13,44],delimiter:',',delimiterRegex:null,cancelConfirmKeysOnEmpty:true,onTagExists:function(a,b){b.hide().fadeIn()},trimValue:false,allowDuplicates:false};function TagsInput(a,b){this.itemsArray=[];this.$element=$(a);this.$element.hide();this.isSelect=(a.tagName==='SELECT');this.multiple=(this.isSelect&&a.hasAttribute('multiple'));this.objectItems=b&&b.itemValue;this.placeholderText=a.hasAttribute('placeholder')?this.$element.attr('placeholder'):'';this.inputSize=Math.max(1,this.placeholderText.length);this.$container=$('<div class="wojo left fluid icon input"><i class="icon tags"></i></div>');this.$input=$('<input type="text" placeholder="'+this.placeholderText+'"/>').appendTo(this.$container);this.$element.before(this.$container);this.build(b)}TagsInput.prototype={constructor:TagsInput,add:function(b,c,d){var e=this;if(e.options.maxTags&&e.itemsArray.length>=e.options.maxTags)return;if(b!==false&&!b)return;if(typeof b==="string"&&e.options.trimValue){b=$.trim(b)}if(typeof b==="object"&&!e.objectItems)throw("Can't add objects when itemValue option is not set");if(b.toString().match(/^\s*$/))return;if(e.isSelect&&!e.multiple&&e.itemsArray.length>0)e.remove(e.itemsArray[0]);if(typeof b==="string"&&this.$element[0].tagName==='INPUT'){var f=(e.options.delimiterRegex)?e.options.delimiterRegex:e.options.delimiter;var g=b.split(f);if(g.length>1){for(var i=0;i<g.length;i++){this.add(g[i],true)}if(!c)e.pushVal();return}}var h=e.options.itemValue(b),itemText=e.options.itemText(b),tagClass=e.options.tagClass(b),itemTitle=e.options.itemTitle(b);var j=$.grep(e.itemsArray,function(a){return e.options.itemValue(a)===h})[0];if(j&&!e.options.allowDuplicates){if(e.options.onTagExists){var k=$(".tag",e.$container).filter(function(){return $(this).data("item")===j});e.options.onTagExists(b,k)}return}if(e.items().toString().length+b.length+1>e.options.maxInputLength)return;var l=$.Event('beforeItemAdd',{item:b,cancel:false,options:d});e.$element.trigger(l);if(l.cancel)return;e.itemsArray.push(b);var m=$('<span class="tag '+htmlEncode(tagClass)+(itemTitle!==null?('" title="'+itemTitle):'')+'">'+htmlEncode(itemText)+'<span data-role="remove"></span></span>');m.data('item',b);e.findInputWrapper().before(m);m.after(' ');if(e.isSelect&&!$('option[value="'+encodeURIComponent(h)+'"]',e.$element)[0]){var n=$('<option selected>'+htmlEncode(itemText)+'</option>');n.data('item',b);n.attr('value',h);e.$element.append(n)}if(!c)e.pushVal();if(e.options.maxTags===e.itemsArray.length||e.items().toString().length===e.options.maxInputLength)e.$container.addClass('bootstrap-tagsinput-max');e.$element.trigger($.Event('itemAdded',{item:b,options:d}))},remove:function(b,c,d){var e=this;if(e.objectItems){if(typeof b==="object")b=$.grep(e.itemsArray,function(a){return e.options.itemValue(a)==e.options.itemValue(b)});else b=$.grep(e.itemsArray,function(a){return e.options.itemValue(a)==b});b=b[b.length-1]}if(b){var f=$.Event('beforeItemRemove',{item:b,cancel:false,options:d});e.$element.trigger(f);if(f.cancel)return;$('.tag',e.$container).filter(function(){return $(this).data('item')===b}).remove();$('option',e.$element).filter(function(){return $(this).data('item')===b}).remove();if($.inArray(b,e.itemsArray)!==-1)e.itemsArray.splice($.inArray(b,e.itemsArray),1)}if(!c)e.pushVal();if(e.options.maxTags>e.itemsArray.length)e.$container.removeClass('bootstrap-tagsinput-max');e.$element.trigger($.Event('itemRemoved',{item:b,options:d}))},removeAll:function(){var a=this;$('.tag',a.$container).remove();$('option',a.$element).remove();while(a.itemsArray.length>0)a.itemsArray.pop();a.pushVal()},refresh:function(){var c=this;$('.tag',c.$container).each(function(){var a=$(this),item=a.data('item'),itemValue=c.options.itemValue(item),itemText=c.options.itemText(item),tagClass=c.options.tagClass(item);a.attr('class',null);a.addClass('tag '+htmlEncode(tagClass));a.contents().filter(function(){return this.nodeType==3})[0].nodeValue=htmlEncode(itemText);if(c.isSelect){var b=$('option',c.$element).filter(function(){return $(this).data('item')===item});b.attr('value',itemValue)}})},items:function(){return this.itemsArray},pushVal:function(){var b=this,val=$.map(b.items(),function(a){return b.options.itemValue(a).toString()});b.$element.val(val,true).trigger('change')},build:function(h){var j=this;j.options=$.extend({},o,h);if(j.objectItems)j.options.freeInput=false;makeOptionItemFunction(j.options,'itemValue');makeOptionItemFunction(j.options,'itemText');makeOptionFunction(j.options,'tagClass');if(j.options.typeahead){var k=j.options.typeahead||{};makeOptionFunction(k,'source');j.$input.typeahead($.extend({},k,{source:function(d,e){function processItems(a){var b=[];for(var i=0;i<a.length;i++){var c=j.options.itemText(a[i]);f[c]=a[i];b.push(c)}e(b)}this.map={};var f=this.map,data=k.source(d);if($.isFunction(data.success)){data.success(processItems)}else if($.isFunction(data.then)){data.then(processItems)}else{$.when(data).then(processItems)}},updater:function(a){j.add(this.map[a]);return this.map[a]},matcher:function(a){return(a.toLowerCase().indexOf(this.query.trim().toLowerCase())!==-1)},sorter:function(a){return a.sort()},highlighter:function(a){var b=new RegExp('('+this.query+')','gi');return a.replace(b,"<strong>$1</strong>")}}))}if(j.options.typeaheadjs){var l=null;var m={};var n=j.options.typeaheadjs;if($.isArray(n)){l=n[0];m=n[1]}else{m=n}j.$input.typeahead(l,m).on('typeahead:selected',$.proxy(function(a,b){if(m.valueKey)j.add(b[m.valueKey]);else j.add(b);j.$input.typeahead('val','')},j))}j.$container.on('click',$.proxy(function(a){if(!j.$element.attr('disabled')){j.$input.removeAttr('disabled')}j.$input.focus()},j));if(j.options.addOnBlur&&j.options.freeInput){j.$input.on('focusout',$.proxy(function(a){if($('.typeahead, .twitter-typeahead',j.$container).length===0){j.add(j.$input.val());j.$input.val('')}},j))}j.$container.on('keydown','input',$.proxy(function(a){var b=$(a.target),$inputWrapper=j.findInputWrapper();if(j.$element.attr('disabled')){j.$input.attr('disabled','disabled');return}switch(a.which){case 8:if(doGetCaretPosition(b[0])===0){var c=$inputWrapper.prev();if(c.length){j.remove(c.data('item'))}}break;case 46:if(doGetCaretPosition(b[0])===0){var d=$inputWrapper.next();if(d.length){j.remove(d.data('item'))}}break;case 37:var e=$inputWrapper.prev();if(b.val().length===0&&e[0]){e.before($inputWrapper);b.focus()}break;case 39:var f=$inputWrapper.next();if(b.val().length===0&&f[0]){f.after($inputWrapper);b.focus()}break;default:}var g=b.val().length,wordSpace=Math.ceil(g/5),size=g+wordSpace+1;b.attr('size',Math.max(this.inputSize,b.val().length))},j));j.$container.on('keypress','input',$.proxy(function(a){var b=$(a.target);if(j.$element.attr('disabled')){j.$input.attr('disabled','disabled');return}var c=b.val(),maxLengthReached=j.options.maxChars&&c.length>=j.options.maxChars;if(j.options.freeInput&&(keyCombinationInList(a,j.options.confirmKeys)||maxLengthReached)){if(c.length!==0){j.add(maxLengthReached?c.substr(0,j.options.maxChars):c);b.val('')}if(j.options.cancelConfirmKeysOnEmpty===false){a.preventDefault()}}var d=b.val().length,wordSpace=Math.ceil(d/5),size=d+wordSpace+1;b.attr('size',Math.max(this.inputSize,b.val().length))},j));j.$container.on('click','[data-role=remove]',$.proxy(function(a){if(j.$element.attr('disabled')){return}j.remove($(a.target).closest('.tag').data('item'))},j));if(j.options.itemValue===o.itemValue){if(j.$element[0].tagName==='INPUT'){j.add(j.$element.val())}else{$('option',j.$element).each(function(){j.add($(this).attr('value'),true)})}}},destroy:function(){var a=this;a.$container.off('keypress','input');a.$container.off('click','[role=remove]');a.$container.remove();a.$element.removeData('tagsinput');a.$element.show()},focus:function(){this.$input.focus()},input:function(){return this.$input},findInputWrapper:function(){var a=this.$input[0],container=this.$container[0];while(a&&a.parentNode!==container)a=a.parentNode;return $(a)}};$.fn.tagsinput=function(c,d,e){var f=[];this.each(function(){var a=$(this).data('tagsinput');if(!a){a=new TagsInput(this,c);$(this).data('tagsinput',a);f.push(a);if(this.tagName==='SELECT'){$('option',$(this)).attr('selected','selected')}$(this).val($(this).val())}else if(!c&&!d){f.push(a)}else if(a[c]!==undefined){if(a[c].length===3&&e!==undefined){var b=a[c](d,null,e)}else{var b=a[c](d)}if(b!==undefined)f.push(b)}});if(typeof c=='string'){return f.length>1?f:f[0]}else{return f}};$.fn.tagsinput.Constructor=TagsInput;function makeOptionItemFunction(b,c){if(typeof b[c]!=='function'){var d=b[c];b[c]=function(a){return a[d]}}}function makeOptionFunction(a,b){if(typeof a[b]!=='function'){var c=a[b];a[b]=function(){return c}}}var p=$('<div />');function htmlEncode(a){if(a){return p.text(a).html()}else{return''}}function doGetCaretPosition(a){var b=0;if(document.selection){a.focus();var c=document.selection.createRange();c.moveStart('character',-a.value.length);b=c.text.length}else if(a.selectionStart||a.selectionStart=='0'){b=a.selectionStart}return(b)}function keyCombinationInList(d,e){var f=false;$.each(e,function(a,b){if(typeof(b)==='number'&&d.which===b){f=true;return false}if(d.which===b.which){var c=!b.hasOwnProperty('altKey')||d.altKey===b.altKey,shift=!b.hasOwnProperty('shiftKey')||d.shiftKey===b.shiftKey,ctrl=!b.hasOwnProperty('ctrlKey')||d.ctrlKey===b.ctrlKey;if(c&&shift&&ctrl){f=true;return false}}});return f}})(window.jQuery);
/*!
 * Store local session storage
 *
 * https://github.com/marcuswestin/store.js/
 */
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.store = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
(function (global){
"use strict";module.exports=function(){function e(){try{return o in n&&n[o]}catch(e){return!1}}var t,r={},n="undefined"!=typeof window?window:global,i=n.document,o="localStorage",a="script";if(r.disabled=!1,r.version="1.3.20",r.set=function(e,t){},r.get=function(e,t){},r.has=function(e){return void 0!==r.get(e)},r.remove=function(e){},r.clear=function(){},r.transact=function(e,t,n){null==n&&(n=t,t=null),null==t&&(t={});var i=r.get(e,t);n(i),r.set(e,i)},r.getAll=function(){},r.forEach=function(){},r.serialize=function(e){return JSON.stringify(e)},r.deserialize=function(e){if("string"==typeof e)try{return JSON.parse(e)}catch(t){return e||void 0}},e())t=n[o],r.set=function(e,n){return void 0===n?r.remove(e):(t.setItem(e,r.serialize(n)),n)},r.get=function(e,n){var i=r.deserialize(t.getItem(e));return void 0===i?n:i},r.remove=function(e){t.removeItem(e)},r.clear=function(){t.clear()},r.getAll=function(){var e={};return r.forEach(function(t,r){e[t]=r}),e},r.forEach=function(e){for(var n=0;n<t.length;n++){var i=t.key(n);e(i,r.get(i))}};else if(i&&i.documentElement.addBehavior){var c,u;try{u=new ActiveXObject("htmlfile"),u.open(),u.write("<"+a+">document.w=window</"+a+'><iframe src="/favicon.ico"></iframe>'),u.close(),c=u.w.frames[0].document,t=c.createElement("div")}catch(l){t=i.createElement("div"),c=i.body}var f=function(e){return function(){var n=Array.prototype.slice.call(arguments,0);n.unshift(t),c.appendChild(t),t.addBehavior("#default#userData"),t.load(o);var i=e.apply(r,n);return c.removeChild(t),i}},d=new RegExp("[!\"#$%&'()*+,/\\\\:;<=>?@[\\]^`{|}~]","g"),s=function(e){return e.replace(/^d/,"___$&").replace(d,"___")};r.set=f(function(e,t,n){return t=s(t),void 0===n?r.remove(t):(e.setAttribute(t,r.serialize(n)),e.save(o),n)}),r.get=f(function(e,t,n){t=s(t);var i=r.deserialize(e.getAttribute(t));return void 0===i?n:i}),r.remove=f(function(e,t){t=s(t),e.removeAttribute(t),e.save(o)}),r.clear=f(function(e){var t=e.XMLDocument.documentElement.attributes;e.load(o);for(var r=t.length-1;r>=0;r--)e.removeAttribute(t[r].name);e.save(o)}),r.getAll=function(e){var t={};return r.forEach(function(e,r){t[e]=r}),t},r.forEach=f(function(e,t){for(var n,i=e.XMLDocument.documentElement.attributes,o=0;n=i[o];++o)t(n.name,r.deserialize(e.getAttribute(n.name)))})}try{var v="__storejs__";r.set(v,v),r.get(v)!=v&&(r.disabled=!0),r.remove(v)}catch(l){r.disabled=!0}return r.enabled=!r.disabled,r}();
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}]},{},[1])(1)
});
/*!
* Optiscroll.js v3.2.0
* https://github.com/wilsonfletcher/Optiscroll/
*/
!function(E,y,C,o){"use strict";var i=function t(e,i){return new t.Instance(e,i||{})},c=i.globalSettings={scrollMinUpdateInterval:25,checkFrequency:1e3,pauseCheck:!1};i.defaults={preventParentScroll:!1,forceScrollbars:!1,scrollStopDelay:300,maxTrackSize:95,minTrackSize:5,draggableTracks:!0,autoUpdate:!0,classPrefix:"optiscroll-",wrapContent:!0,rtl:!1},(i.Instance=function(t,e){this.element=t,this.settings=S(S({},i.defaults),e||{}),"boolean"!=typeof e.rtl&&(this.settings.rtl="rtl"===E.getComputedStyle(t).direction),this.cache={},this.init()}).prototype={init:function(){var t=this.element,e=this.settings,i=!1,l=this.scrollEl=e.wrapContent?u.createWrapper(t):t.firstElementChild;T(l,e.classPrefix+"content",!0),T(t,"is-enabled"+(e.rtl?" is-rtl":""),!0),this.scrollbars={v:s("v",this),h:s("h",this)},(w.scrollbarSpec.width||e.forceScrollbars)&&(i=u.hideNativeScrollbars(l,e.rtl)),i&&h(this.scrollbars,"create"),w.isTouch&&e.preventParentScroll&&T(t,e.classPrefix+"prevent",!0),this.update(),this.bind(),e.autoUpdate&&w.instances.push(this),e.autoUpdate&&!w.checkTimer&&u.checkLoop()},bind:function(){var l,s,n,r,t=this.listeners={},e=this.scrollEl;for(var i in t.scroll=(l=a.scroll.bind(this),s=c.scrollMinUpdateInterval,function(){var t=this,e=Date.now(),i=arguments;n&&e<n+s?(clearTimeout(r),r=setTimeout(function(){n=e,l.apply(t,i)},s)):(n=e,l.apply(t,i))}),w.isTouch&&(t.touchstart=a.touchstart.bind(this),t.touchend=a.touchend.bind(this)),t.mousewheel=t.wheel=a.wheel.bind(this),t)e.addEventListener(i,t[i],w.passiveEvent)},update:function(){var t=this.scrollEl,e=this.cache,i=e.clientH,l=t.scrollHeight,s=t.clientHeight,n=t.scrollWidth,r=t.clientWidth;if(l!==e.scrollH||s!==e.clientH||n!==e.scrollW||r!==e.clientW){if(e.scrollH=l,e.clientH=s,e.scrollW=n,e.clientW=r,i!==o){if(0===l&&0===s&&!y.body.contains(this.element))return this.destroy(),!1;this.fireCustomEvent("sizechange")}h(this.scrollbars,"update")}},scrollTo:function(t,e,i){var l,s,n,r,o=this.cache;w.pauseCheck=!0,this.update(),l=this.scrollEl.scrollLeft,s=this.scrollEl.scrollTop,n=+t,"left"===t&&(n=0),"right"===t&&(n=o.scrollW-o.clientW),!1===t&&(n=l),r=+e,"top"===e&&(r=0),"bottom"===e&&(r=o.scrollH-o.clientH),!1===e&&(r=s),this.animateScroll(l,n,s,r,+i)},scrollIntoView:function(t,e,i){var l,s,n,r,o,c,a,h,u,p,d,f,v=this.scrollEl;w.pauseCheck=!0,this.update(),"string"==typeof t?t=v.querySelector(t):t.length&&t.jquery&&(t=t[0]),"number"==typeof i&&(i={top:i,right:i,bottom:i,left:i}),i=i||{},l=t.getBoundingClientRect(),s=v.getBoundingClientRect(),u=d=v.scrollLeft,p=f=v.scrollTop,a=u+l.left-s.left,h=p+l.top-s.top,n=a-(i.left||0),r=h-(i.top||0),n<u&&(d=n),u<(o=a+l.width-this.cache.clientW+(i.right||0))&&(d=o),r<p&&(f=r),p<(c=h+l.height-this.cache.clientH+(i.bottom||0))&&(f=c),this.animateScroll(u,d,p,f,+e)},animateScroll:function(l,s,n,r,o){var c=this,a=this.scrollEl,h=Date.now();if(s!==l||r!==n){if(0===o)return a.scrollLeft=s,void(a.scrollTop=r);isNaN(o)&&(o=15*C.pow(C.max(C.abs(s-l),C.abs(r-n)),.54)),function t(){var e=C.min(1,(Date.now()-h)/o),i=u.easingFunction(e);r!==n&&(a.scrollTop=~~(i*(r-n))+n),s!==l&&(a.scrollLeft=~~(i*(s-l))+l),c.scrollAnimation=e<1?E.requestAnimationFrame(t):null}()}},destroy:function(){var t,e=this,i=this.element,l=this.scrollEl,s=this.listeners;if(this.scrollEl){for(var n in s)l.removeEventListener(n,s[n]);if(h(this.scrollbars,"remove"),!this.settings.contentElement){for(;t=l.childNodes[0];)i.insertBefore(t,l);i.removeChild(l),this.scrollEl=null}T(i,this.settings.classPrefix+"prevent",!1),T(i,"is-enabled",!1),E.requestAnimationFrame(function(){var t=w.instances.indexOf(e);-1<t&&w.instances.splice(t,1)})}},fireCustomEvent:function(t){var e,i,l=this.cache,s=l.scrollH,n=l.scrollW;e={scrollbarV:S({},l.v),scrollbarH:S({},l.h),scrollTop:l.v.position*s,scrollLeft:l.h.position*n,scrollBottom:(1-l.v.position-l.v.size)*s,scrollRight:(1-l.h.position-l.h.size)*n,scrollWidth:n,scrollHeight:s,clientWidth:l.clientW,clientHeight:l.clientH},"function"==typeof CustomEvent?i=new CustomEvent(t,{detail:e}):(i=y.createEvent("CustomEvent")).initCustomEvent(t,!1,!1,e),this.element.dispatchEvent(i)}};var t,e,a={scroll:function(t){w.pauseCheck||this.fireCustomEvent("scrollstart"),w.pauseCheck=!0,this.scrollbars.v.update(),this.scrollbars.h.update(),this.fireCustomEvent("scroll"),clearTimeout(this.cache.timerStop),this.cache.timerStop=setTimeout(a.scrollStop.bind(this),this.settings.scrollStopDelay)},touchstart:function(t){w.pauseCheck=!1,this.scrollbars.v.update(),this.scrollbars.h.update(),a.wheel.call(this,t)},touchend:function(t){clearTimeout(this.cache.timerStop)},scrollStop:function(){this.fireCustomEvent("scrollstop"),w.pauseCheck=!1},wheel:function(t){var e=this.cache,i=e.v,l=e.h,s=this.settings.preventParentScroll&&w.isTouch;E.cancelAnimationFrame(this.scrollAnimation),s&&i.enabled&&i.percent%100==0&&(this.scrollEl.scrollTop=i.percent?e.scrollH-e.clientH-1:1),s&&l.enabled&&l.percent%100==0&&(this.scrollEl.scrollLeft=l.percent?e.scrollW-e.clientW-1:1)}},s=function(e,i){var r="v"===e,l=i.element,o=i.scrollEl,c=i.settings,a=i.cache,n=a[e]={},t=r?"H":"W",h="client"+t,u="scroll"+t,p=r?"scrollTop":"scrollLeft",s=r?["top","bottom"]:["left","right"],d=/^(mouse|touch|pointer)/,f=w.scrollbarSpec.rtl,v=!1,m=null,g=null,b={dragData:null,dragStart:function(t){t.preventDefault();var e=t.touches?t.touches[0]:t;b.dragData={x:e.pageX,y:e.pageY,scroll:o[p]},b.bind(!0,t.type.match(d)[1])},dragMove:function(t){var e,i=t.touches?t.touches[0]:t,l=c.rtl&&1===f&&!r?-1:1;t.preventDefault(),e=(r?i.pageY-b.dragData.y:i.pageX-b.dragData.x)/a[h],o[p]=b.dragData.scroll+e*a[u]*l},dragEnd:function(t){b.dragData=null,b.bind(!1,t.type.match(d)[1])},bind:function(t,e){var i=(t?"add":"remove")+"EventListener",l=e+"move",s=e+("touch"===e?"end":"up");y[i](l,b.dragMove),y[i](s,b.dragEnd),y[i](e+"cancel",b.dragEnd)}};return{toggle:function(t){v=t,g&&T(l,"has-"+e+"track",v),n.enabled=v},create:function(){(m=y.createElement("div"),g=y.createElement("b"),m.className=c.classPrefix+e,g.className=c.classPrefix+e+"track",m.appendChild(g),l.appendChild(m),c.draggableTracks)&&(E.PointerEvent?["pointerdown"]:["touchstart","mousedown"]).forEach(function(t){g.addEventListener(t,b.dragStart)})},update:function(){var t,e,i,l,s;(v||a[h]!==a[u])&&(t=(i=this.calc()).size,e=n.size,l=1/t*i.position*100,s=C.abs(i.position-(n.position||0))*a[h],1===t&&v&&this.toggle(!1),t<1&&!v&&this.toggle(!0),g&&v&&this.style(l,s,t,e),n=S(n,i),v&&this.fireEdgeEv())},style:function(t,e,i,l){i!==l&&(g.style[r?"height":"width"]=100*i+"%",c.rtl&&!r&&(g.style.marginRight=100*(1-i)+"%")),g.style[w.cssTransform]="translate("+(r?"0%,"+t+"%":t+"%,0%")+")"},calc:function(){var t,e=o[p],i=a[h],l=a[u],s=i/l,n=l-i;return 1<=s||!l?{position:0,size:1,percent:0}:(!r&&c.rtl&&f&&(e=n-e*f),t=100*e/n,e<=1&&(t=0),n-1<=e&&(t=100),s=C.max(s,c.minTrackSize/100),{position:t/100*(1-(s=C.min(s,c.maxTrackSize/100))),size:s,percent:t})},fireEdgeEv:function(){var t=n.percent;n.was!==t&&t%100==0&&(i.fireCustomEvent("scrollreachedge"),i.fireCustomEvent("scrollreach"+s[t/100])),n.was=t},remove:function(){this.toggle(!1),m&&(m.parentNode.removeChild(m),m=null)}}},u={hideNativeScrollbars:function(t,e){var i=w.scrollbarSpec.width,l=t.style;if(0===i){var s=Date.now();return t.setAttribute("data-scroll",s),u.addCssRule('[data-scroll="'+s+'"]::-webkit-scrollbar',"display:none;width:0;height:0;")}return l[e?"left":"right"]=-i+"px",l.bottom=-i+"px",!0},addCssRule:function(t,e){var i=y.getElementById("scroll-sheet");i||((i=y.createElement("style")).id="scroll-sheet",i.appendChild(y.createTextNode("")),y.head.appendChild(i));try{return i.sheet.insertRule(t+" {"+e+"}",0),!0}catch(t){return}},createWrapper:function(t,e){for(var i,l=y.createElement("div");i=t.childNodes[0];)l.appendChild(i);return t.appendChild(l)},checkLoop:function(){w.instances.length?(w.pauseCheck||h(w.instances,"update"),c.checkFrequency&&(w.checkTimer=setTimeout(function(){u.checkLoop()},c.checkFrequency))):w.checkTimer=null},easingFunction:function(t){return--t*t*t+1}},w=i.G={isTouch:"ontouchstart"in E,cssTransition:l("transition"),cssTransform:l("transform"),scrollbarSpec:function(){var t,e,i=y.documentElement,l=0,s=1;(t=y.createElement("div")).style.cssText="overflow:scroll;width:50px;height:50px;position:absolute;left:-100px;direction:rtl",(e=y.createElement("div")).style.cssText="width:100px;height:100px",t.appendChild(e),i.appendChild(t),l=t.offsetWidth-t.clientWidth,0<t.scrollLeft?s=0:(t.scrollLeft=1,0===t.scrollLeft&&(s=-1));return i.removeChild(t),{width:l,rtl:s}}(),passiveEvent:(t=!1,e=Object.defineProperty({},"passive",{get:function(){t=!0}}),E.addEventListener("test",null,e),!!t&&{capture:!1,passive:!0}),instances:[],checkTimer:null,pauseCheck:!1};function l(t){var e=t.charAt(0).toUpperCase()+t.slice(1),i=y.createElement("test"),l=[t,"Webkit"+e];for(var s in l)if(i.style[l[s]]!==o)return l[s];return""}function T(t,e,i){var l=t.className.split(/\s+/),s=l.indexOf(e);i?~s||l.push(e):~s&&l.splice(s,1),t.className=l.join(" ")}function S(t,e,i){for(var l in e)!e.hasOwnProperty(l)||t[l]!==o&&i||(t[l]=e[l]);return t}function h(t,e,i){var l,s;if(t.length)for(l=0,s=t.length;l<s;l++)t[l][e].apply(t[l],i);else for(l in t)t[l][e].apply(t[l],i)}"function"==typeof define&&define.amd&&define(function(){return i}),"undefined"!=typeof module&&module.exports&&(module.exports=i),E.Optiscroll=i}(window,document,Math),function(n){var r="optiscroll";n.fn[r]=function(i){var l,s;return"string"==typeof i&&(s=Array.prototype.slice.call(arguments),l=s.shift()),this.each(function(){var t=n(this),e=t.data(r);e?e&&"string"==typeof l&&(e[l].apply(e,s),"destroy"===l&&t.removeData(r)):(e=new window.Optiscroll(this,i||{}),t.data(r,e))})}}(jQuery||Zepto);
/*
* EU Cookie notice
*/
jQuery.fn.extend({acceptCookies:function(options){var defaults={position:"top",textcolour:"#FFF",notice:"We use cookies to track visits to our website.",accept:"ACCEPT COOKIES",decline:"DECLINE COOKIES",whatc:"What are cookies?",decline_t:"In doing so this website may function incorrectly. Do you wish to proceed?",fontfamily:"Arial, sans-serif"};var options=$.extend(defaults,options);return this.each(function(){var o=options;if($.cookie("CMSPRO_EU_COOKIE")!=null){return $()}else{if($.cookie("CMSPRO_EU_COOKIE")!=null){return setInterval(function(){$().deleteAllCookies()},1000)}}$("body").append('<div id="accept_cookies"><div class="euinner">'+o.notice+' <span><a href="http://www.allaboutcookies.org/" target="_blank">'+o.whatc+'</a></span><div><button class="wojo positive button" id="ac_accept">'+o.accept+'</button><button class="wojo negative button" id="ac_decline">'+o.decline+"</button></div></div></div>");$("#accept_cookies").css({"background-color":"#000","z-index":999999,opacity:0.95,position:"fixed",padding:"0px",width:"100%","text-align":"center",left:0,color:o.textcolour});$(".euinner").css({padding:"30px",width:"70%",margin:"0 auto"});if(o.position=="top"){$("#accept_cookies").css("top",0)}else{$("#accept_cookies").css("bottom",0)}$("#accept_cookies span").css({display:"block","font-size":"90%",margin:"10px 0"});$("#accept_cookies a").css({"text-decoration":"underline",color:"#FFF"});$("#accept_cookies button").css({"background-color":"#7DAF3B",border:0,color:"#FFF",padding:"10px","font-weight":"bold",cursor:"pointer",margin:"0 10px"});$("#accept_cookies button#ac_decline").css({"background-color":"#D5332F",}).click(function(e){e.preventDefault();var conf=confirm(o.decline_t);if(conf){setInterval(function(){$().deleteAllCookies()},1000);window.location.href="http://google.com"}});$("#accept_cookies button#ac_accept").click(function(e){e.preventDefault();$.cookie("CMSPRO_EU_COOKIE",true,{expires:365,path:"/"});$.cookie("CMSPRO_EU_COOKIE",true,{expires:365,path:"/"});$("#accept_cookies").fadeOut()})})},deleteAllCookies:function(){var cookies=document.cookie.split(";");var ccc=document.cookie;for(var i=0;i<cookies.length;i++){var cookie=cookies[i];var eqPos=cookie.indexOf("=");var name=eqPos>-1?cookie.substr(0,eqPos):cookie;if($.trim(name)!="CMSPRO_EU_COOKIE"){$.cookie($.trim(name),null,{domain:$().getDomain(),path:"/"});$.cookie($.trim(name),null,{domain:"www."+$().getDomain(),path:"/"});$.cookie($.trim(name),null,{domain:"."+$().getDomain(),path:"/"});$.cookie($.trim(name),null,{domain:document.domain,path:"/"});$.cookie($.trim(name),null,{path:"/"})}}return $()},getDomain:function(){return window.location.hostname.replace(/([a-zA-Z0-9]+.)/,"")}});
/*!
 * jQuery Browser Plugin 0.1.0
 * https://github.com/gabceb/jquery-browser-plugin
 */!function(a){"function"==typeof define&&define.amd?define(["jquery"],function(b){return a(b)}):"object"==typeof module&&"object"==typeof module.exports?module.exports=a(require("jquery")):a(window.jQuery)}(function(a){"use strict";function b(a){void 0===a&&(a=window.navigator.userAgent),a=a.toLowerCase();var b=/(edge)\/([\w.]+)/.exec(a)||/(opr)[\/]([\w.]+)/.exec(a)||/(chrome)[ \/]([\w.]+)/.exec(a)||/(iemobile)[\/]([\w.]+)/.exec(a)||/(version)(applewebkit)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(a)||/(webkit)[ \/]([\w.]+).*(version)[ \/]([\w.]+).*(safari)[ \/]([\w.]+)/.exec(a)||/(webkit)[ \/]([\w.]+)/.exec(a)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(a)||/(msie) ([\w.]+)/.exec(a)||a.indexOf("trident")>=0&&/(rv)(?::| )([\w.]+)/.exec(a)||a.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(a)||[],c=/(ipad)/.exec(a)||/(ipod)/.exec(a)||/(windows phone)/.exec(a)||/(iphone)/.exec(a)||/(kindle)/.exec(a)||/(silk)/.exec(a)||/(android)/.exec(a)||/(win)/.exec(a)||/(mac)/.exec(a)||/(linux)/.exec(a)||/(cros)/.exec(a)||/(playbook)/.exec(a)||/(bb)/.exec(a)||/(blackberry)/.exec(a)||[],d={},e={browser:b[5]||b[3]||b[1]||"",version:b[2]||b[4]||"0",versionNumber:b[4]||b[2]||"0",platform:c[0]||""};if(e.browser&&(d[e.browser]=!0,d.version=e.version,d.versionNumber=parseInt(e.versionNumber,10)),e.platform&&(d[e.platform]=!0),(d.android||d.bb||d.blackberry||d.ipad||d.iphone||d.ipod||d.kindle||d.playbook||d.silk||d["windows phone"])&&(d.mobile=!0),(d.cros||d.mac||d.linux||d.win)&&(d.desktop=!0),(d.chrome||d.opr||d.safari)&&(d.webkit=!0),d.rv||d.iemobile){var f="msie";e.browser=f,d[f]=!0}if(d.edge){delete d.edge;var g="msedge";e.browser=g,d[g]=!0}if(d.safari&&d.blackberry){var h="blackberry";e.browser=h,d[h]=!0}if(d.safari&&d.playbook){var i="playbook";e.browser=i,d[i]=!0}if(d.bb){var j="blackberry";e.browser=j,d[j]=!0}if(d.opr){var k="opera";e.browser=k,d[k]=!0}if(d.safari&&d.android){var l="android";e.browser=l,d[l]=!0}if(d.safari&&d.kindle){var m="kindle";e.browser=m,d[m]=!0}if(d.safari&&d.silk){var n="silk";e.browser=n,d[n]=!0}return d.name=e.browser,d.platform=e.platform,d}return window.jQBrowser=b(window.navigator.userAgent),window.jQBrowser.uaMatch=b,a&&(a.browser=window.jQBrowser),window.jQBrowser});
 /*!
 * jQuery Scroll Plugin
 */
(function(jQuery,undefined){jQuery.fn.extend({customScroll:function(){var tdv=jQuery("<div><div></div></div>").css({position:"absolute",left:-1000,width:300,overflow:"scroll"}).appendTo("body"),twi=tdv.width()-tdv.find("div").width();tdv.remove();return this.each(function(){var that=jQuery(this),he=that.outerHeight(),wi=that.outerWidth();var sbp=that.css("direction")==="rtl"?"left":"right",sbf=that.css("direction")==="rtl"?"right":"left",scroller=jQuery("<div>").addClass("wojo-scroller").css({overflow:"hidden",position:"relative",height:he,width:wi,marginTop:that.css("margin-top"),marginBottom:that.css("margin-bottom"),marginLeft:that.css("margin-left"),marginRight:that.css("margin-right"),float:that.css("float"),}),scrollarea=jQuery("<div>").css({overflow:"scroll",position:"relative",height:he+twi,width:wi+twi}).appendTo(scroller),scrollareax=jQuery("<div>").css({float:sbf}).appendTo(scrollarea);that.css({overflow:"visible",height:"auto",margin:0,float:""}).after(scroller).appendTo(scrollareax);var nhe=scrollareax.outerHeight(true),ratio=Math.min(1,he/nhe);if(ratio>=1){return}var scrollbar=jQuery("<div>").addClass("wojo-scrollbar").css({height:he}).css(sbp,0).appendTo(scroller),scrollbarbutton=jQuery("<div>").addClass("wojo-scrollbarbutton").css({height:he*ratio}).css(sbp,0).appendTo(scrollbar);that.css({width:"-="+scrollbar.css("width")});scroller.scroll(function(){scroller.scrollLeft(0).scrollTop(0)});scrollarea.scroll(function(){scrollbarbutton.css({top:scrollarea.scrollTop()*ratio,height:he*ratio})});(function(){var dragging=false,pageY=null,pageX=null,top=null,timer=null;scrollbar.on("mousedown",function(e){if(e.which!==1||jQuery(e.target).hasClass("scrollbarbutton")){return}top=parseInt(scrollbarbutton.css("top"),10)+(he*ratio*(e.pageY>scrollbarbutton.offset().top?1:-1));clearTimeout(timer);timer=setTimeout(function(){top=Math.min(Math.max(0,e.pageY-scrollbar.offset().top)-he*ratio/2,he-(he*ratio));scrollbarbutton.css({top:top});scrollarea.scrollTop(Math.round(top/ratio))},300);scrollbarbutton.css({top:top});scrollarea.scrollTop(Math.round(top/ratio));return false});scrollbar.on("mouseup",function(){clearTimeout(timer)});scrollbarbutton.on("mousedown",function(e){if(e.which!==1){return}dragging=true;pageY=e.pageY;pageX=e.pageX;top=parseInt(scrollbarbutton.css("top"),10);jQuery(document).on("mousemove",function(e){if(dragging){if(Math.abs(e.pageX-pageX)<50){var newtop=Math.min(Math.max(0,top+e.pageY-pageY),he-he*ratio);scrollbarbutton.css("top",newtop);scrollarea.scrollTop(Math.round(newtop/ratio))}else{scrollarea.scrollTop(Math.round(top/ratio));scrollbarbutton.css({top:top})}return false}else{jQuery(document).unbind("mousemove")}});return false});jQuery(document).on("mouseup",function(){if(dragging){dragging=false;jQuery(document).unbind("mousemove");return false}})})()})}})})(jQuery);
/*!
 * # Semantic UI 2.4.0 - Sticky
 * http://github.com/semantic-org/semantic-ui/
 */
!function(e,t,o,n){"use strict";t=void 0!==t&&t.Math==Math?t:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.sticky=function(i){var s,r=e(this),c=r.selector||"",l=(new Date).getTime(),a=[],f=arguments[0],m="string"==typeof f,u=[].slice.call(arguments,1);return r.each(function(){var r,d,h,g,p,b=e.isPlainObject(i)?e.extend(!0,{},e.fn.sticky.settings,i):e.extend({},e.fn.sticky.settings),v=b.className,x=b.namespace,C=b.error,S="."+x,y="module-"+x,k=e(this),z=e(t),T=e(b.scrollContext),w=(k.selector,k.data(y)),B=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)},P=this;p={initialize:function(){p.determineContainer(),p.determineContext(),p.verbose("Initializing sticky",b,r),p.save.positions(),p.checkErrors(),p.bind.events(),b.observeChanges&&p.observeChanges(),p.instantiate()},instantiate:function(){p.verbose("Storing instance of module",p),w=p,k.data(y,p)},destroy:function(){p.verbose("Destroying previous instance"),p.reset(),h&&h.disconnect(),g&&g.disconnect(),z.off("load"+S,p.event.load).off("resize"+S,p.event.resize),T.off("scrollchange"+S,p.event.scrollchange),k.removeData(y)},observeChanges:function(){"MutationObserver"in t&&(h=new MutationObserver(p.event.documentChanged),g=new MutationObserver(p.event.changed),h.observe(o,{childList:!0,subtree:!0}),g.observe(P,{childList:!0,subtree:!0}),g.observe(d[0],{childList:!0,subtree:!0}),p.debug("Setting up mutation observer",g))},determineContainer:function(){r=b.container?e(b.container):k.offsetParent()},determineContext:function(){0!==(d=b.context?e(b.context):r).length||p.error(C.invalidContext,b.context,k)},checkErrors:function(){if(p.is.hidden()&&p.error(C.visible,k),p.cache.element.height>p.cache.context.height)return p.reset(),void p.error(C.elementSize,k)},bind:{events:function(){z.on("load"+S,p.event.load).on("resize"+S,p.event.resize),T.off("scroll"+S).on("scroll"+S,p.event.scroll).on("scrollchange"+S,p.event.scrollchange)}},event:{changed:function(e){clearTimeout(p.timer),p.timer=setTimeout(function(){p.verbose("DOM tree modified, updating sticky menu",e),p.refresh()},100)},documentChanged:function(t){[].forEach.call(t,function(t){t.removedNodes&&[].forEach.call(t.removedNodes,function(t){(t==P||e(t).find(P).length>0)&&(p.debug("Element removed from DOM, tearing down events"),p.destroy())})})},load:function(){p.verbose("Page contents finished loading"),B(p.refresh)},resize:function(){p.verbose("Window resized"),B(p.refresh)},scroll:function(){B(function(){T.triggerHandler("scrollchange"+S,T.scrollTop())})},scrollchange:function(e,t){p.stick(t),b.onScroll.call(P)}},refresh:function(e){p.reset(),b.context||p.determineContext(),e&&p.determineContainer(),p.save.positions(),p.stick(),b.onReposition.call(P)},supports:{sticky:function(){var t=e("<div/>");t[0];return t.addClass(v.supported),t.css("position").match("sticky")}},save:{lastScroll:function(e){p.lastScroll=e},elementScroll:function(e){p.elementScroll=e},positions:function(){var e={height:T.height()},t={margin:{top:parseInt(k.css("margin-top"),10),bottom:parseInt(k.css("margin-bottom"),10)},offset:k.offset(),width:k.outerWidth(),height:k.outerHeight()},o={offset:d.offset(),height:d.outerHeight()};r.outerHeight();p.is.standardScroll()||(p.debug("Non-standard scroll. Removing scroll offset from element offset"),e.top=T.scrollTop(),e.left=T.scrollLeft(),t.offset.top+=e.top,o.offset.top+=e.top,t.offset.left+=e.left,o.offset.left+=e.left),p.cache={fits:t.height+b.offset<=e.height,sameHeight:t.height==o.height,scrollContext:{height:e.height},element:{margin:t.margin,top:t.offset.top-t.margin.top,left:t.offset.left,width:t.width,height:t.height,bottom:t.offset.top+t.height},context:{top:o.offset.top,height:o.height,bottom:o.offset.top+o.height}},p.set.containerSize(),p.stick(),p.debug("Caching element positions",p.cache)}},get:{direction:function(e){var t="down";return e=e||T.scrollTop(),p.lastScroll!==n&&(p.lastScroll<e?t="down":p.lastScroll>e&&(t="up")),t},scrollChange:function(e){return e=e||T.scrollTop(),p.lastScroll?e-p.lastScroll:0},currentElementScroll:function(){return p.elementScroll?p.elementScroll:p.is.top()?Math.abs(parseInt(k.css("top"),10))||0:Math.abs(parseInt(k.css("bottom"),10))||0},elementScroll:function(e){e=e||T.scrollTop();var t=p.cache.element,o=p.cache.scrollContext,n=p.get.scrollChange(e),i=t.height-o.height+b.offset,s=p.get.currentElementScroll(),r=s+n;return s=p.cache.fits||r<0?0:r>i?i:r}},remove:{lastScroll:function(){delete p.lastScroll},elementScroll:function(e){delete p.elementScroll},minimumSize:function(){r.css("min-height","")},offset:function(){k.css("margin-top","")}},set:{offset:function(){p.verbose("Setting offset on element",b.offset),k.css("margin-top",b.offset)},containerSize:function(){var e=r.get(0).tagName;"HTML"===e||"body"==e?p.determineContainer():Math.abs(r.outerHeight()-p.cache.context.height)>b.jitter&&(p.debug("Context has padding, specifying exact height for container",p.cache.context.height),r.css({height:p.cache.context.height}))},minimumSize:function(){var e=p.cache.element;r.css("min-height",e.height)},scroll:function(e){p.debug("Setting scroll on element",e),p.elementScroll!=e&&(p.is.top()&&k.css("bottom","").css("top",-e),p.is.bottom()&&k.css("top","").css("bottom",e))},size:function(){0!==p.cache.element.height&&0!==p.cache.element.width&&(P.style.setProperty("width",p.cache.element.width+"px","important"),P.style.setProperty("height",p.cache.element.height+"px","important"))}},is:{standardScroll:function(){return T[0]==t},top:function(){return k.hasClass(v.top)},bottom:function(){return k.hasClass(v.bottom)},initialPosition:function(){return!p.is.fixed()&&!p.is.bound()},hidden:function(){return!k.is(":visible")},bound:function(){return k.hasClass(v.bound)},fixed:function(){return k.hasClass(v.fixed)}},stick:function(e){var t=e||T.scrollTop(),o=p.cache,n=o.fits,i=o.sameHeight,s=o.element,r=o.scrollContext,c=o.context,l=p.is.bottom()&&b.pushing?b.bottomOffset:b.offset,a=(e={top:t+l,bottom:t+l+r.height},p.get.direction(e.top),n?0:p.get.elementScroll(e.top)),f=!n;0!==s.height&&!i&&(p.is.initialPosition()?e.top>=c.bottom?(p.debug("Initial element position is bottom of container"),p.bindBottom()):e.top>s.top&&(s.height+e.top-a>=c.bottom?(p.debug("Initial element position is bottom of container"),p.bindBottom()):(p.debug("Initial element position is fixed"),p.fixTop())):p.is.fixed()?p.is.top()?e.top<=s.top?(p.debug("Fixed element reached top of container"),p.setInitialPosition()):s.height+e.top-a>=c.bottom?(p.debug("Fixed element reached bottom of container"),p.bindBottom()):f&&(p.set.scroll(a),p.save.lastScroll(e.top),p.save.elementScroll(a)):p.is.bottom()&&(e.bottom-s.height<=s.top?(p.debug("Bottom fixed rail has reached top of container"),p.setInitialPosition()):e.bottom>=c.bottom?(p.debug("Bottom fixed rail has reached bottom of container"),p.bindBottom()):f&&(p.set.scroll(a),p.save.lastScroll(e.top),p.save.elementScroll(a))):p.is.bottom()&&(e.top<=s.top?(p.debug("Jumped from bottom fixed to top fixed, most likely used home/end button"),p.setInitialPosition()):b.pushing?p.is.bound()&&e.bottom<=c.bottom&&(p.debug("Fixing bottom attached element to bottom of browser."),p.fixBottom()):p.is.bound()&&e.top<=c.bottom-s.height&&(p.debug("Fixing bottom attached element to top of browser."),p.fixTop())))},bindTop:function(){p.debug("Binding element to top of parent container"),p.remove.offset(),k.css({left:"",top:"",marginBottom:""}).removeClass(v.fixed).removeClass(v.bottom).addClass(v.bound).addClass(v.top),b.onTop.call(P),b.onUnstick.call(P)},bindBottom:function(){p.debug("Binding element to bottom of parent container"),p.remove.offset(),k.css({left:"",top:""}).removeClass(v.fixed).removeClass(v.top).addClass(v.bound).addClass(v.bottom),b.onBottom.call(P),b.onUnstick.call(P)},setInitialPosition:function(){p.debug("Returning to initial position"),p.unfix(),p.unbind()},fixTop:function(){p.debug("Fixing element to top of page"),b.setSize&&p.set.size(),p.set.minimumSize(),p.set.offset(),k.css({left:p.cache.element.left,bottom:"",marginBottom:""}).removeClass(v.bound).removeClass(v.bottom).addClass(v.fixed).addClass(v.top),b.onStick.call(P)},fixBottom:function(){p.debug("Sticking element to bottom of page"),b.setSize&&p.set.size(),p.set.minimumSize(),p.set.offset(),k.css({left:p.cache.element.left,bottom:"",marginBottom:""}).removeClass(v.bound).removeClass(v.top).addClass(v.fixed).addClass(v.bottom),b.onStick.call(P)},unbind:function(){p.is.bound()&&(p.debug("Removing container bound position on element"),p.remove.offset(),k.removeClass(v.bound).removeClass(v.top).removeClass(v.bottom))},unfix:function(){p.is.fixed()&&(p.debug("Removing fixed position on element"),p.remove.minimumSize(),p.remove.offset(),k.removeClass(v.fixed).removeClass(v.top).removeClass(v.bottom),b.onUnstick.call(P))},reset:function(){p.debug("Resetting elements position"),p.unbind(),p.unfix(),p.resetCSS(),p.remove.offset(),p.remove.lastScroll()},resetCSS:function(){k.css({width:"",height:""}),r.css({height:""})},setting:function(t,o){if(e.isPlainObject(t))e.extend(!0,b,t);else{if(o===n)return b[t];b[t]=o}},internal:function(t,o){if(e.isPlainObject(t))e.extend(!0,p,t);else{if(o===n)return p[t];p[t]=o}},debug:function(){!b.silent&&b.debug&&(b.performance?p.performance.log(arguments):(p.debug=Function.prototype.bind.call(console.info,console,b.name+":"),p.debug.apply(console,arguments)))},verbose:function(){!b.silent&&b.verbose&&b.debug&&(b.performance?p.performance.log(arguments):(p.verbose=Function.prototype.bind.call(console.info,console,b.name+":"),p.verbose.apply(console,arguments)))},error:function(){b.silent||(p.error=Function.prototype.bind.call(console.error,console,b.name+":"),p.error.apply(console,arguments))},performance:{log:function(e){var t,o;b.performance&&(o=(t=(new Date).getTime())-(l||t),l=t,a.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:P,"Execution Time":o})),clearTimeout(p.performance.timer),p.performance.timer=setTimeout(p.performance.display,0)},display:function(){var t=b.name+":",o=0;l=!1,clearTimeout(p.performance.timer),e.each(a,function(e,t){o+=t["Execution Time"]}),t+=" "+o+"ms",c&&(t+=" '"+c+"'"),(console.group!==n||console.table!==n)&&a.length>0&&(console.groupCollapsed(t),console.table?console.table(a):e.each(a,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),a=[]}},invoke:function(t,o,i){var r,c,l,a=w;return o=o||u,i=P||i,"string"==typeof t&&a!==n&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(o,i){var s=o!=r?i+t[o+1].charAt(0).toUpperCase()+t[o+1].slice(1):t;if(e.isPlainObject(a[s])&&o!=r)a=a[s];else{if(a[s]!==n)return c=a[s],!1;if(!e.isPlainObject(a[i])||o==r)return a[i]!==n&&(c=a[i],!1);a=a[i]}})),e.isFunction(c)?l=c.apply(i,o):c!==n&&(l=c),e.isArray(s)?s.push(l):s!==n?s=[s,l]:l!==n&&(s=l),c}},m?(w===n&&p.initialize(),p.invoke(f)):(w!==n&&w.invoke("destroy"),p.initialize())}),s!==n?s:this},e.fn.sticky.settings={name:"Sticky",namespace:"sticky",silent:!1,debug:!1,verbose:!0,performance:!0,pushing:!1,context:!1,container:!1,scrollContext:t,offset:0,bottomOffset:0,jitter:5,setSize:!0,observeChanges:!1,onReposition:function(){},onScroll:function(){},onStick:function(){},onUnstick:function(){},onTop:function(){},onBottom:function(){},error:{container:"Sticky element must be inside a relative container",visible:"Element is hidden, you must call refresh after element becomes visible. Use silent setting to surpress this warning in production.",method:"The method you called is not defined.",invalidContext:"Context specified does not exist",elementSize:"Sticky element is larger than its container, cannot create sticky."},className:{bound:"bound",fixed:"fixed",supported:"native",top:"top",bottom:"bottom"}}}(jQuery,window,document);
/**
 * paralax
 */
(function($){var $window=$(window),windowHeight=$window.height();$window.resize(function(){windowHeight=$window.height()});$.fn.paralax=function(params){defaults={speed:0.2,mode:'background',xpos:'50%',outer:true,offset:0};function getHeight(el){return params.outer?el.outerHeight(true):el.height()};params=$.extend({},defaults,params);$(this).each(function(){var $this=$(this),firstTop=$this.offset().top;function update(){var pos=$window.scrollTop(),top=$this.offset().top,height=getHeight($this),ypos=0;if(top+height<pos||top>pos+windowHeight){return}ypos=(firstTop-pos)*params.speed+params.offset;if(params.mode=='background'){$this.css('background-position',params.xpos+' '+ypos+'px')}else if(params.mode=='transform'){$this.css({'-webkit-transform':'translate(0,'+ypos+'px)','-moz-transform':'translate(0,'+ypos+'px)','-ms-transform':'translate(0,'+ypos+'px)','transform':'translate(0,'+ypos+'px)'})}else if(typeof params.mode==='function'){params.mode(params.xpos,ypos)}}$window.on('scroll',update).resize(update);update()})}})(jQuery);
/*!
 * jQuery UI Touch Punch 0.2.3
 *
 * Copyright 2011–2014, Dave Furfero
 * Dual licensed under the MIT or GPL Version 2 licenses.
 */
!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent("MouseEvents");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch="ontouchend"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,"mouseover"),f(a,"mousemove"),f(a,"mousedown"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,"mousemove"))},b._touchEnd=function(a){e&&(f(a,"mouseup"),f(a,"mouseout"),this._touchMoved||f(a,"click"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,"_touchStart"),touchmove:a.proxy(b,"_touchMove"),touchend:a.proxy(b,"_touchEnd")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,"_touchStart"),touchmove:a.proxy(b,"_touchMove"),touchend:a.proxy(b,"_touchEnd")}),d.call(b)}}}(jQuery);
/**
 * Debug Console
 */
function appSetCookie(state,tab){$.cookie("debugBarState",state);if(tab!==null){$.cookie("debugBarTab",tab)}}function appGetCookie(name){if(document.cookie.length>0){start_c=document.cookie.indexOf(name+"=");if(start_c!=-1){start_c+=(name.length+1);end_c=document.cookie.indexOf(";",start_c);if(end_c==-1){end_c=document.cookie.length}return unescape(document.cookie.substring(start_c,end_c))}}return""}function appTabsMiddle(){appExpandTabs("middle",appGetCookie("debugBarTab"))}function appTabsMaximize(){appExpandTabs("max",appGetCookie("debugBarTab"))}function appTabsMinimize(){appExpandTabs("min","General")}function appExpandTabs(act,key){var arrDebugTabs=["General","Params","Warnings","Errors","Queries"];var debugTabsHeight="200px";if(act=="max"){debugTabsHeight="500px"}else{if(act=="middle"){debugTabsHeight="200px"}else{if(act=="min"){debugTabsHeight="0px"}else{if(act=="auto"){if(debugTabsHeight=="0px"){debugTabsHeight="200px";act="middle"}else{if(debugTabsHeight=="200px"){act="middle"}else{if(debugTabsHeight=="500px"){act="max"}}}}}}}keyTab=(key==null)?"General":key;$("#debugArrowExpand").css("display",((act=="max")?"none":(act=="middle")?"none":""));$("#debugArrowCollapse").css("display",((act=="max")?"":(act=="middle")?"":"none"));$("#debugArrowMaximize").css("display",((act=="max")?"none":(act=="middle")?"":""));$("#debugArrowMinimize").css("display",((act=="max")?"":(act=="middle")?"none":"none"));for(var i=0;i<arrDebugTabs.length;i++){if(act=="min"||arrDebugTabs[i]!=keyTab){$("#content"+arrDebugTabs[i]).css("display","none");$("#tab"+arrDebugTabs[i]).css("color","#bbb")}}if(act!="min"){$("#content"+keyTab).css("display","");$("#content"+keyTab).css({"overflow-y":"auto",height:debugTabsHeight});$("#tab"+keyTab).css("color","#222")}$("#debug-panel").css("opacity",(act=="min")?"0.9":"1");appSetCookie(act,key)};