<?php echo APFrmErrHelp::showErrorsNotice($errors); ?>

<?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="form-body">
    <h3>Drag and Drop to Sort Result Types</h3>
    <?php echo Form::select('lang', ['' => 'Select Language']+$languages, 'en', array('class'=>'form-control', 'id'=>'lang', 'onchange'=>'refreshResultTypeSortData();')); ?>

    <div id="resultTypeSortDataDiv"></div>
</div>
<?php $__env->startPush('scripts'); ?> 
<script>
    $(document).ready(function () {
        refreshResultTypeSortData();
    });
    function refreshResultTypeSortData() {
        var language = $('#lang').val();
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('result.type.sort.data')); ?>",
            data: {lang: language},
            success: function (responseData) {
                $("#resultTypeSortDataDiv").html('');
                $("#resultTypeSortDataDiv").html(responseData);
                /**************************/
                $('#sortable').sortable({
                    update: function (event, ui) {
                        var resultTypeOrder = $(this).sortable('toArray').toString();
                        $.post("<?php echo e(route('result.type.sort.update')); ?>", {resultTypeOrder: resultTypeOrder, _method: 'PUT', _token: '<?php echo e(csrf_token()); ?>'})
                    }
                });
                $("#sortable").disableSelection();
                /***************************/
            }
        });
    }
</script> 
<?php $__env->stopPush(); ?><?php /**PATH /home/piratest/sharjeelanjum.com/demos/jobsportal-update/resources/views/admin/result_type/forms/sort.blade.php ENDPATH**/ ?>