
<?php $__env->startSection('content'); ?>
<!-- Header start -->
<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Header end --> 
<!-- Inner Page Title start -->
<?php echo $__env->make('includes.inner_page_title', ['page_title'=>__('Company Posted Jobs')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Inner Page Title end -->
<div class="listpgWraper">
    <div class="container">
        <div class="row">
            <?php echo $__env->make('includes.company_dashboard_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="col-lg-9"> 
                <div class="myads">
                    <h3><?php echo e(__('Company Posted Jobs')); ?></h3>
                    <ul class="searchList">
                        <!-- job start --> 
                        <?php if(isset($jobs) && count($jobs)): ?>
                        <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $company = $job->getCompany(); ?>
                        <?php if(null !== $company): ?>
                        <li id="job_li_<?php echo e($job->id); ?>">
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="jobimg"><?php echo e($company->printCompanyImage()); ?></div>
                                    <div class="jobinfo">
                                        <h3><a href="<?php echo e(route('job.detail', [$job->slug])); ?>" title="<?php echo e($job->title); ?>"><?php echo e($job->title); ?></a></h3>
                                        <div class="companyName"><a href="<?php echo e(route('company.detail', $company->slug)); ?>" title="<?php echo e($company->name); ?>"><?php echo e($company->name); ?></a></div>
                                        <div class="location">
                                            <label class="fulltime" title="<?php echo e($job->getJobShift('job_shift')); ?>"><?php echo e($job->getJobShift('job_shift')); ?></label>
                                            - <span><?php echo e($job->getCity('city')); ?></span></div>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>


                                <div class="col-md-5">
                                <div class="d-flex justify-content-end">
                                    <a class="btn btn-primary me-2" href="<?php echo e(route('list.applied.users', [$job->id])); ?>"><?php echo e(__('List Candidates')); ?></a>
                                    <div class="btn-group">
                                    <button type="button" class="btn btn-bars dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <li><a class="dropdown-item" href="<?php echo e(route('list.favourite.applied.users', [$job->id])); ?>"><?php echo e(__('List Short Listed Candidates')); ?></a></li>                                    
                                        <li><a class="dropdown-item" href="<?php echo e(route('list.hired.users', [$job->id])); ?>"><?php echo e(__('List Hired Candidates')); ?></a></li>
                                        <li><a class="dropdown-item" href="<?php echo e(route('rejected-users', [$job->id])); ?>"><?php echo e(__('List Rejected Candidates')); ?></a></li>
                                        <li><a class="dropdown-item" href="<?php echo e(route('edit.front.job', [$job->id])); ?>"><?php echo e(__('Edit')); ?></a></li>
                                        <li><a class="dropdown-item" href="javascript:;" onclick="deleteJob(<?php echo e($job->id); ?>);"><?php echo e(__('Delete')); ?></a></li>
                                    </ul>
                                    </div>
                                 </div>


                                    
                                </div>
                            </div>
                        </li>
                        <!-- job end --> 
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
					
					
					 <!-- Pagination Start -->

                    <div class="pagiWrap">

                        <div class="row">

                            <div class="col-md-5">

                                <div class="showreslt">

                                    <?php echo e(__('Showing Jobs')); ?> : <?php echo e($jobs->firstItem()); ?> - <?php echo e($jobs->lastItem()); ?> <?php echo e(__('Total')); ?> <?php echo e($jobs->total()); ?>


                                </div>

                            </div>

                            <div class="col-md-7 text-right">

                                <?php if(isset($jobs) && count($jobs)): ?>

                                <?php echo e($jobs->appends(request()->query())->links()); ?>


                                <?php endif; ?>

                            </div>

                        </div>

                    </div>

                    <!-- Pagination end --> 
					
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    function deleteJob(id) {
    var msg = 'Are you sure?';
    if (confirm(msg)) {
    $.post("<?php echo e(route('delete.front.job')); ?>", {id: id, _method: 'DELETE', _token: '<?php echo e(csrf_token()); ?>'})
            .done(function (response) {
            if (response == 'ok')
            {
            $('#job_li_' + id).remove();
            } else
            {
            alert('Request Failed!');
            }
            });
    }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp7\htdocs\jobsportal\resources\views/job/company_posted_jobs.blade.php ENDPATH**/ ?>