<?php
class ControllerExtensionModuleEmployerlinks extends Controller {
	public function index() {
		$this->load->language('extension/module/employerlinks');

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_register'] = $this->language->get('text_register');
		$data['text_login'] = $this->language->get('text_login');
		$data['text_logout'] = $this->language->get('text_logout');
		$data['text_forgotten'] = $this->language->get('text_forgotten');
		$data['text_account'] = $this->language->get('text_account');
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_password'] = $this->language->get('text_password');
		$data['text_dashboard'] = $this->language->get('text_dashboard');
		$data['text_submitjobs'] = $this->language->get('text_submitjobs');
		$data['text_submitjob'] = $this->language->get('text_submitjob');
		$data['text_applyjob'] = $this->language->get('text_applyjob');
		$data['text_invoice'] = $this->language->get('text_invoice');
		$data['text_renew'] = $this->language->get('text_renew');

		$data['logged'] = $this->company->isLogged();
		$data['register'] = $this->url->link('company/register', '', true);
		$data['login'] = $this->url->link('employ/login', '', true);
		$data['logout'] = $this->url->link('company/logout', '', true);
		$data['forgotten'] = $this->url->link('company/forgotten', '', true);
		$data['account'] = $this->url->link('company/dashboard', '', true);
		$data['edit'] = $this->url->link('company/editcompany', '', true);
		$data['password'] = $this->url->link('company/changepassword', '', true);
		$data['submitjobs'] = $this->url->link('company/jobsubmitlist', '', true);
		$data['renew'] = $this->url->link('company/memberplans', '', true);

		//job limit start
		$this->load->model('job/job');

		$data['paymentsettingstatus'] = $this->config->get('paymentsetting_status');
		
		if($data['paymentsettingstatus'] == 1){
			
			$proagent_info = $this->model_job_job->getCompanyemail($this->company->getId());
			$planslimit = $this->model_job_job->getjoblimit($filter_data);
			$planssetlimit = $this->model_job_job->getjobsetlimit($filter_data);

			if(!empty($planssetlimit['expiry_date'])){
				$data['expirydate'] = $planssetlimit['expiry_date'];
			} else {
				$data['expirydate'] = '';
			}

			$data['currentdate'] = date("Y-m-d");

			$dayofreturn = $planslimit['no_of_day'];
			$daytype = $planslimit['type'];

			$orderdate = date('Y-m-d', strtotime($proagent_info['date_added']));
			$datesss   = strtotime("+".$dayofreturn." $daytype ", strtotime($orderdate));
			$data['expirydate']=date("Y-m-d", $datesss);

		}
			
		//job limit end

		$this->load->model('job/company');
		if($data['paymentsettingstatus'] == 1){
			$companyinfo = $this->model_job_company->getOrderprice($this->company->getId());
			if($companyinfo['order_status_id'] == 5 && $companyinfo['company_id']){
				$data['invoice'] = $this->url->link('company/invoice', '', true);
				$data['invoiceshow'] = $companyinfo['order_status_id'];
			}
		}	



		return $this->load->view('extension/module/employerlinks', $data);
	}
}