<?php  
class Controllercompanyinvoice extends Controller {
 	private $error = array();

 	public function index() {
	 	
		if (!$this->company->isLogged()) {
			$this->response->redirect($this->url->link('employ/login', '', true));
		}

		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
		$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');
		$this->load->language('company/invoice');
		$this->load->model('job/company');
		$this->load->model('tool/image');	

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('agent/viewagent')
		);

		$data['title'] = $this->language->get('entry_invoice');

		if ($this->request->server['HTTPS']) {
			$data['base'] = HTTPS_SERVER;
		} else {
			$data['base'] = HTTP_SERVER;
		}

		$data['direction'] = $this->language->get('direction');
		$data['lang'] = $this->language->get('code');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$this->document->setTitle($this->language->get('heading_title'));

		$data['heading_title'] 			= $this->language->get('heading_title');

		$data['entry_invoice']				= $this->language->get('entry_invoice');
		$data['entry_company']				= $this->language->get('entry_company');
		$data['entry_plandetail']				= $this->language->get('entry_plandetail');
		$data['entry_companydetail']				= $this->language->get('entry_companydetail');
		$data['entry_agentname'] 		= $this->language->get('entry_agentname');
	 	$data['entry_plans'] 			= $this->language->get('entry_plans');
		$data['entry_email'] 			= $this->language->get('entry_email');
		$data['entry_positions'] 		= $this->language->get('entry_positions');
		$data['entry_address'] 		= $this->language->get('entry_address');
		$data['entry_propertylimit'] 		= $this->language->get('entry_propertylimit');
		$data['entry_contact'] 		= $this->language->get('entry_contact');
		$data['entry_price'] 		= $this->language->get('entry_price');
		$data['entry_pstatus'] 		= $this->language->get('entry_pstatus');
		$data['entry_planstart'] 		= $this->language->get('entry_planstart');
		$data['entry_orderstatus'] 		= $this->language->get('entry_orderstatus');
		$data['entry_planend'] 		= $this->language->get('entry_planend');
		$data['entry_top'] 		= $this->language->get('entry_top');
		$data['entry_bottom'] 		= $this->language->get('entry_bottom');
		$data['entry_feature'] 		= $this->language->get('entry_feature');
		$data['entry_email'] 		= $this->language->get('entry_email');
		$data['entry_status'] 		= $this->language->get('entry_status');
		$data['entry_startdate'] 		= $this->language->get('entry_startdate');
		$data['entry_enddate'] 		= $this->language->get('entry_enddate');
		$data['entry_total'] 		= $this->language->get('entry_total');
		
		$data['text_descriptions'] 	    = $this->language->get('text_descriptions');
		$data['text_country'] 			= $this->language->get('text_country');
		$data['text_city'] 				= $this->language->get('text_city');
		$data['text_image'] 			= $this->language->get('text_image');
		$data['text_address'] 			= $this->language->get('text_address');
		$data['text_contact'] 			= $this->language->get('text_contact');
		$data['text_country']			= $this->language->get('text_country');
		$data['text_zone'] 				= $this->language->get('text_zone');
		$data['text_print'] 				= $this->language->get('text_print');
		$data['text_postcode']			= $this->language->get('text_postcode');
		$data['entry_qty'] 				= $this->language->get('entry_qty');
		$data['entry_open'] 				= $this->language->get('entry_open');
		$data['entry_close'] 				= $this->language->get('entry_close');
		$data['entry_website'] 				= $this->language->get('entry_website');
		$data['entry_orderstatus'] 				= $this->language->get('entry_orderstatus');

		$this->load->model('tool/image');

      //	$agents_info=$this->model_job_company->getShowAgent($this->agent->getId());

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
            $server = $this->config->get('config_ssl');
        } else {
            $server = $this->config->get('config_url');
        }


		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['image'] = $server . 'image/' . $this->config->get('config_logo');
        } else {
            $data['image'] = '';
        }
		
		$agents_info=$this->model_job_company->getShowPlans($this->company->getId());
		
		if(!empty($agents_info['full_name'])){
			$data['full_name'] = $agents_info['full_name'];
		} else {
			$data['full_name'] = '';
		}

		if(!empty($agents_info['email'])){
			$data['email'] = $agents_info['email'];
		} else {
			$data['email'] = '';
		}

		if(!empty($agents_info['officeopen'])){
			$data['officeopen'] = $agents_info['officeopen'];
		} else {
			$data['officeopen'] = '';
		}

		if(!empty($agents_info['address'])){
			$data['address'] = $agents_info['address'];
		} else {
			$data['address'] = '';
		}

		if(!empty($agents_info['officeclose'])){
			$data['officeclose'] = $agents_info['officeclose'];
		} else {
			$data['officeclose'] = '';
		}

		if(!empty($agents_info['company_website'])){
			$data['company_website'] = $agents_info['company_website'];
		} else {
			$data['company_website'] = '';
		}

		if(!empty($agents_info['cell_phone'])){
			$data['cell_phone'] = $agents_info['cell_phone'];
		} else {
			$data['cell_phone'] = '';
		}

		if(!empty($agents_info['feature'])){
			$data['feature'] = $agents_info['feature'];
		} else {
			$data['feature'] = 0;
		}

		if(!empty($agents_info['job_limit'])){
			$data['job_limit'] = $agents_info['job_limit'];
		} else {
			$data['job_limit'] = 0;
		}


		if(!empty($agents_info['expiry_date'])){
			$data['expirydate'] = $agents_info['expiry_date'];
		} else {
			$data['expirydate'] = '';
		}


		if(!empty($agents_info['status'])){
			$data['status'] = $agents_info['status'];
		} else {
			$data['status'] = '';
		}

		if(isset($agents_info['order_id'])){
			$data['order_id'] = $agents_info['order_id'];
		} else {
			$data['order_id'] = '';
		}

		if(isset($agents_info['order_status_id'])){
			$order_status_id = $agents_info['order_status_id'];
		} else {
			$order_status_id = '';
		} 

		$order_statuses = $this->model_job_company->getOrderStatuse($order_status_id);
		if(!empty($order_statuses['name'])){
			$data['orderstattus'] = $order_statuses['name'];
		} else {
			$data['orderstattus'] = '';
		}

		$this->load->model('membership/plans');
		$planinfo = $this->model_membership_plans->getPlan($agents_info['plan_id']);
		if(isset($planinfo['name'])){
			$data['planname'] = $planinfo['name'];
		} else {
			$data['planname'] = '';
		}

		if(!empty($planinfo['price'])){
			$data['price'] = $this->currency->format($planinfo['price'],$this->config->get('config_currency'));
		} else {
			$data['price'] = '';
		}
	
		if(!empty($agents_info['date_added'])){
			$data['plandate'] = date('Y-m-d', strtotime($agents_info['date_added']));
		} else {
			$data['plandate'] = '';
		}
		
		if (isset($planinfo['status'])) {
			$data['status'] = $this->language->get('text_enable');
		}else{
			$data['status'] = $this->language->get('text_disable');
		}

		$data['company_id']      =$this->company->getId();
		$data['agentname']	   =$agents_info['agentname'];
		$data['email']		   =$agents_info['email'];
		$data['address']	   =$agents_info['address'];

		$this->load->model('localisation/country');
		$this->load->model('localisation/zone');
	 	$this->load->model('membership/plans');

	 	$getZone     				= $this->model_localisation_zone->getZone($agents_info['zone_id']);
		$getCountry  				= $this->model_localisation_country->getCountry($agents_info['country_id']);

		$data['country']	    	=$getCountry['name'];
		$data['zone']	    		=$getZone['name'];
		
		$data['location']			= $getCountry['name'].' '. $getZone['name'].' '. $agents_info['city'].' '.$agents_info['pincode'];
		$this->response->setOutput($this->load->view('company/invoice',$data));
	}


 }