<?php
class ControllerJobMembershipReport extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('job/membership_report');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('job/membership_report');

		$this->getList();
	}

	public function delete() {
		$this->load->language('job/membership_report');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('job/membership_report');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $member_id) {
				$this->model_job_membership_report->deleteMembershipReport($member_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . $url, true));
		}

		$this->getList();
	}

	protected function getList() {
		if (isset($this->request->get['filter_company_id'])) {
			$filter_company_id = $this->request->get['filter_company_id'];
		} else {
			$filter_company_id = '';
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';
		if (isset($this->request->get['filter_company_id'])) {
			$url .= '&filter_company_id=' . $this->request->get['filter_company_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . $url, true)
		);

		$data['add'] = $this->url->link('job/membership_report/add', 'token=' . $this->session->data['token'] . $url, true);
		$data['delete'] = $this->url->link('job/membership_report/delete', 'token=' . $this->session->data['token'] . $url, true);

		$data['membership_reports'] = array();

		$filter_data = array(
			'filter_company_id' => $filter_company_id,
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);


		$membership_report_total = $this->model_job_membership_report->getTotalMembershipReport($filter_data);

		$results = $this->model_job_membership_report->getMembershipReports($filter_data);

		foreach ($results as $result) {

			$membership_report = $this->model_job_membership_report->getCompany($result['company_id']);
			if(isset($membership_report['full_name'])){
				$cname = $membership_report['full_name'];
			} else {
				$cname ='';
			}

			$data['membership_reports'][] = array(
				'member_id' => $result['member_id'],
				'cname'           => $cname,
				'card_number'     => $result['card_number'],
				'expiry_month'    => $result['expiry_month'],
				'expiry_year'     => $result['expiry_year'],
				'date_added'      => $result['date_added'],
				
			);
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_none'] = $this->language->get('text_none');

		$data['column_company_name'] = $this->language->get('column_company_name');
		$data['column_card_number'] = $this->language->get('column_card_number');
		$data['column_expiry_month'] = $this->language->get('column_expiry_month');
		$data['column_expiry_year'] = $this->language->get('column_expiry_year');
		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_sort_order'] = $this->language->get('column_sort_order');
		$data['column_action'] = $this->language->get('column_action');
		$data['entry_company_name'] = $this->language->get('entry_company_name');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');
		$data['button_filter']= $this->language->get('button_filter');
		$data['token'] = $this->session->data['token'];


		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';
		if (isset($this->request->get['filter_company_id'])) {
			$url .= '&filter_company_id=' . $this->request->get['filter_company_id'];
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$data['sort_company_name'] = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . '&sort=company_name' . $url, true);
		$data['sort_card_number'] = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . '&sort=card_number' . $url, true);
		$data['sort_expiry_month'] = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . '&sort=expiry_month' . $url, true);
		$data['sort_expiry_year'] = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . '&sort=expiry_year' . $url, true);
		$data['sort_date_added'] = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . '&sort=date_added' . $url, true);

		$data['sort_sort_order'] = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . '&sort=sort_order' . $url, true);

		$url = '';
		if (isset($this->request->get['filter_company_id'])) {
			$url .= '&filter_company_id=' . $this->request->get['filter_company_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $membership_report_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('job/membership_report', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($membership_report_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($membership_report_total - $this->config->get('config_limit_admin'))) ? $membership_report_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $membership_report_total, ceil($membership_report_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('job/membership_report_list', $data));
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'job/membership_report')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		$this->load->model('catalog/product');

		foreach ($this->request->post['selected'] as $member_id) {
			$product_total = $this->model_catalog_product->getTotalProductsByManufacturerId($member_id);

			if ($product_total) {
				$this->error['warning'] = sprintf($this->language->get('error_product'), $product_total);
			}
		}

		return !$this->error;
	}

	public function autocomplete(){
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = '';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		$this->load->model('job/company');
			
		$filter_data = array(
		'sort'  => $sort,
		'order' => $order,
		//'filter_name' => $filter_name,
		'start' => ($page - 1) * $this->config->get('config_limit_admin'),
		'limit' => $this->config->get('config_limit_admin')
		);
		$accounts = $this->model_job_company->getCompanys($filter_data);
		foreach ($accounts as $account) {

		$json[] = array(
		'company_id'  => $account['company_id'],
		'full_name'   => strip_tags(html_entity_decode($account['full_name'], ENT_QUOTES, 'UTF-8'))
		);
		}
		$sort_order = array();

		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['full_name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

}