<?php
  /**
   * Sitemap
   *
   * @package Wojo Framework
   * @author wojoscripts.com
   * @copyright 2020
   * @version $Id: sitemap.tpl.php, v1.00 2020-05-05 10:12:05 gewa Exp $
   */
  if (!defined("_WOJO"))
      die('Direct access to this location is not allowed.');
?>
<main class="margin top">
  <?php if(File::is_File(FMODPATH . 'portfolio/_sitemap.tpl.php')):?>
  <?php include_once(FMODPATH . 'portfolio/_sitemap.tpl.php');?>
  <?php endif;?>
  <?php if(File::is_File(FMODPATH . 'digishop/_sitemap.tpl.php')):?>
  <?php include_once(FMODPATH . 'digishop/_sitemap.tpl.php');?>
  <?php endif;?>
  <?php if(File::is_File(FMODPATH . 'blog/_sitemap.tpl.php')):?>
  <?php include_once(FMODPATH . 'blog/_sitemap.tpl.php');?>
  <?php endif;?>
  <?php if(File::is_File(FMODPATH . 'shop/_sitemap.tpl.php')):?>
  <?php include_once(FMODPATH . 'shop/_sitemap.tpl.php');?>
  <?php endif;?>
  <div class="wojo-grid">
    <h2><?php echo $this->data->{'title' . Lang::$lang};?></h2>
    <p><?php echo $this->data->{'caption' . Lang::$lang};?></p>
    <div class="row big gutters">
      <div class="columns screen-50 tablet-50 mobile-100 phone-100">
        <h5><?php echo Lang::$word->ADM_PAGES;?> </h5>
        <?php if($this->pagedata):?>
        <!-- Page -->
        <div class="wojo relaxed divided list padding bottom">
          <?php foreach($this->pagedata as $row):?>
          <div class="item align middle"><i class="icon small chevron right"></i>
            <div class="content"> <a href="<?php echo Url::url('/' . $this->core->pageslug, $row->slug);?>"><?php echo $row->title;?></a></div>
          </div>
          <?php endforeach;?>
          <?php unset($row);?>
        </div>
        <?php endif;?>
        
        <!-- Portfolio -->
        <?php if($this->portadata):?>
        <h5><?php echo ucfirst($this->core->modname['portfolio']);?></h5>
        <!-- Page -->
        <div class="wojo relaxed divided list padding bottom">
          <?php foreach($this->portadata as $row):?>
          <div class="item align middle"><i class="icon small chevron right"></i>
            <div class="content"> <a href="<?php echo Url::url('/' . $this->core->modname['portfolio'], $row->slug);?>"><?php echo $row->title;?></a></div>
          </div>
          <?php endforeach;?>
          <?php unset($row);?>
        </div>
        <?php endif;?>
      </div>
      <div class="columns screen-50 tablet-50 mobile-100 phone-100"> 
        
        <!-- Blog -->
        <?php if($this->blogdata):?>
        <h5><?php echo ucfirst($this->core->modname['blog']);?></h5>
        <!-- Page -->
        <div class="wojo relaxed divided list padding bottom">
          <?php foreach($this->blogdata as $row):?>
          <div class="item align middle"><i class="icon small chevron right"></i>
            <div class="content"> <a href="<?php echo Url::url('/' . $this->core->modname['blog'], $row->slug);?>"><?php echo $row->title;?></a></div>
          </div>
          <?php endforeach;?>
          <?php unset($row);?>
        </div>
        <?php endif;?>
        
        <!-- Digishop -->
        <?php if($this->digidata):?>
        <h5><?php echo ucfirst($this->core->modname['digishop']);?></h5>
        <!-- Page -->
        <div class="wojo relaxed divided list padding bottom">
          <?php foreach($this->digidata as $row):?>
          <div class="item align middle"><i class="icon small chevron right"></i>
            <div class="content"> <a href="<?php echo Url::url('/' . $this->core->modname['digishop'], $row->slug);?>"><?php echo $row->title;?></a></div>
          </div>
          <?php endforeach;?>
          <?php unset($row);?>
        </div>
        <?php endif;?>

        
        <!-- Shop -->
        <?php if($this->shopdata):?>
        <h5><?php echo ucfirst($this->core->modname['shop']);?></h5>
        <!-- Page -->
        <div class="wojo relaxed divided list padding bottom">
          <?php foreach($this->shopdata as $row):?>
          <div class="item align middle"><i class="icon small chevron right"></i>
            <div class="content"> <a href="<?php echo Url::url('/' . $this->core->modname['shop'], $row->slug);?>"><?php echo $row->title;?></a></div>
          </div>
          <?php endforeach;?>
          <?php unset($row);?>
        </div>
        <?php endif;?>
      </div>
    </div>
  </div>
</main>