<?php echo APFrmErrHelp::showErrorsNotice($errors); ?>

<?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="form-body">
    <h3>Drag and Drop to Sort Cities</h3>
    <?php echo Form::select('lang', ['' => 'Select Language']+$languages, 'en', array('class'=>'form-control', 'id'=>'lang', 'onchange'=>'refreshCitySortData();')); ?>

    <div id="citySortDataDiv"></div>
</div>
<?php $__env->startPush('scripts'); ?> 
<script>
    $(document).ready(function () {
        refreshCitySortData();
    });
    function refreshCitySortData() {
        var language = $('#lang').val();
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('city.sort.data')); ?>",
            data: {lang: language},
            success: function (responseData) {
                $("#citySortDataDiv").html('');
                $("#citySortDataDiv").html(responseData);
                /**************************/
                $('#sortable').sortable({
                    update: function (event, ui) {
                        var cityOrder = $(this).sortable('toArray').toString();
                        $.post("<?php echo e(route('city.sort.update')); ?>", {cityOrder: cityOrder, _method: 'PUT', _token: '<?php echo e(csrf_token()); ?>'})
                    }
                });
                $("#sortable").disableSelection();
                /***************************/
            }
        });
    }
</script> 
<?php $__env->stopPush(); ?><?php /**PATH /home/piratest/sharjeelanjum.com/demos/jobsportal-update/resources/views/admin/city/forms/sort.blade.php ENDPATH**/ ?>