<?php echo APFrmErrHelp::showErrorsNotice($errors); ?>

<?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="form-body">
    <h3>Drag and Drop to Sort Job Skills</h3>
    <?php echo Form::select('lang', ['' => 'Select Language']+$languages, config('default_lang'), array('class'=>'form-control', 'id'=>'lang', 'onchange'=>'refreshJobSkillSortData();')); ?>

    <div id="jobSkillSortDataDiv"></div>
</div>
<?php $__env->startPush('scripts'); ?> 
<script>
    $(document).ready(function () {
        refreshJobSkillSortData();
    });
    function refreshJobSkillSortData() {
        var language = $('#lang').val();
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('job.skill.sort.data')); ?>",
            data: {lang: language},
            success: function (responseData) {
                $("#jobSkillSortDataDiv").html('');
                $("#jobSkillSortDataDiv").html(responseData);
                /**************************/
                $('#sortable').sortable({
                    update: function (event, ui) {
                        var jobSkillOrder = $(this).sortable('toArray').toString();
                        $.post("<?php echo e(route('job.skill.sort.update')); ?>", {jobSkillOrder: jobSkillOrder, _method: 'PUT', _token: '<?php echo e(csrf_token()); ?>'})
                    }
                });
                $("#sortable").disableSelection();
                /***************************/
            }
        });
    }
</script> 
<?php $__env->stopPush(); ?>
<?php /**PATH /home/piratest/sharjeelanjum.com/demos/jobsportal-update/resources/views/admin/job_skill/forms/sort.blade.php ENDPATH**/ ?>