<?php echo APFrmErrHelp::showErrorsNotice($errors); ?>

<?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<form class="form" id="add_edit_profile_summary" method="POST" action="<?php echo e(route('update.profile.summary', [$user->id])); ?>"><?php echo e(csrf_field()); ?>

    <div class="form-body">
        <div id="success_msg" class="has-error"></div>
        <div class="form-group" id="div_summary">
            <label for="summary" class="bold">Profile Summary</label>
            <textarea name="summary" class="form-control" id="summary" placeholder="Profile Summary"><?php echo e(old('summary', (isset($user))? $user->getProfileSummary('summary'):'')); ?></textarea>
            <span class="help-block summary-error"></span> </div>
        <button type="button" class="btn btn-large btn-primary" onClick="submitProfileSummaryForm();">Update Summary <i class="fa fa-arrow-circle-right" aria-hidden="true"></i></button>
    </div>
</form>
<?php $__env->startPush('scripts'); ?> 
<script type="text/javascript">
    function submitProfileSummaryForm() {
        var form = $('#add_edit_profile_summary');
        $.ajax({
            url: form.attr('action'),
            type: form.attr('method'),
            data: form.serialize(),
            dataType: 'json',
            success: function (json) {
                $("#success_msg").html('<span class="text text-success">Summary updated successfully</span>');
            },
            error: function (json) {
                if (json.status === 422) {
                    var resJSON = json.responseJSON;
                    $('.help-block').html('');
                    $.each(resJSON.errors, function (key, value) {
                        $('.' + key + '-error').html('<strong>' + value + '</strong>');
                        $('#div_' + key).addClass('has-error');
                    });
                } else {
                    // Error
                    // Incorrect credentials
                    // alert('Incorrect credentials. Please try again.')
                }
            }
        });
    }
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/piratest/sharjeelanjum.com/demos/jobsportal-update/resources/views/admin/user/forms/summary.blade.php ENDPATH**/ ?>