<?php echo APFrmErrHelp::showErrorsNotice($errors); ?>

<?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="form-body">
    <h3>Drag and Drop to Sort Marital Statuses</h3>
    <?php echo Form::select('lang', ['' => 'Select Language']+$languages, 'en', array('class'=>'form-control', 'id'=>'lang', 'onchange'=>'refreshMaritalStatusSortData();')); ?>

    <div id="maritalStatusSortDataDiv"></div>
</div>
<?php $__env->startPush('scripts'); ?> 
<script>
    $(document).ready(function () {
        refreshMaritalStatusSortData();
    });
    function refreshMaritalStatusSortData() {
        var language = $('#lang').val();
        $.ajax({
            type: "GET",
            url: "<?php echo e(route('marital.status.sort.data')); ?>",
            data: {lang: language},
            success: function (responseData) {
                $("#maritalStatusSortDataDiv").html('');
                $("#maritalStatusSortDataDiv").html(responseData);
                /**************************/
                $('#sortable').sortable({
                    update: function (event, ui) {
                        var maritalStatusOrder = $(this).sortable('toArray').toString();
                        $.post("<?php echo e(route('marital.status.sort.update')); ?>", {maritalStatusOrder: maritalStatusOrder, _method: 'PUT', _token: '<?php echo e(csrf_token()); ?>'})
                    }
                });
                $("#sortable").disableSelection();
                /***************************/
            }
        });
    }
</script> 
<?php $__env->stopPush(); ?><?php /**PATH /home/piratest/sharjeelanjum.com/demos/jobsportal-update/resources/views/admin/marital_status/forms/sort.blade.php ENDPATH**/ ?>